/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.util;

import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import net.minecraft.util.AxisAlignedBB;

public class VecIntUtil {
    public static final VecInt[] FORGE_DIRECTIONS = new VecInt[]{VecInt.fromDirection(MgDirection.DOWN), VecInt.fromDirection(MgDirection.UP), VecInt.fromDirection(MgDirection.NORTH), VecInt.fromDirection(MgDirection.SOUTH), VecInt.fromDirection(MgDirection.WEST), VecInt.fromDirection(MgDirection.EAST)};
    public static final VecInt[] EXTENDED_DIRECTIONS = new VecInt[]{VecInt.fromDirection(MgDirection.DOWN), VecInt.fromDirection(MgDirection.UP), VecInt.fromDirection(MgDirection.NORTH), VecInt.fromDirection(MgDirection.SOUTH), VecInt.fromDirection(MgDirection.WEST), VecInt.fromDirection(MgDirection.EAST), new VecInt(-1, -1, 0), new VecInt(1, -1, 0), new VecInt(0, -1, 1), new VecInt(0, -1, -1), new VecInt(-1, 1, 0), new VecInt(1, 1, 0), new VecInt(0, 1, 1), new VecInt(0, 1, -1), new VecInt(-1, 0, 1), new VecInt(1, 0, 1), new VecInt(1, 0, -1), new VecInt(-1, 0, -1)};
    public static final VecInt[] WIRE_DOWN = new VecInt[]{VecInt.NULL_VECTOR, VecInt.fromDirection(MgDirection.DOWN), VecInt.fromDirection(MgDirection.NORTH), VecInt.fromDirection(MgDirection.SOUTH), VecInt.fromDirection(MgDirection.WEST), VecInt.fromDirection(MgDirection.EAST), new VecInt(1, -1, 0), new VecInt(-1, -1, 0), new VecInt(0, -1, 1), new VecInt(0, -1, -1)};
    public static final VecInt[] WIRE_UP = new VecInt[]{VecInt.NULL_VECTOR, VecInt.fromDirection(MgDirection.UP), VecInt.fromDirection(MgDirection.NORTH), VecInt.fromDirection(MgDirection.SOUTH), VecInt.fromDirection(MgDirection.WEST), VecInt.fromDirection(MgDirection.EAST), new VecInt(1, 1, 0), new VecInt(-1, 1, 0), new VecInt(0, 1, 1), new VecInt(0, 1, -1)};
    public static final VecInt[] WIRE_NORTH = new VecInt[]{VecInt.NULL_VECTOR, VecInt.fromDirection(MgDirection.DOWN), VecInt.fromDirection(MgDirection.UP), VecInt.fromDirection(MgDirection.NORTH), VecInt.fromDirection(MgDirection.WEST), VecInt.fromDirection(MgDirection.EAST), new VecInt(0, 1, -1), new VecInt(0, -1, -1), new VecInt(1, 0, -1), new VecInt(-1, 0, -1)};
    public static final VecInt[] WIRE_WEST = new VecInt[]{VecInt.NULL_VECTOR, VecInt.fromDirection(MgDirection.DOWN), VecInt.fromDirection(MgDirection.UP), VecInt.fromDirection(MgDirection.NORTH), VecInt.fromDirection(MgDirection.SOUTH), VecInt.fromDirection(MgDirection.WEST), new VecInt(-1, 1, 0), new VecInt(-1, -1, 0), new VecInt(-1, 0, 1), new VecInt(-1, 0, -1)};
    public static final VecInt[] WIRE_SOUTH = new VecInt[]{VecInt.NULL_VECTOR, VecInt.fromDirection(MgDirection.DOWN), VecInt.fromDirection(MgDirection.UP), VecInt.fromDirection(MgDirection.SOUTH), VecInt.fromDirection(MgDirection.WEST), VecInt.fromDirection(MgDirection.EAST), new VecInt(0, 1, 1), new VecInt(0, -1, 1), new VecInt(1, 0, 1), new VecInt(-1, 0, 1)};
    public static final VecInt[] WIRE_EAST = new VecInt[]{VecInt.NULL_VECTOR, VecInt.fromDirection(MgDirection.DOWN), VecInt.fromDirection(MgDirection.UP), VecInt.fromDirection(MgDirection.NORTH), VecInt.fromDirection(MgDirection.SOUTH), VecInt.fromDirection(MgDirection.EAST), new VecInt(-1, 1, 0), new VecInt(-1, -1, 0), new VecInt(-1, 0, 1), new VecInt(-1, 0, -1)};

    public static VecInt getRotatedOffset(MgDirection dir, int right, int up, int forward) {
        int z;
        int y;
        int x;
        switch (dir) {
            case NORTH: {
                x = right;
                y = up;
                z = -forward;
                break;
            }
            case EAST: {
                x = forward;
                y = up;
                z = right;
                break;
            }
            case SOUTH: {
                x = -right;
                y = up;
                z = forward;
                break;
            }
            case WEST: {
                x = -forward;
                y = up;
                z = -right;
                break;
            }
            default: {
                throw new IllegalArgumentException("Rotation for vertical direction is not defined");
            }
        }
        return new VecInt(x, y, z);
    }

    public static AxisAlignedBB getAABBFromVectors(VecInt a, VecInt b) {
        int x1 = Math.min(a.getX(), b.getX());
        int x2 = Math.max(a.getX(), b.getX()) + 1;
        int y1 = Math.min(a.getY(), b.getY());
        int y2 = Math.max(a.getY(), b.getY()) + 1;
        int z1 = Math.min(a.getZ(), b.getZ());
        int z2 = Math.max(a.getZ(), b.getZ()) + 1;
        return AxisAlignedBB.func_72330_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }
}

