/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.inventory;

import CoroUtil.OldUtil;
import CoroUtil.bt.IBTAgent;
import CoroUtil.componentAI.ICoroAI;
import CoroUtil.entity.EntityTropicalFishHook;
import CoroUtil.entity.ItemTropicalFishingRod;
import CoroUtil.inventory.InventoryWrapper;
import CoroUtil.util.CoroUtilEntity;
import CoroUtil.util.CoroUtilItem;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class AIInventory {
    public GameProfile playerProfile = null;
    public FakePlayer fakePlayer = null;
    public EntityLivingBase entOwner;
    public InventoryWrapper inventory;
    public int slot_Active = 0;
    public int slot_Count = 13;
    public static int slot_Melee = 0;
    public static int slot_Ranged = 1;
    public static int slot_Tool = 2;
    public EntityTropicalFishHook fishEntity;
    public boolean grabItems = false;

    public AIInventory(EntityLivingBase parEnt) {
        this.entOwner = parEnt;
        this.inventory = new InventoryWrapper();
        this.inventory.invInitData(new ItemStack[this.slot_Count]);
    }

    public static AIInventory getInventory(EntityLivingBase parEntSource) {
        if (parEntSource instanceof ICoroAI) {
            return ((ICoroAI)parEntSource).getAIAgent().entInv;
        }
        if (parEntSource instanceof IBTAgent) {
            return ((IBTAgent)parEntSource).getAIBTAgent().entInv;
        }
        return null;
    }

    public FakePlayer getFakePlayer(World parWorld) {
        if (this.fakePlayer == null) {
            this.playerProfile = new GameProfile(UUID.fromString("41C82C87-7AfB-4024-BA57-13D2C99CAE77"), "fakePlayer" + this.entOwner.func_145782_y());
            this.fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)parWorld), (GameProfile)this.playerProfile);
            if (this.entOwner instanceof ICoroAI) {
                OldUtil.playerToCompAILookup.put(CoroUtilEntity.getName((Entity)this.fakePlayer), ((ICoroAI)this.entOwner).getAIAgent().entInt);
            } else if (this.entOwner instanceof IBTAgent) {
                System.out.println("TODO: add lookup for fakeplayer to AIBTAgent");
            }
        }
        this.fakePlayer.func_70107_b(this.entOwner.field_70165_t, this.entOwner.field_70163_u, this.entOwner.field_70161_v);
        this.fakePlayer.field_70125_A = this.entOwner.field_70125_A;
        this.fakePlayer.field_70177_z = this.entOwner.field_70177_z;
        this.fakePlayer.field_70759_as = this.entOwner.field_70759_as;
        return this.fakePlayer;
    }

    public void setSlotContents(int parSlot, ItemStack parStack) {
        this.inventory.func_70299_a(parSlot, parStack);
        this.syncToClient();
    }

    public void setSlotActive(int parSlot) {
        int oldSlot = this.slot_Active;
        this.slot_Active = parSlot;
        if (this.slot_Active != oldSlot) {
            this.syncToClient();
        }
    }

    public int getSlotActive() {
        return this.slot_Active;
    }

    public ItemStack getActiveItem() {
        return this.inventory.func_70301_a(this.slot_Active);
    }

    public void attackMelee(Entity ent, float dist) {
        this.setSlotActive(slot_Melee);
        this.performLeftClick(ent, dist);
    }

    public void attackRanged(Entity ent, float dist) {
        this.setSlotActive(slot_Ranged);
        this.performRightClick();
    }

    public NBTTagCompound nbtWrite() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.invList.length; ++i) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            if (this.inventory.invList[i] != null) {
                this.inventory.invList[i].func_77955_b(nbttagcompound1);
            }
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("listInv", (NBTBase)nbttaglist);
        return nbt;
    }

    public void nbtRead(NBTTagCompound parNBT) {
        if (parNBT.func_150297_b("listInv", 9)) {
            NBTTagList nbttaglist = parNBT.func_150295_c("listInv", 10);
            for (int i = 0; i < this.inventory.invList.length; ++i) {
                this.inventory.invList[i] = ItemStack.func_77949_a((NBTTagCompound)nbttaglist.func_150305_b(i));
            }
        }
    }

    public void performLeftClick(Entity ent, float dist) {
        Item item;
        ItemStack is = this.getActiveItem();
        if (is != null && (item = is.func_77973_b()) != null) {
            float dmg = 0.0f;
            dmg = CoroUtilItem.getLeftClickDamage(is);
            ent.func_70097_a(DamageSource.func_76365_a((EntityPlayer)this.getFakePlayer(this.entOwner.field_70170_p)), dmg);
        }
    }

    public void performRightClick() {
        Item item;
        ItemStack is = this.getActiveItem();
        if (is != null && (item = is.func_77973_b()) != null) {
            if (item instanceof ItemTropicalFishingRod) {
                ((ItemTropicalFishingRod)item).onItemRightClickSpecial(is, this.entOwner.field_70170_p, (EntityPlayer)this.getFakePlayer(this.entOwner.field_70170_p), this.entOwner);
            } else {
                item.func_77659_a(is, this.entOwner.field_70170_p, (EntityPlayer)this.getFakePlayer(this.entOwner.field_70170_p));
            }
        }
    }

    public void syncToClient() {
        this.entOwner.func_70062_b(0, this.inventory.func_70301_a(this.getSlotActive()));
    }

    public void tick() {
        this.tickItemPickupScan();
    }

    public void tickItemPickupScan() {
        List var3 = this.entOwner.field_70170_p.func_72839_b((Entity)this.entOwner, this.entOwner.field_70121_D.func_72314_b(2.0, 1.0, 2.0));
        if (var3 != null) {
            for (int var4 = 0; var4 < var3.size(); ++var4) {
                Entity var5 = (Entity)var3.get(var4);
                if (var5.field_70128_L || !this.grabItems || !(var5 instanceof EntityItem)) continue;
                this.collideWithItem((EntityItem)var5);
            }
        }
    }

    public void collideWithItem(EntityItem parItem) {
        ItemStack is = parItem.func_92059_d();
        this.inventory.addItemStackToInventory(is);
        if (is.field_77994_a <= 0) {
            parItem.func_70106_y();
        }
    }

    public void cleanup() {
        if (this.fakePlayer != null) {
            OldUtil.playerToCompAILookup.remove(CoroUtilEntity.getName((Entity)this.fakePlayer));
        }
        this.entOwner = null;
        this.fishEntity = null;
        this.playerProfile = null;
        this.fakePlayer = null;
    }
}

