/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.diplomacy;

import CoroUtil.bt.IBTAgent;
import CoroUtil.componentAI.AITamable;
import CoroUtil.componentAI.ICoroAI;
import CoroUtil.diplomacy.TeamInstance;
import CoroUtil.diplomacy.TeamTypes;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;

public class DiplomacyHelper {
    public String[] noAttackEnts;
    public Class[] noAttackEntsCls;

    public static boolean shouldTargetEnt(ICoroAI source, Entity target) {
        try {
            TeamInstance tiTarget;
            TeamInstance tiSource;
            if (target instanceof ICoroAI ? (tiSource = source.getAIAgent().dipl_info).isEnemy(tiTarget = ((ICoroAI)target).getAIAgent().dipl_info) : (target instanceof IBTAgent ? (tiSource = source.getAIAgent().dipl_info).isEnemy(tiTarget = ((IBTAgent)target).getAIBTAgent().dipl_info) : (target instanceof EntityMob || target instanceof EntitySlime) && !source.getAIAgent().isThreat(target))) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean shouldTargetEnt(IBTAgent source, Entity target) {
        TeamInstance tiSource = source.getAIBTAgent().dipl_info;
        try {
            TeamInstance tiTarget = null;
            if (target instanceof ICoroAI) {
                tiTarget = ((ICoroAI)target).getAIAgent().dipl_info;
            } else if (target instanceof IBTAgent) {
                tiTarget = ((IBTAgent)target).getAIBTAgent().dipl_info;
            } else if (target instanceof EntityPlayer) {
                if (!((EntityPlayer)target).field_71075_bZ.field_75098_d) {
                    tiTarget = TeamTypes.getType("player");
                }
            } else if (!DiplomacyHelper.isThreat(target)) {
                tiTarget = target instanceof EntityMob || target instanceof EntitySlime ? TeamTypes.getType("undead") : (target instanceof EntityAnimal ? TeamTypes.getType("animal") : TeamTypes.getType("neutral"));
            }
            if (tiTarget == null) {
                return false;
            }
            if (tiSource.isEnemy(tiTarget)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isThreat(Entity ent) {
        return ent instanceof EntityCreeper || ent instanceof EntityEnderman;
    }

    public static boolean shouldTameTargetEnt(EntityLivingBase source, Entity target, AITamable tamable) {
        try {
            if (target instanceof ICoroAI && tamable.ownerCachedInstance != null && ((ICoroAI)target).getAIAgent().jobMan.getPrimaryJob().isEnemy((Entity)tamable.ownerCachedInstance)) {
                return true;
            }
            if ((target instanceof EntityMob || target instanceof EntitySlime) && !tamable.job.entInt.getAIAgent().isThreat(target)) {
                return true;
            }
            if (source instanceof ICoroAI) {
                return DiplomacyHelper.shouldTargetEnt((ICoroAI)source, target);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

