/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.world;

import cofh.api.world.IFeatureGenerator;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shukaro.artifice.ArtificeRegistry;
import shukaro.artifice.event.ArtificeTickHandler;
import shukaro.artifice.util.BlockCoord;
import shukaro.artifice.util.ChunkCoord;
import shukaro.artifice.util.NameMetaPair;
import shukaro.artifice.world.ISuspendableGen;

public class WorldGenSulfur
implements IFeatureGenerator {
    protected Block block;
    protected int meta;
    private int size;
    private int frequency;
    protected Set<NameMetaPair> replaced;

    public WorldGenSulfur(Block block, int meta, int size, int frequency) {
        this.block = block;
        this.meta = meta;
        this.size = size;
        this.frequency = frequency;
        this.replaced = ArtificeRegistry.getStoneTypes();
    }

    public String getFeatureName() {
        return "Artifice: " + this.block.func_149739_a() + "@" + this.meta + " Lava Deposits";
    }

    public boolean generateFeature(Random rand, int chunkX, int chunkZ, World world, boolean newGen) {
        int dim = world.field_73011_w.field_76574_g;
        if (ArtificeRegistry.getDimensionBlacklist().contains(dim)) {
            return false;
        }
        String worldType = world.field_73011_w.field_76577_b.func_77127_a();
        if (ArtificeRegistry.getWorldTypeBlacklist().contains(worldType)) {
            return false;
        }
        int total = this.frequency >= 100 ? (rand.nextInt(100) < Math.abs(this.frequency % (int)Math.pow(10.0, (int)Math.log10(this.frequency))) ? this.frequency / 100 + 1 : this.frequency / 100) : (rand.nextInt(100) < this.frequency ? 0 : 1);
        for (int j = 0; j < total; ++j) {
            boolean doGen = false;
            BlockCoord b = new BlockCoord();
            int tries = rand.nextInt(16);
            for (int i = 0; i < tries; ++i) {
                int x = (chunkX << 4) + rand.nextInt(16);
                int y = rand.nextInt(128) + 1;
                int z = (chunkZ << 4) + rand.nextInt(16);
                b.set(x, y, z);
                if (!this.canGenHere(world, b)) continue;
                doGen = true;
                break;
            }
            if (!doGen) {
                return false;
            }
            int num = rand.nextInt((int)((double)this.size * 1.5) - (int)((double)this.size * 0.5) + 1) + (int)((double)this.size * 0.5);
            SulfurGen sulfur = new SulfurGen(world, rand, b, num);
            sulfur.doGeneration(chunkX, chunkZ);
            ArtificeTickHandler.queueGeneration(dim, sulfur);
        }
        return true;
    }

    protected boolean canGenHere(World world, BlockCoord b) {
        NameMetaPair pair = new NameMetaPair(b.getBlock((IBlockAccess)world), b.getMeta((IBlockAccess)world));
        if (!b.isAir((IBlockAccess)world) && this.replaced.contains(pair)) {
            for (BlockCoord n : b.getAdjacent()) {
                if (!n.getBlock((IBlockAccess)world).equals(Blocks.field_150353_l) && !n.getBlock((IBlockAccess)world).equals(Blocks.field_150356_k) && !n.getBlock((IBlockAccess)world).equals(this.block)) continue;
                return true;
            }
        }
        return false;
    }

    private class SulfurGen
    implements ISuspendableGen {
        private World world;
        private Random rand;
        private BlockCoord coord;
        private TMap<ChunkCoord, ArrayList<BlockCoord>> toGen;
        private int size;

        public SulfurGen(World world, Random rand, BlockCoord start, int size) {
            this.world = world;
            this.rand = rand;
            this.coord = start;
            this.toGen = new THashMap();
            this.size = size;
        }

        @Override
        public Set<ChunkCoord> getChunksToGen() {
            return this.toGen.keySet();
        }

        @Override
        public boolean doGeneration(int chunkX, int chunkZ) {
            ChunkCoord chunk = new ChunkCoord(chunkX, chunkZ);
            int genned = 0;
            int threshold = this.size / 8;
            while (genned < this.size) {
                for (BlockCoord t : this.coord.getAdjacent()) {
                    ChunkCoord c = new ChunkCoord(t);
                    if (!this.toGen.containsKey((Object)c)) {
                        this.toGen.put((Object)c, new ArrayList());
                    }
                    if (!chunk.contains(t) && !this.world.func_72899_e(t.x, t.y, t.z)) {
                        return true;
                    }
                    if (!WorldGenSulfur.this.canGenHere(this.world, t) || ((ArrayList)this.toGen.get((Object)chunk)).contains(t)) continue;
                    if (this.toGen.get((Object)chunk) == null) {
                        this.toGen.put((Object)chunk, new ArrayList());
                    }
                    ((ArrayList)this.toGen.get((Object)chunk)).add(t);
                }
                if (((ArrayList)this.toGen.get((Object)chunk)).size() == 0) break;
                this.coord.set((BlockCoord)((ArrayList)this.toGen.get((Object)chunk)).get(this.rand.nextInt(((ArrayList)this.toGen.get((Object)chunk)).size())));
                ((ArrayList)this.toGen.get((Object)chunk)).remove(this.coord);
                this.world.func_147465_d(this.coord.x, this.coord.y, this.coord.z, WorldGenSulfur.this.block, WorldGenSulfur.this.meta, 0);
                ++genned;
                while (((ArrayList)this.toGen.get((Object)chunk)).size() > threshold && genned < this.size && ((ArrayList)this.toGen.get((Object)chunk)).size() != 0) {
                    this.coord.set((BlockCoord)((ArrayList)this.toGen.get((Object)chunk)).get(this.rand.nextInt(((ArrayList)this.toGen.get((Object)chunk)).size())));
                    ((ArrayList)this.toGen.get((Object)chunk)).remove(this.coord);
                    this.world.func_147465_d(this.coord.x, this.coord.y, this.coord.z, WorldGenSulfur.this.block, WorldGenSulfur.this.meta, 0);
                    ++genned;
                }
            }
            return true;
        }
    }
}

