/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.block.decorative;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shukaro.artifice.ArtificeBlocks;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.block.BlockArtifice;
import shukaro.artifice.block.ItemBlockArtifice;
import shukaro.artifice.render.TextureHandler;
import shukaro.artifice.util.MinecraftColors;

public class BlockLamp
extends BlockArtifice {
    MinecraftColors color;
    private boolean inverted;
    private IIcon icon;

    public BlockLamp(MinecraftColors color, boolean inverted) {
        super(Material.field_151592_s);
        this.color = color;
        this.inverted = inverted;
        this.func_149711_c(0.3f);
        this.func_149672_a(field_149778_k);
        if (inverted) {
            this.func_149663_c("artifice.lampinverted." + color.name().toLowerCase(Locale.ENGLISH));
        } else {
            this.func_149663_c("artifice.lamp." + color.name().toLowerCase(Locale.ENGLISH));
        }
        GameRegistry.registerBlock((Block)this, ItemBlockArtifice.class, (String)this.func_149739_a());
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        ItemStack held;
        if (!world.field_72995_K && (held = player.func_70694_bm()) == null && player.func_70093_af()) {
            if (this.inverted) {
                return world.func_147465_d(x, y, z, (Block)ArtificeBlocks.blockLamps[this.getLampID(world, x, y, z)], 0, 3);
            }
            return world.func_147465_d(x, y, z, (Block)ArtificeBlocks.blockLampsInverted[this.getLampID(world, x, y, z)], 0, 3);
        }
        return false;
    }

    private int getLampID(World world, int x, int y, int z) {
        if (!world.func_147437_c(x, y, z) && world.func_147439_a(x, y, z) instanceof BlockLamp) {
            MinecraftColors c = ((BlockLamp)world.func_147439_a((int)x, (int)y, (int)z)).color;
            for (int i = 0; i < 16; ++i) {
                if (!c.equals((Object)MinecraftColors.values()[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void func_149651_a(IIconRegister reg) {
        for (int i = 0; i < 16; ++i) {
            if (this.inverted) {
                TextureHandler.registerConnectedTexture(reg, this, i, "lampinverted", "lamp");
                continue;
            }
            TextureHandler.registerConnectedTexture(reg, this, i, "lamp", "lamp");
        }
        this.icon = TextureHandler.getConnectedTexture((Block)this, (int)0, (int)0).icon;
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        return this.icon;
    }

    @Override
    public IIcon func_149673_e(IBlockAccess block, int x, int y, int z, int side) {
        int meta = block.func_72805_g(x, y, z);
        if (meta > 15) {
            meta = 0;
        }
        return this.func_149691_a(side, meta);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.func_72864_z(x, y, z) && world.func_94577_B(x, y, z) == 0) {
            if (world.func_72805_g(x, y, z) != 0) {
                world.func_72921_c(x, y, z, 0, 3);
            }
        } else {
            int power;
            int n = power = world.func_94572_D(x, y, z) > world.func_94577_B(x, y, z) ? world.func_94572_D(x, y, z) : world.func_94577_B(x, y, z);
            if (world.func_72805_g(x, y, z) != power) {
                world.func_72921_c(x, y, z, power, 3);
            }
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        if (!world.field_72995_K) {
            world.func_147464_a(x, y, z, (Block)this, 2);
        }
    }

    @Override
    public void func_149666_a(Item item, CreativeTabs tabs, List list) {
        list.add(new ItemStack(item, 1, 0));
    }

    @Override
    public int func_149692_a(int meta) {
        return 0;
    }

    @Override
    public int func_149643_k(World world, int x, int y, int z) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        if (this.inverted) {
            return this.color.toAdjusted(5);
        }
        return this.color.toAdjusted(-40);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess block, int x, int y, int z) {
        if (this.inverted) {
            return this.color.toAdjusted(5 - block.func_72805_g(x, y, z));
        }
        return this.color.toAdjusted(block.func_72805_g(x, y, z) - 40);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (this.inverted) {
            return 15 - world.func_72805_g(x, y, z);
        }
        return world.func_72805_g(x, y, z);
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return ArtificeConfig.ctmRenderID;
    }
}

