/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Fission;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Auxiliary.LinkableReactorCore;
import Reika.ReactorCraft.Auxiliary.NeutronTile;
import Reika.ReactorCraft.Auxiliary.ReactorBlock;
import Reika.ReactorCraft.Auxiliary.ReactorControlLayout;
import Reika.ReactorCraft.Auxiliary.ReactorPowerReceiver;
import Reika.ReactorCraft.Auxiliary.Temperatured;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.Event.ScramEvent;
import Reika.ReactorCraft.Registry.ReactorAchievements;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorSounds;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityControlRod;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityWaterCell;
import Reika.RotaryCraft.API.Power.PowerTransferHelper;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCPU
extends TileEntityReactorBase
implements ReactorPowerReceiver,
Temperatured,
ReactorBlock,
NeutronTile {
    private ReactorControlLayout layout;
    private final BlockArray reactor = new BlockArray();
    private final ArrayList<TemperatureMonitor> temperatureChecks = new ArrayList();
    public static final int POWERPERROD = 1024;
    private int omega;
    private int torque;
    private long power;
    private int redstoneUpdate = 200;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.thermalTicker.update();
        if (this.thermalTicker.checkCap()) {
            this.updateTemperature(world, x, y, z);
        }
        if (!world.field_72995_K) {
            if (world.func_82737_E() % 64L == 0L) {
                this.reactor.clear();
            }
            if (this.reactor.isEmpty()) {
                int i;
                this.layout.clear();
                int r = 12;
                Block id = ReactorBlocks.REACTOR.getBlockInstance();
                Block id2 = ReactorBlocks.MODELREACTOR.getBlockInstance();
                for (i = 2; i < 6; ++i) {
                    this.reactor.recursiveMultiAddWithBounds((IBlockAccess)world, x + this.dirs[i].offsetX, y, z + this.dirs[i].offsetZ, x - r, y - 4, z - r, x + r, y + 4, z + r, new Block[]{id, id2});
                }
                for (i = 0; i < this.reactor.getSize(); ++i) {
                    Coordinate c = this.reactor.getNthBlock(i);
                    int dx = c.xCoord;
                    int dy = c.yCoord;
                    int dz = c.zCoord;
                    Block idx = world.func_147439_a(dx, dy, dz);
                    int metax = world.func_72805_g(dx, dy, dz);
                    if (idx != ReactorTiles.CONTROL.getBlock() || metax != ReactorTiles.CONTROL.getBlockMetadata()) continue;
                    TileEntityControlRod rod = (TileEntityControlRod)world.func_147438_o(dx, dy, dz);
                    this.layout.addControlRod(rod);
                }
                this.syncAllData(true);
            }
        }
        if (DragonAPICore.debugtest) {
            this.omega = 1024;
            this.torque = 1024;
            this.power = this.omega * this.torque;
        } else if (!PowerTransferHelper.checkPowerFromAllSides((TileEntity)this, (boolean)true)) {
            this.noInputMachine();
        }
        if (world.field_72995_K) {
            return;
        }
        if (this.power < this.getMinPower() && this.getTicksExisted() > 20) {
            this.SCRAM();
        }
        if (this.layout.getNumberRods() > 0 && (this.temperature > this.getMaxTemperature() || !this.temperatureChecks.isEmpty() && this.temperatureChecks.get(rand.nextInt(this.temperatureChecks.size())).getTemperature(this) > this.getMaxTemperature()) && this.power >= this.getMinPower() * 4L) {
            ReactorAchievements.SCRAM.triggerAchievement(this.getPlacer());
            this.SCRAM();
        }
        if (this.redstoneUpdate > 0) {
            --this.redstoneUpdate;
            if (this.redstoneUpdate <= 0) {
                world.func_147471_g(x, y, z);
                ReikaWorldHelper.causeAdjacentUpdates((World)world, (int)x, (int)y, (int)z);
            }
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.layout = new ReactorControlLayout(this);
    }

    public void SCRAM() {
        MinecraftForge.EVENT_BUS.post((Event)new ScramEvent(this, this.temperature));
        this.layout.SCRAM();
        if (this.redstoneUpdate == 0) {
            this.redstoneUpdate = 7;
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public int getIndex() {
        return ReactorTiles.CPU.ordinal();
    }

    public ReactorControlLayout getLayout() {
        return this.layout;
    }

    public int getOmega() {
        return this.omega;
    }

    public int getTorque() {
        return this.torque;
    }

    public long getPower() {
        return this.power;
    }

    public int getIORenderAlpha() {
        return 0;
    }

    public void setIORenderAlpha(int io) {
    }

    public void setOmega(int omega) {
        this.omega = omega;
    }

    public void setTorque(int torque) {
        this.torque = torque;
    }

    public void setPower(long power) {
        this.power = power;
    }

    public boolean canReadFrom(ForgeDirection dir) {
        return true;
    }

    public boolean isReceiving() {
        return true;
    }

    public void noInputMachine() {
        this.omega = 0;
        this.torque = 0;
        this.power = 0L;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public void setTemperature(int T) {
        this.temperature = T;
    }

    @Override
    public int getMaxTemperature() {
        return 800;
    }

    @Override
    public boolean canDumpHeatInto(TileEntityWaterCell.LiquidStates liq) {
        return liq != TileEntityWaterCell.LiquidStates.EMPTY;
    }

    public void lowerAllRods() {
        Collection<TileEntityControlRod> li = this.layout.getAllRods();
        for (TileEntityControlRod te : li) {
            te.setActive(true, false);
        }
        ReactorSounds.CONTROL.playSoundAtBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 1.3f);
        this.redstoneUpdate = 30;
    }

    public void raiseAllRods() {
        Collection<TileEntityControlRod> li = this.layout.getAllRods();
        for (TileEntityControlRod te : li) {
            te.setActive(false, false);
        }
        ReactorSounds.CONTROL.playSoundAtBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 1.3f);
        this.redstoneUpdate = 30;
    }

    public int getMinTorque(int available) {
        return 1;
    }

    @Override
    public int getMinTorque() {
        return 1;
    }

    @Override
    public int getMinSpeed() {
        return 1;
    }

    @Override
    public long getMinPower() {
        long base = this.layout != null ? this.layout.getMinPower() : 0L;
        return base;
    }

    @Override
    public int getRedstoneOverride() {
        return this.layout.isEmpty() ? 0 : 15 * this.layout.countLoweredRods() / this.layout.getNumberRods();
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.omega = NBT.func_74762_e("speed");
        this.torque = NBT.func_74762_e("trq");
        this.power = NBT.func_74763_f("pwr");
        this.redstoneUpdate = NBT.func_74762_e("redsu");
        if (this.layout != null) {
            this.layout.readFromNBT(NBT);
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("speed", this.omega);
        NBT.func_74768_a("trq", this.torque);
        NBT.func_74772_a("pwr", this.power);
        NBT.func_74768_a("redsu", this.redstoneUpdate);
        if (this.layout != null) {
            this.layout.writeToNBT(NBT);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBTTagList li = new NBTTagList();
        for (TemperatureMonitor m : this.temperatureChecks) {
            li.func_74742_a((NBTBase)m.writeToNBT());
        }
        NBT.func_74782_a("checks", (NBTBase)li);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.temperatureChecks.clear();
        NBTTagList li = NBT.func_150295_c("checks", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            NBTTagCompound tag = (NBTTagCompound)o;
            this.temperatureChecks.add(TemperatureMonitor.readFromNBT(tag));
        }
    }

    @Override
    public boolean onNeutron(EntityNeutron e, World world, int x, int y, int z) {
        return false;
    }

    public void addTemperatureCheck(LinkableReactorCore te) {
        this.temperatureChecks.add(new TemperatureMonitor(te));
        te.link(this);
    }

    public void removeTemperatureCheck(LinkableReactorCore te) {
        this.temperatureChecks.remove(new TemperatureMonitor(te));
    }

    private static class TemperatureMonitor {
        private final Coordinate location;

        private TemperatureMonitor(LinkableReactorCore te) {
            this.location = new Coordinate((TileEntity)te);
        }

        private TemperatureMonitor(Coordinate c) {
            this.location = c;
        }

        public NBTTagCompound writeToNBT() {
            return this.location.writeToTag();
        }

        public static TemperatureMonitor readFromNBT(NBTTagCompound tag) {
            return new TemperatureMonitor(Coordinate.readTag((NBTTagCompound)tag));
        }

        public int getTemperature(TileEntityCPU te) {
            return ((LinkableReactorCore)this.location.getTileEntity((IBlockAccess)te.field_145850_b)).getTemperature();
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof TemperatureMonitor && ((TemperatureMonitor)o).location.equals((Object)this.location);
        }
    }
}

