/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Registry;

import Reika.ReactorCraft.Auxiliary.ReactorAchievementPage;
import Reika.ReactorCraft.Auxiliary.ReactorStacks;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.MatBlocks;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorItems;
import Reika.ReactorCraft.Registry.ReactorOres;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraftforge.common.AchievementPage;

public enum ReactorAchievements {
    RECUSEBOOK(1, 1, ReactorItems.BOOK, null, false),
    MINEURANIUM(0, 0, ReactorOres.PITCHBLENDE.getProduct(), null, false),
    MINECADMIUM(0, 2, ReactorOres.CADMIUM.getProduct(), null, false),
    PEBBLE(0, -2, ReactorItems.PELLET, MINEURANIUM, false),
    UF6(2, 0, ReactorStacks.uf6can, MINEURANIUM, false),
    DEPLETED(2, -2, ReactorItems.DEPLETED, UF6, false),
    FISSION(4, 0, ReactorItems.FUEL, UF6, false),
    PLUTONIUM(6, 0, ReactorItems.PLUTONIUM, FISSION, true),
    PUPOISON(8, 0, Items.field_151070_bp, PLUTONIUM, false),
    HOLDWASTE(4, 4, ReactorItems.WASTE, FISSION, false),
    DECAY(6, 2, ReactorTiles.STORAGE, FISSION, true),
    WASTELEAK(6, 4, ReactorItems.GOGGLES, HOLDWASTE, false),
    AMMONIA(6, -2, ReactorStacks.nh3can, FISSION, false),
    NH3EXPLODE(8, -2, ReactorTiles.STEAMLINE, AMMONIA, false),
    GIGATURBINE(6, -4, ReactorTiles.TURBINECORE, AMMONIA, true),
    HOTCORE(4, -4, (Block)Blocks.field_150356_k, FISSION, false),
    SCRAM(2, -4, ReactorTiles.CPU, HOTCORE, false),
    MELTDOWN(4, -6, MatBlocks.SLAG.getStackOf(), HOTCORE, false),
    HEAVYWATER(-2, 0, ReactorItems.BUCKET, MINEURANIUM, false),
    CANDU(-2, 2, ReactorTiles.COOLANT, HEAVYWATER, false),
    PLASMA(-4, 0, ReactorTiles.HEATER, HEAVYWATER, true),
    ESCAPE(-4, -2, (Block)Blocks.field_150480_ab, PLASMA, false),
    MELTPIPE(-4, 2, ReactorTiles.MAGNETPIPE, PLASMA, false),
    FUSION(-6, 0, ReactorTiles.MAGNET, PLASMA, true),
    FIFTYGW(-6, 2, MachineRegistry.DYNAMOMETER.getCraftedProduct(), FUSION, true),
    PEBBLEFAIL(0, -4, ReactorItems.OLDPELLET, PEBBLE, true),
    THORIUMDUMP(4, 2, ReactorBlocks.THORIUM.getBlockInstance(), FISSION, true),
    PLASMADIE(-4, -4, new ItemStack(Items.field_151144_bL, 1, 1), ESCAPE, false);

    public static final ReactorAchievements[] list;
    public final ReactorAchievements dependency;
    public final int xPosition;
    public final int yPosition;
    public final boolean isSpecial;
    private final ItemStack iconItem;

    private ReactorAchievements(int x, int y, Item icon, ReactorAchievements preReq, boolean special) {
        this(x, y, new ItemStack(icon), preReq, special);
    }

    private ReactorAchievements(int x, int y, Block icon, ReactorAchievements preReq, boolean special) {
        this(x, y, new ItemStack(icon), preReq, special);
    }

    private ReactorAchievements(int x, int y, ReactorItems icon, ReactorAchievements preReq, boolean special) {
        this(x, y, icon.getStackOf(), preReq, special);
    }

    private ReactorAchievements(int x, int y, ReactorTiles icon, ReactorAchievements preReq, boolean special) {
        this(x, y, icon.getCraftedProduct(), preReq, special);
    }

    private ReactorAchievements(int x, int y, ItemStack icon, ReactorAchievements preReq, boolean special) {
        this.xPosition = x;
        this.yPosition = y;
        this.dependency = preReq;
        this.iconItem = icon;
        this.isSpecial = special;
    }

    public Achievement get() {
        return ReactorCraft.achievements[this.ordinal()];
    }

    public void triggerAchievement(EntityPlayer ep) {
        if (!ConfigRegistry.ACHIEVEMENTS.getState()) {
            return;
        }
        if (ep == null) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                ReactorCraft.logger.debug((Object)("Player does not exist to receive their achievement \"" + (Object)((Object)this) + "\"!"));
            }
        } else {
            ep.func_71029_a((StatBase)this.get());
        }
    }

    public boolean hasDependency() {
        return this.dependency != null;
    }

    public static void registerAchievements() {
        for (int i = 0; i < list.length; ++i) {
            ReactorAchievements a = list[i];
            String id = a.name();
            Achievement dep = a.hasDependency() ? a.dependency.get() : null;
            Achievement ach = new Achievement(id, a.name().toLowerCase(Locale.ENGLISH), a.xPosition, a.yPosition, a.iconItem, dep);
            id = ach.field_75975_e;
            if (a.isSpecial) {
                ach.func_75987_b();
            }
            ReactorCraft.achievements[i] = ach;
            ach.func_75971_g();
            ReactorCraft.logger.log((Object)("Registering achievement " + (Object)((Object)a) + " with ID " + id + " and ingame name \"" + (Object)((Object)a) + "\" (slot " + i + ")."));
        }
        AchievementPage.registerAchievementPage((AchievementPage)new ReactorAchievementPage("ReactorCraft", ReactorCraft.achievements));
    }

    static {
        list = ReactorAchievements.values();
    }
}

