/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Blocks.Multi;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.SlicedBlockBlueprint;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.StructuredBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.Registry.TileEnum;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.ReactorCraft.Base.BlockMultiBlock;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntitySteamInjector;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntityTurbineCore;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockTurbineMulti
extends BlockMultiBlock {
    private final SlicedBlockBlueprint setup = new SlicedBlockBlueprint();

    public BlockTurbineMulti(Material par2Material) {
        super(par2Material);
        this.initMap();
    }

    public boolean hasTileEntity(int meta) {
        return meta % 8 == 2;
    }

    public TileEntity createTileEntity(World world, int meta) {
        switch (meta % 8) {
            case 2: {
                return new TileEntitySteamInjector();
            }
        }
        return null;
    }

    @Override
    public int getNumberTextures() {
        return 6;
    }

    public int getThickness(int stage) {
        return this.setup.getHeight(stage) / 2;
    }

    private void initMap() {
        this.setup.addMapping('t', (Block)this, 0);
        this.setup.addMapping('h', (Block)this, 1);
        this.setup.addMapping('e', (Block)this, 2);
        this.setup.addAntiMapping('b', (Block)this);
        this.setup.addSlice(new String[]{"xbbhhhhhbbx", "bbhhhthhhbb", "bhhttttthhb", "hhttttttthh", "hhttttttthh", "httttxtttth", "hhttttttthh", "hhttttttthh", "bhhttttthhb", "bbhhhthhhbb", "xbbhhhhhbbx"});
        this.setup.addSlice(new String[]{"xxbbbbbbbxx", "xbbhhhhhbbx", "bbhhttthhbb", "bhhttttthhb", "bhttttttthb", "bhtttxttthb", "bhttttttthb", "bhhttttthhb", "bbhhttthhbb", "xbbhhhhhbbx", "xxbbbbbbbxx"});
        this.setup.addSlice(new String[]{"xxxbbbbbxxx", "xbbbhhhbbbx", "xbhhhhhhhbx", "bbhhttthhbb", "bhhttttthhb", "bhhttxtthhb", "bhhttttthhb", "bbhhttthhbb", "xbhhhhhhhbx", "xbbbhhhbbbx", "xxxbbbbbxxx"});
        this.setup.addSlice(new String[]{"xxxxxxxxxxx", "xxbbbbbbbxx", "xbbhhhhhbbx", "xbhhttthhbx", "xbhttttthbx", "xbhttxtthbx", "xbhttttthbx", "xbhhttthhbx", "xbbhhhhhbbx", "xxbbbbbbbxx", "xxxxxxxxxxx"});
        this.setup.addSlice(new String[]{"xxxxxxxxxxx", "xxxbbbbbxxx", "xxbbhhhbbxx", "xbbhhhhhbbx", "xbhhttthhbx", "xbhhtxthhbx", "xbhhttthhbx", "xbbhhhhhbbx", "xxbbhhhbbxx", "xxxbbbbbxxx", "xxxxxxxxxxx"});
        this.setup.addSlice(new String[]{"xxxxxxxxxxx", "xxxxxxxxxxx", "xxbbbbbbbxx", "xxbhhhhhbxx", "xxbhhthhbxx", "xxbhtxthbxx", "xxbhhthhbxx", "xxbhhhhhbxx", "xxbbbbbbbxx", "xxxxxxxxxxx", "xxxxxxxxxxx"});
        this.setup.addSlice(new String[]{"xxxxxxxxxxx", "xxxxxxxxxxx", "xxxbbbbbxxx", "xxbbhhhbbxx", "xxbhhhhhbxx", "xxbhhxhhbxx", "xxbhhhhhbxx", "xxbbhhhbbxx", "xxxbbbbbxxx", "xxxxxxxxxxx", "xxxxxxxxxxx"});
        this.setup.addSlice(new String[]{"xxxxxxxxxxx", "xxxxxxxxxxx", "xxxxxxxxxxx", "xxxbbbbbxxx", "xxxbeeebxxx", "xxxbexebxxx", "xxxbeeebxxx", "xxxbbbbbxxx", "xxxxxxxxxxx", "xxxxxxxxxxx", "xxxxxxxxxxx"});
    }

    @Override
    public boolean checkForFullMultiBlock(World world, int x, int y, int z, ForgeDirection dir) {
        StructuredBlockArray blocks = new StructuredBlockArray(world);
        blocks.recursiveAddWithBounds((IBlockAccess)world, x, y, z, (Block)this, x - 12, y - 12, z - 12, x + 12, y + 12, z + 12);
        int n = this.checkForTurbines(world, x, y, z, dir, blocks);
        if (n <= 0 || n > 7) {
            return false;
        }
        return this.checkForShape(world, x, y, z, dir, blocks, n);
    }

    private int checkForTurbines(World world, int x, int y, int z, ForgeDirection dir, StructuredBlockArray blocks) {
        int sx;
        int mx = blocks.getMinX() + blocks.getSizeX() / 2;
        int my = blocks.getMinY() + blocks.getSizeY() / 2;
        int mz = blocks.getMinZ() + blocks.getSizeZ() / 2;
        int n = dir.offsetX == 0 ? mx : (sx = dir.offsetX < 0 ? blocks.getMaxX() : blocks.getMinX());
        int sz = dir.offsetZ == 0 ? mz : (dir.offsetZ < 0 ? blocks.getMaxZ() : blocks.getMinZ());
        int c = 0;
        for (int i = 0; i < this.setup.getLength(); ++i) {
            int dx = sx + i * dir.offsetX;
            int dz = sz + i * dir.offsetZ;
            ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, dx, my, dz);
            if (r == ReactorTiles.BIGTURBINE) {
                ++c;
            } else {
                return c;
            }
            ((TileEntityTurbineCore)world.func_147438_o(dx, my, dz)).markForMulti();
        }
        return c;
    }

    private boolean checkForShape(World world, int x, int y, int z, ForgeDirection dir, StructuredBlockArray blocks, int turbines) {
        int sx;
        int start = this.setup.getLength() - turbines - 1;
        int mx = blocks.getMinX() + blocks.getSizeX() / 2;
        int my = blocks.getMinY() + blocks.getSizeY() / 2;
        int mz = blocks.getMinZ() + blocks.getSizeZ() / 2;
        int n = dir.offsetX == 0 ? mx : (sx = dir.offsetX < 0 ? blocks.getMaxX() : blocks.getMinX());
        int sz = dir.offsetZ == 0 ? mz : (dir.offsetZ < 0 ? blocks.getMaxZ() : blocks.getMinZ());
        for (int i = start; i < this.setup.getLength(); ++i) {
            int d = i - start;
            int dx = sx + d * dir.offsetX;
            int dz = sz + d * dir.offsetZ;
            boolean match = this.setup.checkAgainst(world, dx, my, dz, 5, 5, dir, i);
            if (match) continue;
            return false;
        }
        return true;
    }

    @Override
    public void breakMultiBlock(World world, int x, int y, int z) {
        StructuredBlockArray blocks = new StructuredBlockArray(world);
        Block tid = ReactorTiles.BIGTURBINE.getBlock();
        Set set = ReikaJavaLibrary.getSet((Object[])new BlockKey[]{new BlockKey((Block)this), new BlockKey((TileEnum)ReactorTiles.BIGTURBINE)});
        blocks.recursiveAddMultipleWithBounds((IBlockAccess)world, x, y, z, set, x - 12, y - 12, z - 12, x + 12, y + 12, z + 12);
        for (int i = 0; i < blocks.getSize(); ++i) {
            Coordinate c = blocks.getNthBlock(i);
            Block b = c.getBlock((IBlockAccess)world);
            int meta = c.getBlockMetadata((IBlockAccess)world);
            if (b == this) {
                if (meta < 8) continue;
                world.func_72921_c(c.xCoord, c.yCoord, c.zCoord, meta - 8, 3);
                continue;
            }
            if (b != tid || meta != ReactorTiles.BIGTURBINE.getBlockMetadata()) continue;
            TileEntityTurbineCore te = (TileEntityTurbineCore)world.func_147438_o(c.xCoord, c.yCoord, c.zCoord);
            te.setHasMultiBlock(false);
        }
    }

    @Override
    protected void onCreateFullMultiBlock(World world, int x, int y, int z) {
        StructuredBlockArray blocks = new StructuredBlockArray(world);
        Block tid = ReactorTiles.BIGTURBINE.getBlock();
        Set set = ReikaJavaLibrary.getSet((Object[])new BlockKey[]{new BlockKey((Block)this), new BlockKey((TileEnum)ReactorTiles.BIGTURBINE)});
        blocks.recursiveAddMultipleWithBounds((IBlockAccess)world, x, y, z, set, x - 12, y - 12, z - 12, x + 12, y + 12, z + 12);
        for (int i = 0; i < blocks.getSize(); ++i) {
            Coordinate c = blocks.getNthBlock(i);
            Block b = c.getBlock((IBlockAccess)world);
            if (b == this) {
                int meta = c.getBlockMetadata((IBlockAccess)world);
                if (meta >= 8) continue;
                world.func_72921_c(c.xCoord, c.yCoord, c.zCoord, meta + 8, 3);
                continue;
            }
            if (b != tid) continue;
            TileEntityTurbineCore te = (TileEntityTurbineCore)world.func_147438_o(c.xCoord, c.yCoord, c.zCoord);
            te.setHasMultiBlock(true);
        }
    }

    @Override
    public int getNumberVariants() {
        return 3;
    }

    @Override
    protected String getIconBaseName() {
        return "turbine";
    }

    @Override
    public int getTextureIndex(IBlockAccess world, int x, int y, int z, int side, int meta) {
        return meta >= 8 ? 5 : meta;
    }

    @Override
    public int getItemTextureIndex(int meta, int side) {
        return meta & 7;
    }

    @Override
    public boolean canTriggerMultiBlockCheck(World world, int x, int y, int z, int meta) {
        return meta <= 1;
    }

    @Override
    protected TileEntity getTileEntityForPosition(World world, int x, int y, int z) {
        StructuredBlockArray blocks = new StructuredBlockArray(world);
        blocks.recursiveAddWithBounds((IBlockAccess)world, x, y, z, (Block)this, x - 12, y - 12, z - 12, x + 12, y + 12, z + 12);
        int mx = blocks.getMinX() + blocks.getSizeX() / 2;
        int my = blocks.getMinY() + blocks.getSizeY() / 2;
        int mz = blocks.getMinZ() + blocks.getSizeZ() / 2;
        return ReactorTiles.getTE((IBlockAccess)world, mx, my, mz) == ReactorTiles.BIGTURBINE ? world.func_147438_o(mx, my, mz) : null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public SlicedBlockBlueprint getBlueprint() {
        return this.setup.copy();
    }
}

