/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Blocks.Multi;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.StructuredBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.Block.SemiTransparent;
import Reika.DragonAPI.Interfaces.Registry.TileEnum;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.ReactorCraft.Base.BlockMultiBlock;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.Fusion.TileEntityFusionHeater;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockHeaterMulti
extends BlockMultiBlock
implements SemiTransparent {
    public BlockHeaterMulti(Material par2Material) {
        super(par2Material);
    }

    @Override
    public int getNumberVariants() {
        return 5;
    }

    @Override
    public boolean checkForFullMultiBlock(World world, int x, int y, int z, ForgeDirection dir) {
        StructuredBlockArray blocks = new StructuredBlockArray(world);
        Set set = ReikaJavaLibrary.getSet((Object[])new BlockKey[]{new BlockKey((Block)this), new BlockKey((TileEnum)ReactorTiles.HEATER)});
        blocks.recursiveAddMultipleWithBounds((IBlockAccess)world, x, y, z, set, x - 6, y - 6, z - 6, x + 6, y + 6, z + 6);
        if (!this.checkCorners(world, x, y, z, blocks)) {
            return false;
        }
        if (!this.checkEdges(world, x, y, z, blocks)) {
            return false;
        }
        if (!this.checkCore(world, x, y, z, blocks)) {
            return false;
        }
        if (!this.checkFaces(world, x, y, z, blocks)) {
            return false;
        }
        return this.checkPipe(world, x, y, z, blocks);
    }

    private boolean checkPipe(World world, int x, int y, int z, StructuredBlockArray blocks) {
        int mx = blocks.getMinX();
        int my = blocks.getMinY();
        int mz = blocks.getMinZ();
        for (int i = 3; i <= 6; ++i) {
            if (ReactorTiles.getTE((IBlockAccess)world, mx + 2, my + i, mz + 2) == ReactorTiles.MAGNETPIPE) continue;
            return false;
        }
        return true;
    }

    private boolean checkCore(World world, int x, int y, int z, StructuredBlockArray blocks) {
        int total = 0;
        int lens = 0;
        for (int i = 1; i < 4; ++i) {
            for (int j = 1; j < 4; ++j) {
                for (int k = 1; k < 4; ++k) {
                    if (i == 2 && k == 2 && j == 3) {
                        int dz;
                        int dy;
                        int dx = blocks.getMinX() + i;
                        if (ReactorTiles.getTE((IBlockAccess)blocks.world, dx, dy = blocks.getMinY() + j, dz = blocks.getMinZ() + k) == ReactorTiles.MAGNETPIPE) continue;
                        return false;
                    }
                    BlockKey block = blocks.getBlockKeyRelativeToMinXYZ(i, j, k);
                    int dx = blocks.getMinX() + i;
                    int dy = blocks.getMinY() + j;
                    int dz = blocks.getMinZ() + k;
                    if (block == null) {
                        MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)blocks.world, (int)dx, (int)dy, (int)dz);
                        if (m != null && m.isStandardPipe()) continue;
                        return false;
                    }
                    Block id = block.blockID;
                    int meta = block.metadata;
                    if (i == 2 && j == 2 && k == 2) {
                        if (id == ReactorTiles.HEATER.getBlock() && meta == ReactorTiles.HEATER.getBlockMetadata()) continue;
                        return false;
                    }
                    if (id == this) {
                        if (meta > 1) {
                            return false;
                        }
                        ++total;
                        if (meta != 0) continue;
                        ++lens;
                        continue;
                    }
                    if (MachineRegistry.getMachineFromIDandMetadata((Block)id, (int)meta) != null && MachineRegistry.getMachineFromIDandMetadata((Block)id, (int)meta).isStandardPipe()) {
                        if (j == 2) continue;
                        return false;
                    }
                    return false;
                }
            }
        }
        return total >= 22 && lens == 1;
    }

    private boolean checkFaces(World world, int x, int y, int z, StructuredBlockArray blocks) {
        for (int i = 1; i < 4; ++i) {
            for (int k = 1; k < 4; ++k) {
                int meta2;
                if (i == 2 && k == 2) {
                    int dz;
                    int dy;
                    int dx = blocks.getMinX() + i;
                    if (ReactorTiles.getTE((IBlockAccess)blocks.world, dx, dy = blocks.getMinY() + 4, dz = blocks.getMinZ() + k) == ReactorTiles.MAGNETPIPE) continue;
                    return false;
                }
                BlockKey block = blocks.getBlockKeyRelativeToMinXYZ(i, 0, k);
                if (block == null || block.blockID != this || block.metadata != 4) {
                    return false;
                }
                block = blocks.getBlockKeyRelativeToMinXYZ(i, 4, k);
                if (block == null || block.blockID != this || block.metadata != 1) {
                    return false;
                }
                block = blocks.getBlockKeyRelativeToMinXYZ(i, 5, k);
                int n = meta2 = i == 2 || k == 2 ? 3 : 2;
                if (block == null || block.blockID != this || block.metadata != meta2) {
                    return false;
                }
                block = blocks.getBlockKeyRelativeToMinXYZ(i, k, 0);
                if (block == null || block.blockID != this || block.metadata != 4) {
                    return false;
                }
                block = blocks.getBlockKeyRelativeToMinXYZ(i, k, 4);
                if (block == null || block.blockID != this || block.metadata != 4) {
                    return false;
                }
                block = blocks.getBlockKeyRelativeToMinXYZ(0, k, i);
                if (block == null || block.blockID != this || block.metadata != 4) {
                    return false;
                }
                block = blocks.getBlockKeyRelativeToMinXYZ(4, k, i);
                if (block != null && block.blockID == this && block.metadata == 4) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkEdges(World world, int x, int y, int z, StructuredBlockArray blocks) {
        for (int i = 1; i < 4; ++i) {
            BlockKey block = blocks.getBlockKeyRelativeToMinXYZ(i, 0, 0);
            if (block == null || block.blockID != this || block.metadata != 3) {
                return false;
            }
            block = blocks.getBlockKeyRelativeToMinXYZ(0, i, 0);
            if (block == null || block.blockID != this || block.metadata != 3) {
                return false;
            }
            block = blocks.getBlockKeyRelativeToMinXYZ(0, 0, i);
            if (block == null || block.blockID != this || block.metadata != 3) {
                return false;
            }
            block = blocks.getBlockKeyRelativeToMinXYZ(i, 0, 4);
            if (block == null || block.blockID != this || block.metadata != 3) {
                return false;
            }
            block = blocks.getBlockKeyRelativeToMinXYZ(4, 0, i);
            if (block == null || block.blockID != this || block.metadata != 3) {
                return false;
            }
            block = blocks.getBlockKeyRelativeToMinXYZ(i, 4, 4);
            if (block == null || block.blockID != this || block.metadata != 3) {
                return false;
            }
            block = blocks.getBlockKeyRelativeToMinXYZ(4, 4, i);
            if (block == null || block.blockID != this || block.metadata != 3) {
                return false;
            }
            block = blocks.getBlockKeyRelativeToMinXYZ(i, 4, 0);
            if (block == null || block.blockID != this || block.metadata != 3) {
                return false;
            }
            block = blocks.getBlockKeyRelativeToMinXYZ(0, 4, i);
            if (block == null || block.blockID != this || block.metadata != 3) {
                return false;
            }
            block = blocks.getBlockKeyRelativeToMinXYZ(4, i, 0);
            if (block == null || block.blockID != this || block.metadata != 3) {
                return false;
            }
            block = blocks.getBlockKeyRelativeToMinXYZ(0, i, 4);
            if (block == null || block.blockID != this || block.metadata != 3) {
                return false;
            }
            block = blocks.getBlockKeyRelativeToMinXYZ(4, i, 4);
            if (block != null && block.blockID == this && block.metadata == 3) continue;
            return false;
        }
        return true;
    }

    private boolean checkCorners(World world, int x, int y, int z, StructuredBlockArray blocks) {
        BlockKey block = blocks.getBlockKeyRelativeToMinXYZ(0, 0, 0);
        if (block == null || block.blockID != this || block.metadata != 2) {
            return false;
        }
        block = blocks.getBlockKeyRelativeToMinXYZ(4, 0, 0);
        if (block == null || block.blockID != this || block.metadata != 2) {
            return false;
        }
        block = blocks.getBlockKeyRelativeToMinXYZ(0, 0, 4);
        if (block == null || block.blockID != this || block.metadata != 2) {
            return false;
        }
        block = blocks.getBlockKeyRelativeToMinXYZ(4, 0, 4);
        if (block == null || block.blockID != this || block.metadata != 2) {
            return false;
        }
        block = blocks.getBlockKeyRelativeToMinXYZ(0, 4, 0);
        if (block == null || block.blockID != this || block.metadata != 2) {
            return false;
        }
        block = blocks.getBlockKeyRelativeToMinXYZ(4, 4, 0);
        if (block == null || block.blockID != this || block.metadata != 2) {
            return false;
        }
        block = blocks.getBlockKeyRelativeToMinXYZ(0, 4, 4);
        if (block == null || block.blockID != this || block.metadata != 2) {
            return false;
        }
        block = blocks.getBlockKeyRelativeToMinXYZ(4, 4, 4);
        return block != null && block.blockID == this && block.metadata == 2;
    }

    @Override
    public void onCreateFullMultiBlock(World world, int x, int y, int z) {
        BlockArray blocks = new BlockArray();
        blocks.recursiveAddWithBounds((IBlockAccess)world, x, y, z, (Block)this, x - 6, y - 6, z - 6, x + 6, y + 6, z + 6);
        for (int i = 0; i < blocks.getSize(); ++i) {
            Coordinate c = blocks.getNthBlock(i);
            int meta = c.getBlockMetadata((IBlockAccess)world);
            if (meta < 8) {
                world.func_72921_c(c.xCoord, c.yCoord, c.zCoord, meta + 8, 3);
            }
            if (meta != 0) continue;
            for (int k = 2; k < 6; ++k) {
                ForgeDirection dir = dirs[k];
                int dx = c.xCoord + dir.offsetX;
                int dy = c.yCoord + dir.offsetY;
                int dz = c.zCoord + dir.offsetZ;
                if (ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz) != ReactorTiles.HEATER) continue;
                TileEntityFusionHeater te = (TileEntityFusionHeater)world.func_147438_o(dx, dy, dz);
                te.setHasMultiBlock(true);
            }
        }
    }

    @Override
    public void breakMultiBlock(World world, int x, int y, int z) {
        BlockArray blocks = new BlockArray();
        blocks.recursiveAddWithBounds((IBlockAccess)world, x, y, z, (Block)this, x - 6, y - 6, z - 6, x + 6, y + 6, z + 6);
        for (int i = 0; i < blocks.getSize(); ++i) {
            Coordinate c = blocks.getNthBlock(i);
            int meta = c.getBlockMetadata((IBlockAccess)world);
            world.func_72921_c(c.xCoord, c.yCoord, c.zCoord, meta & 7, 3);
            if (meta != 8) continue;
            for (int k = 2; k < 6; ++k) {
                ForgeDirection dir = dirs[k];
                int dx = c.xCoord + dir.offsetX;
                int dy = c.yCoord + dir.offsetY;
                int dz = c.zCoord + dir.offsetZ;
                if (ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz) != ReactorTiles.HEATER) continue;
                TileEntityFusionHeater te = (TileEntityFusionHeater)world.func_147438_o(dx, dy, dz);
                te.setHasMultiBlock(false);
            }
        }
    }

    @Override
    protected String getIconBaseName() {
        return "heater";
    }

    public boolean isOpaque(int meta) {
        return meta != 0 && meta != 8;
    }

    @Override
    public int getTextureIndex(IBlockAccess world, int x, int y, int z, int side, int meta) {
        int dmeta;
        Block did;
        if ((meta & 7) <= 1) {
            return meta & 7;
        }
        if (meta == 12) {
            return 10;
        }
        if (meta == 2) {
            return 11;
        }
        if (meta == 3) {
            return 12;
        }
        if (meta == 4) {
            return 10;
        }
        if (meta == 10) {
            switch (side) {
                case 0: {
                    if (world.func_147439_a(x + 1, y, z + 1) == this && world.func_72805_g(x + 1, y, z + 1) == 12) {
                        return 2;
                    }
                    if (world.func_147439_a(x - 1, y, z + 1) == this && world.func_72805_g(x - 1, y, z + 1) == 12) {
                        return 3;
                    }
                    if (world.func_147439_a(x + 1, y, z - 1) == this && world.func_72805_g(x + 1, y, z - 1) == 12) {
                        return 5;
                    }
                    if (world.func_147439_a(x - 1, y, z - 1) != this || world.func_72805_g(x - 1, y, z - 1) != 12) break;
                    return 4;
                }
                case 1: {
                    if (world.func_147439_a(x + 1, y, z + 1) == this && world.func_72805_g(x + 1, y, z + 1) == 9) {
                        return 2;
                    }
                    if (world.func_147439_a(x - 1, y, z + 1) == this && world.func_72805_g(x - 1, y, z + 1) == 9) {
                        return 3;
                    }
                    if (world.func_147439_a(x + 1, y, z - 1) == this && world.func_72805_g(x + 1, y, z - 1) == 9) {
                        return 5;
                    }
                    if (world.func_147439_a(x - 1, y, z - 1) == this && world.func_72805_g(x - 1, y, z - 1) == 9) {
                        return 4;
                    }
                    if (world.func_147439_a(x, y - 1, z) != this || world.func_72805_g(x, y - 1, z) != 9) break;
                    did = ReactorTiles.MAGNETPIPE.getBlock();
                    dmeta = ReactorTiles.MAGNETPIPE.getBlockMetadata();
                    if (world.func_147439_a(x + 1, y, z + 1) == did && world.func_72805_g(x + 1, y, z + 1) == dmeta && world.func_147439_a(x, y, z + 1) == this) {
                        return 2;
                    }
                    if (world.func_147439_a(x - 1, y, z + 1) == did && world.func_72805_g(x - 1, y, z + 1) == dmeta && world.func_147439_a(x, y, z + 1) == this) {
                        return 3;
                    }
                    if (world.func_147439_a(x + 1, y, z - 1) == did && world.func_72805_g(x + 1, y, z - 1) == dmeta && world.func_147439_a(x, y, z - 1) == this) {
                        return 5;
                    }
                    if (world.func_147439_a(x - 1, y, z - 1) != did || world.func_72805_g(x - 1, y, z - 1) != dmeta || world.func_147439_a(x, y, z - 1) != this) break;
                    return 4;
                }
                case 2: {
                    if (world.func_147439_a(x + 1, y + 1, z) == this && world.func_72805_g(x + 1, y + 1, z) == 12) {
                        return 4;
                    }
                    if (world.func_147439_a(x - 1, y + 1, z) == this && world.func_72805_g(x - 1, y + 1, z) == 12) {
                        return 5;
                    }
                    if (world.func_147439_a(x + 1, y - 1, z) == this && world.func_72805_g(x + 1, y - 1, z) == 12) {
                        return 3;
                    }
                    if (world.func_147439_a(x - 1, y - 1, z) == this && world.func_72805_g(x - 1, y - 1, z) == 12) {
                        return 2;
                    }
                    if (world.func_147439_a(x, y - 1, z) != this || world.func_72805_g(x, y - 1, z) != 9) break;
                    did = ReactorTiles.MAGNETPIPE.getBlock();
                    dmeta = ReactorTiles.MAGNETPIPE.getBlockMetadata();
                    if (world.func_147439_a(x + 1, y, z + 1) == did && world.func_72805_g(x + 1, y, z + 1) == dmeta && world.func_147439_a(x, y, z + 1) == this) {
                        return 3;
                    }
                    if (world.func_147439_a(x - 1, y, z + 1) != did || world.func_72805_g(x - 1, y, z + 1) != dmeta || world.func_147439_a(x, y, z + 1) != this) break;
                    return 2;
                }
                case 3: {
                    if (world.func_147439_a(x + 1, y + 1, z) == this && world.func_72805_g(x + 1, y + 1, z) == 12) {
                        return 5;
                    }
                    if (world.func_147439_a(x - 1, y + 1, z) == this && world.func_72805_g(x - 1, y + 1, z) == 12) {
                        return 4;
                    }
                    if (world.func_147439_a(x + 1, y - 1, z) == this && world.func_72805_g(x + 1, y - 1, z) == 12) {
                        return 2;
                    }
                    if (world.func_147439_a(x - 1, y - 1, z) == this && world.func_72805_g(x - 1, y - 1, z) == 12) {
                        return 3;
                    }
                    if (world.func_147439_a(x, y - 1, z) != this || world.func_72805_g(x, y - 1, z) != 9) break;
                    did = ReactorTiles.MAGNETPIPE.getBlock();
                    dmeta = ReactorTiles.MAGNETPIPE.getBlockMetadata();
                    if (world.func_147439_a(x + 1, y, z - 1) == did && world.func_72805_g(x + 1, y, z - 1) == dmeta && world.func_147439_a(x, y, z - 1) == this) {
                        return 2;
                    }
                    if (world.func_147439_a(x - 1, y, z - 1) != did || world.func_72805_g(x - 1, y, z - 1) != dmeta || world.func_147439_a(x, y, z - 1) != this) break;
                    return 3;
                }
                case 4: {
                    if (world.func_147439_a(x, y + 1, z + 1) == this && world.func_72805_g(x, y + 1, z + 1) == 12) {
                        return 5;
                    }
                    if (world.func_147439_a(x, y + 1, z - 1) == this && world.func_72805_g(x, y + 1, z - 1) == 12) {
                        return 4;
                    }
                    if (world.func_147439_a(x, y - 1, z + 1) == this && world.func_72805_g(x, y - 1, z + 1) == 12) {
                        return 2;
                    }
                    if (world.func_147439_a(x, y - 1, z - 1) == this && world.func_72805_g(x, y - 1, z - 1) == 12) {
                        return 3;
                    }
                    if (world.func_147439_a(x, y - 1, z) != this || world.func_72805_g(x, y - 1, z) != 9) break;
                    did = ReactorTiles.MAGNETPIPE.getBlock();
                    dmeta = ReactorTiles.MAGNETPIPE.getBlockMetadata();
                    if (world.func_147439_a(x + 1, y, z + 1) == did && world.func_72805_g(x + 1, y, z + 1) == dmeta && world.func_147439_a(x, y, z + 1) == this) {
                        return 2;
                    }
                    if (world.func_147439_a(x + 1, y, z - 1) != did || world.func_72805_g(x + 1, y, z - 1) != dmeta || world.func_147439_a(x, y, z - 1) != this) break;
                    return 3;
                }
                case 5: {
                    if (world.func_147439_a(x, y + 1, z + 1) == this && world.func_72805_g(x, y + 1, z + 1) == 12) {
                        return 4;
                    }
                    if (world.func_147439_a(x, y + 1, z - 1) == this && world.func_72805_g(x, y + 1, z - 1) == 12) {
                        return 5;
                    }
                    if (world.func_147439_a(x, y - 1, z + 1) == this && world.func_72805_g(x, y - 1, z + 1) == 12) {
                        return 3;
                    }
                    if (world.func_147439_a(x, y - 1, z - 1) == this && world.func_72805_g(x, y - 1, z - 1) == 12) {
                        return 2;
                    }
                    if (world.func_147439_a(x, y - 1, z) != this || world.func_72805_g(x, y - 1, z) != 9) break;
                    did = ReactorTiles.MAGNETPIPE.getBlock();
                    dmeta = ReactorTiles.MAGNETPIPE.getBlockMetadata();
                    if (world.func_147439_a(x - 1, y, z + 1) == did && world.func_72805_g(x - 1, y, z + 1) == dmeta && world.func_147439_a(x, y, z + 1) == this) {
                        return 3;
                    }
                    if (world.func_147439_a(x - 1, y, z - 1) != did || world.func_72805_g(x - 1, y, z - 1) != dmeta || world.func_147439_a(x, y, z - 1) != this) break;
                    return 2;
                }
            }
        }
        if (meta == 11) {
            switch (side) {
                case 0: {
                    if (world.func_147439_a(x + 1, y, z) == this && world.func_72805_g(x + 1, y, z) == 12) {
                        return 8;
                    }
                    if (world.func_147439_a(x - 1, y, z) == this && world.func_72805_g(x - 1, y, z) == 12) {
                        return 7;
                    }
                    if (world.func_147439_a(x, y, z + 1) == this && world.func_72805_g(x, y, z + 1) == 12) {
                        return 9;
                    }
                    if (world.func_147439_a(x, y, z - 1) != this || world.func_72805_g(x, y, z - 1) != 12) break;
                    return 6;
                }
                case 1: {
                    if (world.func_147439_a(x + 1, y, z) == this && world.func_72805_g(x + 1, y, z) == 9) {
                        return 8;
                    }
                    if (world.func_147439_a(x - 1, y, z) == this && world.func_72805_g(x - 1, y, z) == 9) {
                        return 7;
                    }
                    if (world.func_147439_a(x, y, z + 1) == this && world.func_72805_g(x, y, z + 1) == 9) {
                        return 9;
                    }
                    if (world.func_147439_a(x, y, z - 1) == this && world.func_72805_g(x, y, z - 1) == 9) {
                        return 6;
                    }
                    if (world.func_147439_a(x, y - 1, z) != this || world.func_72805_g(x, y - 1, z) != 9) break;
                    did = ReactorTiles.MAGNETPIPE.getBlock();
                    dmeta = ReactorTiles.MAGNETPIPE.getBlockMetadata();
                    if (world.func_147439_a(x + 1, y, z) == did && world.func_72805_g(x + 1, y, z) == dmeta && world.func_147439_a(x - 1, y, z) == Blocks.field_150350_a) {
                        return 8;
                    }
                    if (world.func_147439_a(x - 1, y, z) == did && world.func_72805_g(x - 1, y, z) == dmeta && world.func_147439_a(x + 1, y, z) == Blocks.field_150350_a) {
                        return 7;
                    }
                    if (world.func_147439_a(x, y, z + 1) == did && world.func_72805_g(x, y, z + 1) == dmeta && world.func_147439_a(x, y, z - 1) == Blocks.field_150350_a) {
                        return 9;
                    }
                    if (world.func_147439_a(x, y, z - 1) != did || world.func_72805_g(x, y, z - 1) != dmeta || world.func_147439_a(x, y, z + 1) != Blocks.field_150350_a) break;
                    return 6;
                }
                case 2: {
                    if (world.func_147439_a(x + 1, y, z) == this && world.func_72805_g(x + 1, y, z) == 12) {
                        return 7;
                    }
                    if (world.func_147439_a(x - 1, y, z) == this && world.func_72805_g(x - 1, y, z) == 12) {
                        return 8;
                    }
                    if (world.func_147439_a(x, y + 1, z) == this && world.func_72805_g(x, y + 1, z) == 12) {
                        return 6;
                    }
                    if (world.func_147439_a(x, y - 1, z) == this && world.func_72805_g(x, y - 1, z) == 12) {
                        return 9;
                    }
                    if (world.func_147439_a(x, y - 1, z) != this || world.func_72805_g(x, y - 1, z) != 9) break;
                    did = ReactorTiles.MAGNETPIPE.getBlock();
                    dmeta = ReactorTiles.MAGNETPIPE.getBlockMetadata();
                    if (world.func_147439_a(x, y, z + 1) != did || world.func_72805_g(x, y, z + 1) != dmeta) break;
                    return 9;
                }
                case 3: {
                    if (world.func_147439_a(x + 1, y, z) == this && world.func_72805_g(x + 1, y, z) == 12) {
                        return 8;
                    }
                    if (world.func_147439_a(x - 1, y, z) == this && world.func_72805_g(x - 1, y, z) == 12) {
                        return 7;
                    }
                    if (world.func_147439_a(x, y + 1, z) == this && world.func_72805_g(x, y + 1, z) == 12) {
                        return 6;
                    }
                    if (world.func_147439_a(x, y - 1, z) == this && world.func_72805_g(x, y - 1, z) == 12) {
                        return 9;
                    }
                    if (world.func_147439_a(x, y - 1, z) != this || world.func_72805_g(x, y - 1, z) != 9) break;
                    did = ReactorTiles.MAGNETPIPE.getBlock();
                    dmeta = ReactorTiles.MAGNETPIPE.getBlockMetadata();
                    if (world.func_147439_a(x, y, z - 1) != did || world.func_72805_g(x, y, z - 1) != dmeta) break;
                    return 9;
                }
                case 4: {
                    if (world.func_147439_a(x, y, z + 1) == this && world.func_72805_g(x, y, z + 1) == 12) {
                        return 8;
                    }
                    if (world.func_147439_a(x, y, z - 1) == this && world.func_72805_g(x, y, z - 1) == 12) {
                        return 7;
                    }
                    if (world.func_147439_a(x, y + 1, z) == this && world.func_72805_g(x, y + 1, z) == 12) {
                        return 6;
                    }
                    if (world.func_147439_a(x, y - 1, z) == this && world.func_72805_g(x, y - 1, z) == 12) {
                        return 9;
                    }
                    if (world.func_147439_a(x, y - 1, z) != this || world.func_72805_g(x, y - 1, z) != 9) break;
                    did = ReactorTiles.MAGNETPIPE.getBlock();
                    dmeta = ReactorTiles.MAGNETPIPE.getBlockMetadata();
                    if (world.func_147439_a(x + 1, y, z) != did || world.func_72805_g(x + 1, y, z) != dmeta) break;
                    return 9;
                }
                case 5: {
                    if (world.func_147439_a(x, y, z + 1) == this && world.func_72805_g(x, y, z + 1) == 12) {
                        return 7;
                    }
                    if (world.func_147439_a(x, y, z - 1) == this && world.func_72805_g(x, y, z - 1) == 12) {
                        return 8;
                    }
                    if (world.func_147439_a(x, y + 1, z) == this && world.func_72805_g(x, y + 1, z) == 12) {
                        return 6;
                    }
                    if (world.func_147439_a(x, y - 1, z) == this && world.func_72805_g(x, y - 1, z) == 12) {
                        return 9;
                    }
                    if (world.func_147439_a(x, y - 1, z) != this || world.func_72805_g(x, y - 1, z) != 9) break;
                    did = ReactorTiles.MAGNETPIPE.getBlock();
                    dmeta = ReactorTiles.MAGNETPIPE.getBlockMetadata();
                    if (world.func_147439_a(x - 1, y, z) != did || world.func_72805_g(x - 1, y, z) != dmeta) break;
                    return 9;
                }
            }
        }
        return this.getItemTextureIndex(meta, side);
    }

    @Override
    public int getItemTextureIndex(int meta, int side) {
        if ((meta &= 7) == 2) {
            return 11;
        }
        if (meta == 3) {
            return 12;
        }
        if (meta == 4) {
            return 10;
        }
        return meta <= 1 ? meta : 11;
    }

    @Override
    public boolean canTriggerMultiBlockCheck(World world, int x, int y, int z, int meta) {
        return true;
    }

    @Override
    public int getNumberTextures() {
        return 13;
    }

    @Override
    protected TileEntity getTileEntityForPosition(World world, int x, int y, int z) {
        StructuredBlockArray blocks = new StructuredBlockArray(world);
        Set li = ReikaJavaLibrary.getSet((Object[])new BlockKey[]{new BlockKey((Block)this), new BlockKey((TileEnum)ReactorTiles.HEATER)});
        blocks.recursiveAddMultipleWithBounds((IBlockAccess)world, x, y, z, li, x - 6, y - 6, z - 6, x + 6, y + 6, z + 6);
        int mx = blocks.getMidX();
        int my = blocks.getMidY() - 1;
        int mz = blocks.getMidZ();
        return ReactorTiles.getTE((IBlockAccess)world, mx, my, mz) == ReactorTiles.HEATER ? world.func_147438_o(mx, my, mz) : null;
    }
}

