/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Blocks;

import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Auxiliary.RadiationEffects;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class BlockPoisonGas
extends BlockFluidClassic {
    public BlockPoisonGas(Fluid f, Material material) {
        super(f, material);
        this.func_149711_c(100.0f);
        this.func_149713_g(0);
        this.func_149752_b(500.0f);
        this.func_149647_a((CreativeTabs)(ReactorCraft.instance.isLocked() ? null : ReactorCraft.tabRctr));
    }

    protected void flowIntoBlock(World world, int x, int y, int z, int l) {
        Block b = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (this.liquidCanDisplaceBlock((IBlockAccess)world, x, y, z)) {
            if (b.func_149688_o() == Material.field_151585_k || b.func_149688_o() == Material.field_151577_b || b.func_149688_o() == Material.field_151582_l || b.func_149688_o() == Material.field_151575_d || b.func_149688_o() == Material.field_151584_j || b.func_149688_o() == Material.field_151580_n || b.func_149688_o() == Material.field_151572_C) {
                if (this.shouldReactHypergolically()) {
                    world.func_147465_d(x, y, z, (Block)Blocks.field_150480_ab, 0, 3);
                } else {
                    world.func_147465_d(x, y, z, (Block)this, l, 3);
                }
            } else {
                if (!b.isAir((IBlockAccess)world, x, y, z)) {
                    b.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
                }
                world.func_147465_d(x, y, z, (Block)this, l, 3);
            }
        }
    }

    private boolean shouldReactHypergolically() {
        return this.getFluid() == ReactorCraft.HF;
    }

    private boolean blockBlocksFlow(IBlockAccess world, int x, int y, int z) {
        Block l = world.func_147439_a(x, y, z);
        return l.func_149688_o().func_76230_c() || l instanceof BlockFire;
    }

    protected boolean canFlowInto(IBlockAccess world, int x, int y, int z) {
        return this.liquidCanDisplaceBlock(world, x, y, z);
    }

    private boolean liquidCanDisplaceBlock(IBlockAccess world, int i, int j, int k) {
        Material mat = ReikaWorldHelper.getMaterial((IBlockAccess)world, (int)i, (int)j, (int)k);
        return mat != this.field_149764_J && !this.blockBlocksFlow(world, i, j, k);
    }

    public boolean isReplaceable(IBlockAccess world, int i, int j, int k) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ico) {
        this.field_149761_L = ico.func_94245_a("ReactorCraft:fluid/" + ReactorBlocks.getBlock((Block)this).name().toLowerCase(Locale.ENGLISH));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int s, int meta) {
        return this.field_149761_L;
    }

    public void func_149726_b(World world, int par2, int par3, int par4) {
        world.func_147464_a(par2, par3, par4, (Block)this, this.func_149738_a(world));
    }

    public void func_149670_a(World world, int x, int y, int z, Entity e) {
        EntityLivingBase elb;
        if (e instanceof EntityLivingBase && !RadiationEffects.instance.hasHazmatSuit(elb = (EntityLivingBase)e)) {
            elb.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 20, 4));
            if (world.field_73012_v.nextInt(8) == 0) {
                elb.func_70097_a((DamageSource)ReactorCraft.gasDamage, 1.0f);
            }
            if (this.shouldReactHypergolically()) {
                elb.func_70015_d(5);
            }
        }
    }

    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        switch (ReactorBlocks.getBlock((Block)this)) {
            case CHLORINE: {
                if (rand.nextInt(1 + Minecraft.func_71410_x().field_71474_y.field_74362_aa) != 0) break;
                int clr = Potion.field_76436_u.func_76401_j();
                double r = (double)ReikaColorAPI.getRed((int)clr) / 255.0;
                double g = (double)ReikaColorAPI.getGreen((int)clr) / 255.0;
                double b = (double)ReikaColorAPI.getBlue((int)clr) / 255.0;
                ReikaParticleHelper.MOBSPELL.spawnAroundBlock(world, x, y, z, r, g, b, 1);
                break;
            }
            case HF: {
                int clr = Potion.field_76436_u.func_76401_j();
                double r = (double)ReikaColorAPI.getRed((int)clr) / 255.0;
                double g = (double)ReikaColorAPI.getGreen((int)clr) / 255.0;
                double b = (double)ReikaColorAPI.getBlue((int)clr) / 255.0;
                ReikaParticleHelper.AMBIENTMOBSPELL.spawnAroundBlock(world, x, y, z, r, g, b, 1);
                if (rand.nextInt(64) == 0) {
                    ReikaParticleHelper.CLOUD.spawnAroundBlock(world, x, y, z, 1);
                }
                if (rand.nextInt(16) != 0) break;
                ReikaParticleHelper.FLAME.spawnAroundBlock(world, x, y, z, 1);
                break;
            }
        }
    }
}

