/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.lib.prefab;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Map;
import me.planetguy.lib.prefab.IPrefabItem;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;

public class FluidPrefab
extends Fluid
implements IPrefabItem {
    public String namespace;
    public ItemBucket bucket;
    public BlockFluidBase block;

    public FluidPrefab(String name) {
        super(name);
    }

    public void setupOtherTypes() {
        this.block = this.makeBlock();
        this.registerBlock(this.block);
        this.bucket = this.makeBucket();
        this.registerBucket(this.bucket);
        BucketHandler.register((Block)this.block, (Item)this.bucket);
    }

    public BlockFluidBase makeBlock() {
        return new BlockFluidFinite((Fluid)this, Material.field_151586_h);
    }

    public void registerBlock(BlockFluidBase block) {
        String blockName = this.unlocalizedName + "_block";
        block.func_149663_c(this.namespace + ":" + blockName);
        GameRegistry.registerBlock((Block)block, (String)blockName);
    }

    public ItemBucket makeBucket() {
        return new ItemBucket((Block)this.block);
    }

    public void registerBucket(ItemBucket bucket) {
        bucket.func_77655_b(this.unlocalizedName + "_bucket");
        GameRegistry.registerItem((Item)bucket, (String)(this.unlocalizedName + "_bucket"));
        FluidContainerRegistry.registerFluidContainer((Fluid)this, (ItemStack)new ItemStack((Item)bucket), (ItemStack)new ItemStack(Items.field_151133_ar));
    }

    @Override
    public void loadCrafting() {
    }

    @Override
    public Object setCreativeTab(CreativeTabs tab) {
        this.bucket.func_77637_a(tab);
        return this;
    }

    public static class BucketHandler {
        public static boolean initialized = false;
        public static BucketHandler INSTANCE = new BucketHandler();
        public Map<Block, Item> buckets = new HashMap<Block, Item>();

        public static void register(Block fluid, Item bucket) {
            if (!initialized) {
                MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
            }
            initialized = true;
            BucketHandler.INSTANCE.buckets.put(fluid, bucket);
        }

        private BucketHandler() {
        }

        @SubscribeEvent
        public void onBucketFill(FillBucketEvent event) {
            ItemStack result = this.fillCustomBucket(event.world, event.target);
            if (result == null) {
                return;
            }
            event.result = result;
            event.setResult(Event.Result.ALLOW);
        }

        private ItemStack fillCustomBucket(World world, MovingObjectPosition pos) {
            Block block = world.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
            Item bucket = this.buckets.get(block);
            if (bucket != null && world.func_72805_g(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d) == 0) {
                world.func_147468_f(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                return new ItemStack(bucket);
            }
            return null;
        }
    }
}

