/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.lib.asyncworld;

import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import me.planetguy.lib.asyncworld.AsyncWorld;
import me.planetguy.lib.asyncworld.IAsyncTickable;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class AsyncBlockUpdate {
    private static ExecutorService theThreadPool = Executors.newCachedThreadPool();
    private static int tick = 0;
    private static Map<World, Queue<TickEntry>[]> globalScheduledTicks = new HashMap<World, Queue<TickEntry>[]>();

    public static void onTick(TickEvent.WorldTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            Queue<TickEntry>[] entries;
            for (Queue<TickEntry> scheduledTicks : entries = AsyncBlockUpdate.getOrCreateQueue(e.world)) {
                ArrayList<TickEntry> tasks = new ArrayList<TickEntry>();
                TickEntry te = scheduledTicks.peek();
                while (te.timeInTicks <= tick) {
                    tasks.add(scheduledTicks.remove());
                    te = scheduledTicks.peek();
                }
                try {
                    theThreadPool.invokeAll(tasks);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        } else {
            ++tick;
        }
    }

    private static Queue<TickEntry>[] getOrCreateQueue(World w) {
        Queue<TickEntry>[] entries = globalScheduledTicks.get(w);
        if (entries == null) {
            entries = new Queue[9];
            for (int i = 0; i < entries.length; ++i) {
                entries[i] = new ArrayDeque<TickEntry>();
            }
            globalScheduledTicks.put(w, entries);
        }
        return entries;
    }

    public static int getRegionFor(int x, int z) {
        return (x >> 4) % 3 + (z >> 4) % 3 * 3;
    }

    public static void scheduleAsyncTick(World w, int x, int y, int z, int delay) {
        int regionToScheduleIn = (x >> 4) % 3 + 3 * ((z >> 4) % 3);
        AsyncBlockUpdate.getOrCreateQueue(w)[regionToScheduleIn].add(new TickEntry(w, x, y, z, delay));
    }

    public static class TickEntry
    implements Comparable<TickEntry>,
    Callable {
        private final int timeInTicks;
        private final World w;
        private final int x;
        private final int y;
        private final int z;

        @Override
        public int compareTo(TickEntry a) {
            return this.timeInTicks - a.timeInTicks;
        }

        public TickEntry(World w, int x, int y, int z, int timeFromNow) {
            this.timeInTicks = timeFromNow + tick;
            this.w = w;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call() throws Exception {
            try {
                Chunk chunk = AsyncWorld.getChunk(this.w, this.x, this.z);
                synchronized (chunk) {
                    ((IAsyncTickable)AsyncWorld.getBlock(this.w, this.x, this.y, this.z)).onAsyncLocalUpdate(this.w, this.x, this.y, this.z);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return null;
        }
    }
}

