/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.lib;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import me.planetguy.lib.PlanetguyLib;
import me.planetguy.lib.prefab.BlockBase;
import me.planetguy.lib.prefab.BlockContainerBase;
import me.planetguy.lib.prefab.FluidPrefab;
import me.planetguy.lib.prefab.IPrefabItem;
import me.planetguy.lib.prefab.ItemBase;
import me.planetguy.lib.prefab.ItemBlockBase;
import me.planetguy.lib.util.Reflection;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class PLHelper {
    private final String modID;
    private Configuration cfg = null;

    public PLHelper(String modID) {
        this.modID = modID;
        File f = new File(PlanetguyLib.instance.configFolder, this.modID + ".cfg");
        try {
            f.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.cfg = new Configuration(f);
    }

    public PLHelper(String modID, Configuration banConfig) {
        this(modID);
    }

    public void playSound(World w, double x, double y, double z, String name, float volume, float pitch) {
        this.playUnNamespacedSound(w, x, y, z, this.modID + ":" + name, volume, pitch);
    }

    public void playUnNamespacedSound(World w, double x, double y, double z, String name, float volume, float pitch) {
        for (Object o : (Iterable)Reflection.get(World.class, w, "worldAccesses")) {
            IWorldAccess iwa = (IWorldAccess)o;
            iwa.func_72704_a(name, x, y, z, volume, pitch);
        }
    }

    public IPrefabItem loadBlock(Class<? extends BlockBase> clazz, HashMap<String, IPrefabItem> map) {
        if (!this.shouldLoad(clazz)) {
            return null;
        }
        try {
            BlockBase block = clazz.newInstance();
            block.modID = this.modID;
            GameRegistry.registerBlock((Block)block, ItemBlockBase.class, (String)block.getName());
            map.put(block.getName(), block);
            return block;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public IPrefabItem loadItem(Class<? extends ItemBase> clazz, HashMap<String, IPrefabItem> map) {
        if (!this.shouldLoad(clazz)) {
            return null;
        }
        try {
            ItemBase item = clazz.newInstance();
            item.modID = this.modID;
            GameRegistry.registerItem((Item)item, (String)item.name);
            map.put(item.name, item);
            return item;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    public IPrefabItem loadContainer(Class<? extends BlockContainerBase> clazz, HashMap<String, IPrefabItem> map) {
        if (!this.shouldLoad(clazz)) {
            return null;
        }
        try {
            BlockContainerBase block = clazz.newInstance();
            block.modid = this.modID;
            for (Class c : block.teClasses) {
                GameRegistry.registerTileEntity((Class)c, (String)(block.modid + ".te." + c.getSimpleName()));
            }
            GameRegistry.registerBlock((Block)block, ItemBlockBase.class, (String)block.getName());
            map.put(block.getName(), block);
            return block;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public IPrefabItem loadFluid(Class<? extends FluidPrefab> clazz, HashMap<String, IPrefabItem> map) {
        try {
            FluidPrefab fluid = clazz.newInstance();
            fluid.namespace = this.modID;
            FluidRegistry.registerFluid((Fluid)fluid);
            map.put(fluid.getName(), fluid);
            fluid.setupOtherTypes();
            return fluid;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Object load(Class c, HashMap<String, IPrefabItem> content) {
        Object o = this.loadImpl(c, content);
        if (o instanceof IPrefabItem) {
            this.process((IPrefabItem)o);
        }
        return o;
    }

    public Object loadImpl(Class c, HashMap<String, IPrefabItem> content) {
        if (!this.shouldLoad(c)) {
            return null;
        }
        if (ItemBase.class.isAssignableFrom(c)) {
            return this.loadItem(c, content);
        }
        if (BlockBase.class.isAssignableFrom(c)) {
            return this.loadBlock(c, content);
        }
        if (BlockContainerBase.class.isAssignableFrom(c)) {
            return this.loadContainer(c, content);
        }
        if (FluidPrefab.class.isAssignableFrom(c)) {
            return this.loadFluid(c, content);
        }
        throw new RuntimeException("Failed to load " + c + ": Not a legal class type!");
    }

    public String translate(String nonNamespacedKey) {
        return LanguageRegistry.instance().getStringLocalization(this.modID + "." + nonNamespacedKey);
    }

    public boolean shouldLoad(Class c) {
        this.cfg.load();
        boolean b = this.cfg.getBoolean("Allow " + c.getSimpleName(), "itemRestrict", true, "");
        this.cfg.save();
        return b;
    }

    public void process(IPrefabItem i) {
    }
}

