/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.api;

import com.jaquadro.minecraft.gardencore.core.ModBlocks;
import com.jaquadro.minecraft.gardencore.util.UniqueMetaIdentifier;
import com.jaquadro.minecraft.gardencore.util.UniqueMetaRegistry;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public final class WoodRegistry {
    private final UniqueMetaRegistry<Block> registry = new UniqueMetaRegistry();
    private static WoodRegistry instance = new WoodRegistry();

    public static WoodRegistry instance() {
        return instance;
    }

    private WoodRegistry() {
        this.registerWoodType(Blocks.field_150364_r, 0);
        this.registerWoodType(Blocks.field_150364_r, 1);
        this.registerWoodType(Blocks.field_150364_r, 2);
        this.registerWoodType(Blocks.field_150364_r, 3);
        this.registerWoodType(Blocks.field_150363_s, 0);
        this.registerWoodType(Blocks.field_150363_s, 1);
    }

    public void registerWoodType(Block block, int meta) {
        if (block == null) {
            return;
        }
        UniqueMetaIdentifier id = ModBlocks.getUniqueMetaID(block, meta);
        if (id != null) {
            this.registry.register(id, block);
        }
    }

    public Set<Map.Entry<UniqueMetaIdentifier, Block>> registeredTypes() {
        return this.registry.entrySet();
    }

    public boolean contains(Block wood, int woodMeta) {
        return this.contains(ModBlocks.getUniqueMetaID(wood, woodMeta));
    }

    public boolean contains(UniqueMetaIdentifier wood) {
        return this.registry.getEntry(wood) != null;
    }
}

