/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencontainers.block.tile;

import com.jaquadro.minecraft.gardencore.block.BlockGarden;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityGarden;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class TileEntityWindowBox
extends TileEntityGarden {
    private int direction;

    @Override
    protected int containerSlotCount() {
        return 6;
    }

    public int getDirection() {
        return this.direction & 7;
    }

    public boolean isUpper() {
        return (this.direction & 8) != 0;
    }

    public void setDirection(int direction) {
        this.direction = this.direction & 8 | direction & 7;
    }

    public void setUpper(boolean isUpper) {
        this.direction &= 7;
        if (isUpper) {
            this.direction |= 8;
        }
    }

    @Override
    public boolean isSlotValid(int slot) {
        int rdir;
        int dir = this.getDirection();
        BlockGarden garden = this.getGardenBlock();
        if (garden == null) {
            return false;
        }
        if (garden.getConnectionProfile().isAttachedNeighbor((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, dir)) {
            int facingDir = this.getNeighborDirection(dir);
            switch (slot) {
                case 1: {
                    if (dir == 2 && facingDir == 5) {
                        return false;
                    }
                    if (dir != 4 || facingDir != 3) break;
                    return false;
                }
                case 2: {
                    if (dir == 2 && facingDir == 4) {
                        return false;
                    }
                    if (dir != 5 || facingDir != 3) break;
                    return false;
                }
                case 3: {
                    if (dir == 3 && facingDir == 5) {
                        return false;
                    }
                    if (dir != 4 || facingDir != 2) break;
                    return false;
                }
                case 4: {
                    if (dir == 3 && facingDir == 4) {
                        return false;
                    }
                    if (dir != 5 || facingDir != 2) break;
                    return false;
                }
            }
        }
        int n = rdir = dir % 2 == 0 ? dir + 1 : dir - 1;
        if (garden.getConnectionProfile().isAttachedNeighbor((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, rdir)) {
            int facingDir = this.getNeighborDirection(rdir);
            switch (slot) {
                case 1: {
                    if (dir == 3 && facingDir == 4) {
                        return true;
                    }
                    if (dir != 5 || facingDir != 2) break;
                    return true;
                }
                case 2: {
                    if (dir == 3 && facingDir == 5) {
                        return true;
                    }
                    if (dir != 4 || facingDir != 2) break;
                    return true;
                }
                case 3: {
                    if (dir == 2 && facingDir == 4) {
                        return true;
                    }
                    if (dir != 5 || facingDir != 3) break;
                    return true;
                }
                case 4: {
                    if (dir == 2 && facingDir == 5) {
                        return true;
                    }
                    if (dir != 4 || facingDir != 3) break;
                    return true;
                }
            }
        }
        switch (slot) {
            case 0: {
                return true;
            }
            case 1: {
                if (dir != 2 && dir != 4) break;
                return true;
            }
            case 2: {
                if (dir != 2 && dir != 5) break;
                return true;
            }
            case 3: {
                if (dir != 3 && dir != 4) break;
                return true;
            }
            case 4: {
                if (dir != 3 && dir != 5) break;
                return true;
            }
        }
        return false;
    }

    private int getNeighborDirection(int direction) {
        TileEntity te = null;
        if (direction == 2) {
            te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
        } else if (direction == 3) {
            te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
        } else if (direction == 4) {
            te = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
        } else if (direction == 5) {
            te = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
        }
        if (te instanceof TileEntityWindowBox) {
            TileEntityWindowBox wb = (TileEntityWindowBox)te;
            return wb.getDirection();
        }
        return -1;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.direction = 0;
        if (tag.func_74764_b("Dir")) {
            this.direction = tag.func_74771_c("Dir");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74774_a("Dir", (byte)this.direction);
    }
}

