/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.update;

import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.update.UpdateChecker;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;

public class ThreadUpdateChecker
extends Thread {
    public ThreadUpdateChecker() {
        this.setName("ActuallyAdditions Update Checker");
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        ModUtil.LOGGER.info("Starting Update Check...");
        try {
            URL newestURL = new URL("https://raw.githubusercontent.com/Ellpeck/ActuallyAdditions/master/update/updateVersions.properties");
            Properties updateProperties = new Properties();
            updateProperties.load(new InputStreamReader(newestURL.openStream()));
            String currentMcVersion = "1.7.10-r21".split("-")[0];
            if (ConfigBoolValues.UPDATE_CHECK_VERSION_SPECIFIC.isEnabled()) {
                String newestVersionProp = updateProperties.getProperty(currentMcVersion);
                UpdateChecker.updateVersionInt = Integer.parseInt(newestVersionProp);
                UpdateChecker.updateVersionString = currentMcVersion + "-r" + newestVersionProp;
            } else {
                int highest = 0;
                String highestString = "";
                for (String updateMC : updateProperties.stringPropertyNames()) {
                    String updateVersion = updateProperties.getProperty(updateMC);
                    int update = Integer.parseInt(updateVersion);
                    if (highest >= update) continue;
                    highest = update;
                    highestString = updateMC + "-r" + updateVersion;
                }
                UpdateChecker.updateVersionInt = highest;
                UpdateChecker.updateVersionString = highestString;
            }
            int clientVersion = Integer.parseInt("1.7.10-r21".substring("1.7.10-r21".indexOf("r") + 1));
            if (UpdateChecker.updateVersionInt > clientVersion) {
                UpdateChecker.needsUpdateNotify = true;
            }
            ModUtil.LOGGER.info("Update Check done!");
        }
        catch (Exception e) {
            ModUtil.LOGGER.error("Update Check failed!", (Throwable)e);
            UpdateChecker.checkFailed = true;
        }
        if (!UpdateChecker.checkFailed) {
            if (UpdateChecker.needsUpdateNotify) {
                ModUtil.LOGGER.info("There is an Update for Actually Additions available!");
                ModUtil.LOGGER.info("Current Version: 1.7.10-r21, newest Version: " + UpdateChecker.updateVersionString + "!");
                ModUtil.LOGGER.info("View the Changelog at http://ellpeck.de/actaddchangelog/");
                ModUtil.LOGGER.info("Download at http://minecraft.curseforge.com/mc-mods/228404-actually-additions/files");
            } else {
                ModUtil.LOGGER.info("Actually Additions is up to date!");
            }
        }
    }
}

