/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.mod.tile.IEnergySaver;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityEnergizer
extends TileEntityInventoryBase
implements IEnergyReceiver,
IEnergySaver {
    public EnergyStorage storage = new EnergyStorage(500000);
    private int lastEnergy;

    public TileEntityEnergizer() {
        super(2, "energizer");
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof IEnergyContainerItem && this.slots[1] == null) {
                if (this.storage.getEnergyStored() > 0) {
                    int received = ((IEnergyContainerItem)this.slots[0].func_77973_b()).receiveEnergy(this.slots[0], this.storage.getEnergyStored(), false);
                    this.storage.extractEnergy(received, false);
                }
                if (((IEnergyContainerItem)this.slots[0].func_77973_b()).getEnergyStored(this.slots[0]) >= ((IEnergyContainerItem)this.slots[0].func_77973_b()).getMaxEnergyStored(this.slots[0])) {
                    this.slots[1] = this.slots[0].func_77946_l();
                    --this.slots[0].field_77994_a;
                    if (this.slots[0].field_77994_a <= 0) {
                        this.slots[0] = null;
                    }
                }
            }
            if (this.lastEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean sync) {
        this.storage.writeToNBT(compound);
        super.writeSyncableNBT(compound, sync);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean sync) {
        this.storage.readFromNBT(compound);
        super.readSyncableNBT(compound, sync);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return i == 0 && stack.func_77973_b() instanceof IEnergyContainerItem;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    @Override
    public void setEnergy(int energy) {
        this.storage.setEnergyStored(energy);
    }
}

