/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.mod.misc.EntityColoredParticleFX;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class PacketParticle
implements IMessage {
    private int startX;
    private int startY;
    private int startZ;
    private int endX;
    private int endY;
    private int endZ;
    private float[] color;
    private int particleAmount;
    private float particleSize;

    public PacketParticle() {
    }

    public PacketParticle(int startX, int startY, int startZ, int endX, int endY, int endZ, float[] color, int particleAmount, float particleSize) {
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.endX = endX;
        this.endY = endY;
        this.endZ = endZ;
        this.color = color;
        this.particleAmount = particleAmount;
        this.particleSize = particleSize;
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderParticlesFromAToB(int startX, int startY, int startZ, int endX, int endY, int endZ, int particleAmount, float particleSize, float[] color, float ageMultiplier) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (Minecraft.func_71410_x().field_71439_g.func_70011_f((double)startX, (double)startY, (double)startZ) <= 64.0 || Minecraft.func_71410_x().field_71439_g.func_70011_f((double)endX, (double)endY, (double)endZ) <= 64.0) {
            int difX = startX - endX;
            int difY = startY - endY;
            int difZ = startZ - endZ;
            double distance = Vec3.func_72443_a((double)startX, (double)startY, (double)startZ).func_72438_d(Vec3.func_72443_a((double)endX, (double)endY, (double)endZ));
            for (int times = 0; times < particleAmount / 2; ++times) {
                for (double i = 0.0; i <= 1.0; i += 1.0 / (distance * (double)particleAmount)) {
                    EntityColoredParticleFX fx = new EntityColoredParticleFX((World)world, (double)difX * i + (double)endX + 0.5, (double)difY * i + (double)endY + 0.5, (double)difZ * i + (double)endZ + 0.5, particleSize, color[0], color[1], color[2], ageMultiplier);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                }
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.startX = buf.readInt();
        this.startY = buf.readInt();
        this.startZ = buf.readInt();
        this.endX = buf.readInt();
        this.endY = buf.readInt();
        this.endZ = buf.readInt();
        this.particleAmount = buf.readInt();
        this.particleSize = buf.readFloat();
        this.color = new float[3];
        for (int i = 0; i < this.color.length; ++i) {
            this.color[i] = buf.readFloat();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.startX);
        buf.writeInt(this.startY);
        buf.writeInt(this.startZ);
        buf.writeInt(this.endX);
        buf.writeInt(this.endY);
        buf.writeInt(this.endZ);
        buf.writeInt(this.particleAmount);
        buf.writeFloat(this.particleSize);
        for (float aColor : this.color) {
            buf.writeFloat(aColor);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketParticle, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketParticle message, MessageContext ctx) {
            PacketParticle.renderParticlesFromAToB(message.startX, message.startY, message.startZ, message.endX, message.endY, message.endZ, message.particleAmount, message.particleSize, message.color, 1.0f);
            return null;
        }
    }
}

