/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.booklet.BookletPage;
import de.ellpeck.actuallyadditions.api.booklet.IBookletChapter;
import de.ellpeck.actuallyadditions.api.booklet.INEIRecipeHandler;
import de.ellpeck.actuallyadditions.mod.booklet.BookletUtils;
import de.ellpeck.actuallyadditions.mod.booklet.page.PagePicture;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class NEIBookletRecipe
extends TemplateRecipeHandler
implements INEIRecipeHandler {
    public static final String NAME = "actuallyadditions.booklet";

    public NEIBookletRecipe() {
        RecipeInfo.setGuiOffset(this.getGuiClass(), (int)0, (int)0);
    }

    @Override
    public BookletPage getPageForInfo(int page) {
        return ((CachedInfoStack)((Object)this.arecipes.get((int)page))).thePage;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(0, 18, 165, Minecraft.func_71410_x().field_71466_p.field_78288_b), NAME, new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(NAME) && this.getClass() == NEIBookletRecipe.class) {
            for (BookletPage page : ActuallyAdditionsAPI.bookletPagesWithItemStackData) {
                ItemStack[] stacks = page.getItemStacksForPage();
                ArrayList<ItemStack> nonDoubleStacks = new ArrayList<ItemStack>();
                for (ItemStack stack : stacks) {
                    if (ItemUtil.contains(nonDoubleStacks, stack, true)) continue;
                    this.arecipes.add(new CachedInfoStack(stack, page));
                    nonDoubleStacks.add(stack);
                }
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        ArrayList<BookletPage> allPages = BookletUtils.getPagesForStack(result);
        for (BookletPage page : allPages) {
            CachedInfoStack theRecipe = new CachedInfoStack(result, page);
            this.arecipes.add(theRecipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ArrayList<BookletPage> allPages = BookletUtils.getPagesForStack(ingredient);
        for (BookletPage page : allPages) {
            CachedInfoStack theRecipe = new CachedInfoStack(ingredient, page);
            this.arecipes.add(theRecipe);
        }
    }

    public String getGuiTexture() {
        return ModUtil.MOD_ID_LOWER + ":textures/gui/guiFurnaceDouble.png";
    }

    public String getOverlayIdentifier() {
        return NAME;
    }

    public void drawExtras(int recipe) {
        CachedInfoStack stack = (CachedInfoStack)((Object)this.arecipes.get(recipe));
        if (stack.theStack != null) {
            List header = Minecraft.func_71410_x().field_71466_p.func_78271_c(StringUtil.localize("container.nei." + ModUtil.MOD_ID_LOWER + ".booklet.header").replaceAll("<item>", EnumChatFormatting.BLUE + "").replaceAll("<r>", EnumChatFormatting.BLACK + ""), 165);
            for (int i = 0; i < header.size(); ++i) {
                GuiDraw.drawString((String)((String)header.get(i)), (int)0, (int)(18 + i * (Minecraft.func_71410_x().field_71466_p.field_78288_b + 1)), (int)0, (boolean)false);
            }
            int maxLines = 5;
            IBookletChapter chapter = stack.thePage.getChapter();
            String aText = (chapter.getPages()[0] instanceof PagePicture && chapter.getPages().length > 1 ? chapter.getPages()[1] : chapter.getPages()[0]).getText();
            List text = Minecraft.func_71410_x().field_71466_p.func_78271_c(aText != null ? aText : EnumChatFormatting.DARK_RED + StringUtil.localize("container.nei." + ModUtil.MOD_ID_LOWER + ".booklet.noText"), 165);
            for (int i = 0; i < Math.min(maxLines, text.size()); ++i) {
                GuiDraw.drawString((String)(text.get(i) + (i == maxLines - 1 && text.size() > maxLines ? EnumChatFormatting.RESET + "" + EnumChatFormatting.BLACK + "..." : "")), (int)0, (int)(43 + i * (Minecraft.func_71410_x().field_71466_p.field_78288_b + 1)), (int)0, (boolean)false);
            }
            GuiDraw.drawString((String)(EnumChatFormatting.ITALIC + chapter.getLocalizedName()), (int)0, (int)97, (int)0, (boolean)false);
            GuiDraw.drawString((String)(EnumChatFormatting.ITALIC + "Page " + stack.thePage.getID()), (int)0, (int)107, (int)0, (boolean)false);
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return null;
    }

    public void drawBackground(int recipe) {
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        this.drawExtras(recipe);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getRecipeName() {
        return StringUtil.localize("container.nei.actuallyadditions.booklet.name");
    }

    public class CachedInfoStack
    extends TemplateRecipeHandler.CachedRecipe {
        public ItemStack theStack;
        public BookletPage thePage;

        public CachedInfoStack(ItemStack theStack, BookletPage thePage) {
            super((TemplateRecipeHandler)NEIBookletRecipe.this);
            this.theStack = theStack;
            this.thePage = thePage;
        }

        public PositionedStack getResult() {
            if (this.theStack != null) {
                ItemStack newStack = this.theStack.func_77946_l();
                newStack.field_77994_a = 1;
                return new PositionedStack((Object)newStack, 0, 0);
            }
            return null;
        }
    }
}

