/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.api.Position;
import de.ellpeck.actuallyadditions.api.tile.IPhantomTile;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class ItemPhantomConnector
extends ItemBase {
    public ItemPhantomConnector(String name) {
        super(name);
        this.func_77625_d(1);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        if (!world.field_72995_K) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile != null && tile instanceof IPhantomTile) {
                if (this.checkHasConnection(stack, player, tile) && ItemPhantomConnector.getStoredWorld(stack) == world) {
                    ((IPhantomTile)tile).setBoundPosition(ItemPhantomConnector.getStoredPosition(stack));
                    if (tile instanceof TileEntityBase) {
                        ((TileEntityBase)tile).sendUpdate();
                    }
                    ItemPhantomConnector.clearStorage(stack);
                    player.func_146105_b((IChatComponent)new ChatComponentText(StringUtil.localize("tooltip." + ModUtil.MOD_ID_LOWER + ".phantom.connected.desc")));
                    return true;
                }
                return false;
            }
            ItemPhantomConnector.storeConnection(stack, x, y, z, world);
            player.func_146105_b((IChatComponent)new ChatComponentText(StringUtil.localize("tooltip." + ModUtil.MOD_ID_LOWER + ".phantom.stored.desc")));
        }
        return true;
    }

    public boolean checkHasConnection(ItemStack stack, EntityPlayer player, TileEntity tile) {
        if (ItemPhantomConnector.getStoredPosition(stack) != null) {
            return true;
        }
        if (tile instanceof IPhantomTile) {
            ((IPhantomTile)tile).setBoundPosition(null);
        }
        player.func_146105_b((IChatComponent)new ChatComponentText(StringUtil.localize("tooltip." + ModUtil.MOD_ID_LOWER + ".phantom.unbound.desc")));
        return false;
    }

    public static Position getStoredPosition(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            int x = tag.func_74762_e("XCoordOfTileStored");
            int y = tag.func_74762_e("YCoordOfTileStored");
            int z = tag.func_74762_e("ZCoordOfTileStored");
            if (x != 0 || y != 0 || z != 0) {
                return new Position(x, y, z);
            }
        }
        return null;
    }

    public static World getStoredWorld(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            return DimensionManager.getWorld((int)tag.func_74762_e("WorldOfTileStored"));
        }
        return null;
    }

    public static void clearStorage(ItemStack stack) {
        stack.func_77982_d(new NBTTagCompound());
    }

    public static void storeConnection(ItemStack stack, int x, int y, int z, World world) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74768_a("XCoordOfTileStored", x);
        tag.func_74768_a("YCoordOfTileStored", y);
        tag.func_74768_a("ZCoordOfTileStored", z);
        tag.func_74768_a("WorldOfTileStored", world.field_73011_w.field_76574_g);
        stack.func_77982_d(tag);
    }

    public boolean func_77651_p() {
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (ItemPhantomConnector.getStoredPosition(stack) == null) {
            ItemPhantomConnector.clearStorage(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        Position coords = ItemPhantomConnector.getStoredPosition(stack);
        if (coords != null) {
            list.add(StringUtil.localize("tooltip." + ModUtil.MOD_ID_LOWER + ".boundTo.desc") + ":");
            list.add("X: " + coords.getX());
            list.add("Y: " + coords.getY());
            list.add("Z: " + coords.getZ());
            list.add(EnumChatFormatting.ITALIC + StringUtil.localize("tooltip." + ModUtil.MOD_ID_LOWER + ".clearStorage.desc"));
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.epic;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconReg) {
        this.field_77791_bV = iconReg.func_94245_a(ModUtil.MOD_ID_LOWER + ":" + this.getBaseName());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        return this.field_77791_bV;
    }
}

