/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.inventory.GuiHandler;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityXPSolidifier;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.Util;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockXPSolidifier
extends BlockContainerBase {
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon frontIcon;

    public BlockXPSolidifier(String name) {
        super(Material.field_151576_e, name);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(2.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(field_149769_e);
    }

    public TileEntity func_149915_a(World world, int par2) {
        return new TileEntityXPSolidifier();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        if (side == 1 || side == 0) {
            return this.topIcon;
        }
        if (side == meta + 2) {
            return this.frontIcon;
        }
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 1 || side == 0) {
            return this.topIcon;
        }
        if (side == 3) {
            return this.frontIcon;
        }
        return this.field_149761_L;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (!world.field_72995_K) {
            TileEntityXPSolidifier solidifier = (TileEntityXPSolidifier)world.func_147438_o(x, y, z);
            if (solidifier != null) {
                player.openGui((Object)ActuallyAdditions.instance, GuiHandler.GuiTypes.XP_SOLIDIFIER.ordinal(), world, x, y, z);
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconReg) {
        this.field_149761_L = iconReg.func_94245_a(ModUtil.MOD_ID_LOWER + ":" + this.getBaseName());
        this.topIcon = iconReg.func_94245_a(ModUtil.MOD_ID_LOWER + ":" + this.getBaseName() + "Top");
        this.frontIcon = iconReg.func_94245_a(ModUtil.MOD_ID_LOWER + ":" + this.getBaseName() + "Front");
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.epic;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int rotation = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (rotation == 0) {
            world.func_72921_c(x, y, z, 0, 2);
        }
        if (rotation == 1) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (rotation == 2) {
            world.func_72921_c(x, y, z, 1, 2);
        }
        if (rotation == 3) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        super.func_149689_a(world, x, y, z, player, stack);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int par6) {
        this.dropInventory(world, x, y, z);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityXPSolidifier) {
            TileEntityXPSolidifier solidifier = (TileEntityXPSolidifier)tile;
            if (solidifier.amount > 0) {
                int stacks = solidifier.amount / 64;
                int rest = solidifier.amount % 64;
                for (int i = 0; i < stacks; ++i) {
                    this.spawnItem(world, x, y, z, new ItemStack(InitItems.itemSolidifiedExperience, 64));
                }
                this.spawnItem(world, x, y, z, new ItemStack(InitItems.itemSolidifiedExperience, rest));
                solidifier.amount = 0;
            }
        }
        super.func_149749_a(world, x, y, z, block, par6);
    }

    private void spawnItem(World world, int x, int y, int z, ItemStack stack) {
        float dX = Util.RANDOM.nextFloat() * 0.8f + 0.1f;
        float dY = Util.RANDOM.nextFloat() * 0.8f + 0.1f;
        float dZ = Util.RANDOM.nextFloat() * 0.8f + 0.1f;
        EntityItem entityItem = new EntityItem(world, (double)((float)x + dX), (double)((float)y + dY), (double)((float)z + dZ), stack);
        float factor = 0.05f;
        entityItem.field_70159_w = Util.RANDOM.nextGaussian() * (double)factor;
        entityItem.field_70181_x = Util.RANDOM.nextGaussian() * (double)factor + (double)0.2f;
        entityItem.field_70179_y = Util.RANDOM.nextGaussian() * (double)factor;
        world.func_72838_d((Entity)entityItem);
    }
}

