/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.player;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class InventoryHelper {
    public static boolean addItemToInventory(IInventory inventory, ItemStack itemstack) {
        int invSize = InventoryHelper.getMainInventorySize(inventory);
        return InventoryHelper.addItemToInventory(inventory, itemstack, 0, invSize);
    }

    public static int getMainInventorySize(IInventory inv) {
        if (inv instanceof InventoryPlayer) {
            return 36;
        }
        return inv.func_70302_i_();
    }

    public static boolean addItemToInventory(IInventory inventory, ItemStack itemstack, int start, int end) {
        int slot;
        ItemStack is;
        List<ItemStack> contents = InventoryHelper.storeContents(inventory);
        int maxStack = Math.min(inventory.func_70297_j_(), itemstack.func_77976_d());
        for (int i = start; i < end; ++i) {
            if (!InventoryHelper.areEqualNoSize(itemstack, inventory.func_70301_a(i))) continue;
            is = inventory.func_70301_a(i);
            if (is.field_77994_a >= maxStack) continue;
            if (is.field_77994_a + itemstack.field_77994_a <= maxStack) {
                is.field_77994_a += itemstack.field_77994_a;
                inventory.func_70296_d();
                return true;
            }
            itemstack.field_77994_a -= maxStack - is.field_77994_a;
            is.field_77994_a = maxStack;
        }
        while ((slot = InventoryHelper.getEmptySlot(inventory, start, end)) != -1 && inventory.func_94041_b(slot, itemstack)) {
            if (itemstack.field_77994_a <= maxStack) {
                inventory.func_70299_a(slot, itemstack.func_77946_l());
                inventory.func_70296_d();
                return true;
            }
            is = itemstack.func_77946_l();
            itemstack.field_77994_a -= maxStack;
            is.field_77994_a = maxStack;
            inventory.func_70299_a(slot, is);
        }
        InventoryHelper.setContents(inventory, contents);
        return false;
    }

    public static boolean areNBTsEqual(ItemStack first, ItemStack second) {
        if (first == null || second == null) {
            return first == second;
        }
        if (first.field_77990_d == null || first.field_77990_d.func_82582_d()) {
            return second.field_77990_d == null || second.field_77990_d.func_82582_d();
        }
        if (second.field_77990_d == null || second.field_77990_d.func_82582_d()) {
            return false;
        }
        return first.field_77990_d.equals((Object)second.field_77990_d);
    }

    public static boolean areEqualNoSizeNoNBT(ItemStack first, ItemStack second) {
        if (first == null || second == null) {
            return first == second;
        }
        if (first.func_77973_b() != second.func_77973_b()) {
            return false;
        }
        return !first.func_77981_g() || first.func_77960_j() == second.func_77960_j();
    }

    public static boolean areEqualNoSize(ItemStack first, ItemStack second) {
        return InventoryHelper.areEqualNoSizeNoNBT(first, second) && InventoryHelper.areNBTsEqual(first, second);
    }

    public static int getEmptySlot(IInventory inventory, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (inventory.func_70301_a(i) != null) continue;
            return i;
        }
        return -1;
    }

    public static void setContents(IInventory inventory, List<ItemStack> list) {
        if (inventory.func_70302_i_() != list.size()) {
            System.out.println("Error copying inventory contents!");
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            inventory.func_70299_a(i, ItemStack.func_77944_b((ItemStack)list.get(i)));
        }
    }

    public static List<ItemStack> storeContents(IInventory inventory) {
        ArrayList<ItemStack> copy = new ArrayList<ItemStack>(inventory.func_70302_i_());
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            copy.add(i, ItemStack.func_77944_b((ItemStack)inventory.func_70301_a(i)));
        }
        return copy;
    }

    public static int amountOfOreDictItemsInventoryHas(IInventory inventory, String s, int i) {
        int total = 0;
        if (InventoryHelper.doesInventoryHaveOreDictItem(inventory, s)) {
            for (ItemStack oreStack : OreDictionary.getOres((String)s)) {
                for (int p = 0; p < InventoryHelper.amountOfItemsInventoryHas(inventory, oreStack); ++p) {
                    ++total;
                }
            }
        }
        return total;
    }

    public static boolean doesInventoryHaveOreDictItem(IInventory inventory, String s) {
        for (ItemStack stack : OreDictionary.getOres((String)s)) {
            if (InventoryHelper.getFirstSlotWithItemStackNoNBT(inventory, stack) == -1) continue;
            return true;
        }
        return false;
    }

    public static int amountOfItemsInventoryHas(IInventory inventory, ItemStack stack) {
        int total = 0;
        if (InventoryHelper.getFirstSlotWithItemStackNoNBT(inventory, stack) != -1) {
            Integer[] integerArray = InventoryHelper.getSlotsWithItemStackNoNBT(inventory, stack);
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int q = integerArray[i];
                ItemStack inSlot = inventory.func_70301_a(q);
                for (int p = 0; p < inSlot.field_77994_a; ++p) {
                    ++total;
                }
            }
        }
        return total;
    }

    public static Integer[] getSlotsWithItemStackNoNBT(IInventory inventory, ItemStack stack) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inventory.func_70301_a(i);
            if (stackInSlot == null || stack == null || stackInSlot.func_77973_b() != stack.func_77973_b()) continue;
            if (stackInSlot.func_77960_j() == stack.func_77960_j() || stack.func_77960_j() == Short.MAX_VALUE) {
                ret.add(i);
            }
            if (stackInSlot.func_77973_b().func_77614_k() || stack.func_77973_b().func_77614_k()) continue;
            ret.add(i);
        }
        if (!ret.isEmpty()) {
            return ret.toArray(new Integer[ret.size()]);
        }
        return null;
    }

    public static int getFirstSlotWithItemStackNoNBT(IInventory inventory, ItemStack stack) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inventory.func_70301_a(i);
            if (stackInSlot == null || stack == null || stackInSlot.func_77973_b() != stack.func_77973_b()) continue;
            if (stackInSlot.func_77960_j() == stack.func_77960_j() || stack.func_77960_j() == Short.MAX_VALUE) {
                return i;
            }
            if (stackInSlot.func_77973_b().func_77614_k() || stack.func_77973_b().func_77614_k()) continue;
            return i;
        }
        return -1;
    }
}

