/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.multiblock;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import elec332.core.multiblock.AbstractAdvancedMultiBlockStructure;
import elec332.core.multiblock.BlockStructure;
import elec332.core.multiblock.IMultiBlockStructure;
import elec332.core.multiblock.IMultiBlockTile;
import elec332.core.multiblock.MultiBlockRegistry;
import elec332.core.network.AbstractMessage;
import elec332.core.server.ServerHelper;
import elec332.core.util.BlockLoc;
import elec332.core.util.NBTHelper;
import elec332.core.world.WorldHelper;
import elec332.core.world.location.BlockData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public final class MultiBlockStructureRegistry
implements IMessageHandler<SyncMultiBlockPacket, IMessage> {
    private final MultiBlockRegistry multiBlockRegistry;
    private Map<String, IMultiBlockStructure> multiBlockStructures = Maps.newHashMap();

    protected MultiBlockStructureRegistry(MultiBlockRegistry multiBlockRegistry) {
        this.multiBlockRegistry = multiBlockRegistry;
        multiBlockRegistry.networkHandler.getNetworkWrapper().registerMessage((IMessageHandler)this, SyncMultiBlockPacket.class, 0, Side.CLIENT);
    }

    protected void registerMultiBlockStructure(IMultiBlockStructure multiBlock, String name) {
        this.multiBlockStructures.put(name, multiBlock);
    }

    protected String getIdentifier(IMultiBlockStructure structure) {
        for (Map.Entry<String, IMultiBlockStructure> entry : this.multiBlockStructures.entrySet()) {
            if (!entry.getValue().equals(structure)) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("ERROR: Structure: " + structure.getClass().getName() + " is not registered!");
    }

    public boolean attemptCreate(EntityPlayer player, World world, int x, int y, int z, ForgeDirection side) {
        if (world.field_72995_K) {
            return false;
        }
        BlockData blockData = this.atLocation((IBlockAccess)world, x, y, z);
        if (blockData == null) {
            return false;
        }
        for (IMultiBlockStructure multiBlock : this.multiBlockStructures.values()) {
            if (!multiBlock.getTriggerBlock().equals(blockData) || multiBlock instanceof AbstractAdvancedMultiBlockStructure && !((AbstractAdvancedMultiBlockStructure)multiBlock).canCreate((EntityPlayerMP)player) || !this.tryCreateStructure(multiBlock, world, x, y, z, side, false)) continue;
            return true;
        }
        return false;
    }

    protected boolean attemptReCreate(String s, TileEntity tile, ForgeDirection facing) {
        return this.tryCreateStructure(this.multiBlockStructures.get(s), tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, facing, true);
    }

    private boolean tryCreateStructure(IMultiBlockStructure multiBlock, World world, int x, int y, int z, ForgeDirection side, boolean recreate) {
        if (side == ForgeDirection.UNKNOWN || side == ForgeDirection.UP || side == ForgeDirection.DOWN) {
            return false;
        }
        BlockData leftBottomCorner = null;
        int newX = x;
        int newY = y;
        int newZ = z;
        block0: for (int i = 0; i < multiBlock.getStructure().getHn() + 1; ++i) {
            BlockData temp1;
            if (side == ForgeDirection.NORTH || side == ForgeDirection.EAST) {
                temp1 = this.atLocation((IBlockAccess)world, newX + 1, y, z);
                if (temp1 != null && multiBlock.getStructure().getBlockTypes().contains(temp1)) {
                    ++newX;
                    continue;
                }
            } else if ((side == ForgeDirection.SOUTH || side == ForgeDirection.WEST) && (temp1 = this.atLocation((IBlockAccess)world, newX - 1, y, z)) != null && multiBlock.getStructure().getBlockTypes().contains(temp1)) {
                --newX;
                continue;
            }
            for (int j = 0; j < multiBlock.getStructure().getHn() + 1; ++j) {
                if ((temp1 = this.atLocation((IBlockAccess)world, newX, --newY, z)) != null && multiBlock.getStructure().getBlockTypes().contains(temp1)) continue;
                ++newY;
                for (int k = 0; k < multiBlock.getStructure().getHn() + 1; ++k) {
                    if (side == ForgeDirection.NORTH || side == ForgeDirection.WEST) {
                        temp1 = this.atLocation((IBlockAccess)world, newX, newY, newZ - 1);
                        if (temp1 != null && multiBlock.getStructure().getBlockTypes().contains(temp1)) {
                            --newZ;
                            continue;
                        }
                    } else if ((side == ForgeDirection.EAST || side == ForgeDirection.SOUTH) && (temp1 = this.atLocation((IBlockAccess)world, newX, newY, newZ + 1)) != null && multiBlock.getStructure().getBlockTypes().contains(temp1)) {
                        ++newZ;
                        continue;
                    }
                    leftBottomCorner = this.atLocation((IBlockAccess)world, newX, newY, newZ);
                    break block0;
                }
            }
        }
        if (leftBottomCorner != null && this.areBlocksAtRightPlace(multiBlock.getStructure(), world, newX, newY, newZ, side)) {
            if (multiBlock instanceof AbstractAdvancedMultiBlockStructure && !((AbstractAdvancedMultiBlockStructure)multiBlock).areSecondaryConditionsMet(world, new BlockLoc(newX, newY, newZ), side)) {
                return false;
            }
            if (multiBlock.replaceUponCreated() != null) {
                BlockStructure main = multiBlock.getStructure();
                this.replaceAll(main, world, newX, newY, newZ, side, main.newBlockStructureWithSameDimensions(multiBlock.replaceUponCreated()));
            }
            ((MultiBlockRegistry.MultiBlockWorldRegistry)this.multiBlockRegistry.get(world)).createNewMultiBlock(multiBlock, new BlockLoc(newX, newY, newZ), this.getAllMultiBlockLocations(multiBlock.getStructure(), newX, newY, newZ, side), world, side);
            if (!recreate && !world.field_72995_K) {
                for (EntityPlayerMP player : ServerHelper.instance.getAllPlayersWatchingBlock(world, newX, newZ)) {
                    this.multiBlockRegistry.networkHandler.getNetworkWrapper().sendTo((IMessage)new SyncMultiBlockPacket(multiBlock, x, y, z, side, this), player);
                }
            }
            return true;
        }
        return false;
    }

    private List<BlockLoc> getAllMultiBlockLocations(BlockStructure multiBlock, final int x, final int y, final int z, final ForgeDirection side) {
        final ArrayList ret = Lists.newArrayList();
        multiBlock.startLoop(new BlockStructure.IPositionCall(){

            @Override
            public void forPos(int length, int width, int height) {
                ret.add(MultiBlockStructureRegistry.getTranslated(x, y, z, side, length, width, height));
            }
        });
        return ret;
    }

    private void replaceAll(BlockStructure multiBlock, final World world, final int x, final int y, final int z, final ForgeDirection side, final BlockStructure toReplace) {
        multiBlock.startLoop(new BlockStructure.IPositionCall(){

            @Override
            public void forPos(int length, int width, int height) {
                BlockLoc loc = MultiBlockStructureRegistry.getTranslated(x, y, z, side, length, width, height);
                BlockData data = toReplace.getStructure()[length][width][height];
                world.func_147468_f(loc.xCoord, loc.yCoord, loc.zCoord);
                world.func_147465_d(loc.xCoord, loc.yCoord, loc.zCoord, data.block, data.meta, 3);
            }
        });
    }

    private boolean areBlocksAtRightPlace(final BlockStructure multiBlock, final World world, final int x, final int y, final int z, final ForgeDirection side) {
        try {
            multiBlock.startLoop(new BlockStructure.IPositionCall(){

                @Override
                public void forPos(int length, int width, int height) {
                    BlockLoc translated = MultiBlockStructureRegistry.getTranslated(x, y, z, side, length, width, height);
                    if (!multiBlock.getStructure()[length][width][height].equals(MultiBlockStructureRegistry.this.atLocation(translated, (IBlockAccess)world)) || MultiBlockStructureRegistry.this.hasMultiBlock(translated, world)) {
                        throw new RuntimeException("INVALID");
                    }
                }
            });
        }
        catch (RuntimeException e) {
            System.out.println("INVALID");
            if (e.getMessage() != null && e.getMessage().equals("INVALID")) {
                return false;
            }
            throw new RuntimeException(e);
        }
        System.out.println("VALID STUFF HERE, YAYZZZ :D");
        return true;
    }

    private boolean hasMultiBlock(BlockLoc loc, World world) {
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, loc);
        return tile instanceof IMultiBlockTile && ((IMultiBlockTile)tile).getMultiBlock() != null;
    }

    protected static BlockLoc getTranslated(int x, int y, int z, ForgeDirection side, int length, int width, int height) {
        int newZ;
        int newX;
        if (side == ForgeDirection.NORTH) {
            newX = x - length;
            newZ = z + width;
        } else if (side == ForgeDirection.EAST) {
            newX = x - width;
            newZ = z - length;
        } else if (side == ForgeDirection.SOUTH) {
            newX = x + length;
            newZ = z - width;
        } else if (side == ForgeDirection.WEST) {
            newX = x + width;
            newZ = z + length;
        } else {
            throw new IllegalArgumentException("Cannot process side: " + side);
        }
        int newY = y + height;
        return new BlockLoc(newX, newY, newZ);
    }

    private BlockData atLocation(BlockLoc loc, IBlockAccess world) {
        return this.atLocation(world, loc.xCoord, loc.yCoord, loc.zCoord);
    }

    private BlockData atLocation(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block == null || block == Blocks.field_150350_a) {
            return new BlockData(null);
        }
        return new BlockData(block, meta);
    }

    public IMessage onMessage(SyncMultiBlockPacket message, MessageContext ctx) {
        NBTTagCompound tag = message.networkPackageObject;
        this.tryCreateStructure(this.multiBlockStructures.get(tag.func_74779_i("mbs")), (World)Minecraft.func_71410_x().field_71441_e, tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"), ForgeDirection.valueOf((String)tag.func_74779_i("side")), false);
        return null;
    }

    public static final class SyncMultiBlockPacket
    extends AbstractMessage {
        public SyncMultiBlockPacket() {
            super(null);
        }

        private SyncMultiBlockPacket(IMultiBlockStructure multiBlock, int x, int y, int z, ForgeDirection side, MultiBlockStructureRegistry structureRegistry) {
            super(new NBTHelper().addToTag(x, "x").addToTag(y, "y").addToTag(z, "z").addToTag(side.toString(), "side").addToTag(structureRegistry.getIdentifier(multiBlock), "mbs").toNBT());
        }
    }
}

