/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.multiblock;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import elec332.core.world.location.BlockData;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;

public final class BlockStructure {
    private BlockData[][][] structure;
    private List<ItemStack> allBlocks;
    private List<BlockData> blockTypes;
    private final int hn;
    private final int length;
    private final int width;
    private final int height;

    public BlockStructure(int length, int width, int height, IStructureFiller data) {
        this.hn = Math.max(length, Math.max(width, height));
        this.length = length;
        this.width = width;
        this.height = height;
        this.structure = new BlockData[length][width][height];
        this.allBlocks = Lists.newArrayList();
        this.blockTypes = Lists.newArrayList();
        HashMap allBlocks = Maps.newHashMap();
        for (int l = 0; l < length; ++l) {
            for (int w = 0; w < width; ++w) {
                for (int h = 0; h < height; ++h) {
                    BlockData blockData = data.getBlockAtPos(l, w, h);
                    if (blockData != null && blockData.block != null) {
                        this.structure[l][w][h] = blockData;
                        if (allBlocks.get(blockData) == null) {
                            allBlocks.put(blockData, 0);
                        }
                        int i = (Integer)allBlocks.get(blockData);
                        allBlocks.remove(blockData);
                        allBlocks.put(blockData, ++i);
                        continue;
                    }
                    this.structure[l][w][h] = blockData != null ? blockData : new BlockData(null);
                }
            }
        }
        for (BlockData blockData : allBlocks.keySet()) {
            int i = (Integer)allBlocks.get(blockData);
            ItemStack stack = new ItemStack(blockData.block, i, blockData.meta);
            this.allBlocks.add(stack);
            this.blockTypes.add(blockData);
        }
    }

    public BlockStructure newBlockStructureWithSameDimensions(IStructureFiller structureFiller) {
        return new BlockStructure(this.length, this.width, this.height, structureFiller);
    }

    protected void startLoop(IPositionCall callable) {
        for (int l = 0; l < this.length; ++l) {
            for (int w = 0; w < this.width; ++w) {
                for (int h = 0; h < this.height; ++h) {
                    callable.forPos(l, w, h);
                }
            }
        }
    }

    public BlockData[][][] getStructure() {
        return this.structure;
    }

    public List<ItemStack> getAllBlocks() {
        return this.allBlocks;
    }

    public List<BlockData> getBlockTypes() {
        return this.blockTypes;
    }

    protected int getHn() {
        return this.hn;
    }

    protected static interface IPositionCall {
        public void forPos(int var1, int var2, int var3);
    }

    public static interface IStructureFiller {
        public BlockData getBlockAtPos(int var1, int var2, int var3);
    }
}

