/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.inventory.widget;

import elec332.core.inventory.widget.WidgetButton;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;

public class WidgetButtonArrow
extends WidgetButton {
    private final Direction direction;

    public WidgetButtonArrow(int x, int y, Direction direction) {
        super(x, y, direction.u, direction.v, direction.width, direction.height);
        this.direction = direction;
    }

    @Override
    public void draw(Gui gui, int guiX, int guiY, int mouseX, int mouseY) {
        this.bindTexture(new ResourceLocation("eleccore", "buttons.png"));
        int u = this.u;
        int v = this.v;
        if (!this.isActive()) {
            u += this.direction.tw * 2;
            v += this.direction.th * 2;
        } else if (this.isMouseOver(mouseX, mouseY)) {
            u += this.direction.tw;
            v += this.direction.th;
        }
        gui.func_73729_b(guiX + this.x, guiY + this.y, u, v, this.width, this.height);
    }

    @Override
    public WidgetButtonArrow addButtonEvent(WidgetButton.IButtonEvent event) {
        super.addButtonEvent(event);
        return this;
    }

    public static enum Direction {
        UP(36, 0, 19, 12, 0, 12),
        DOWN(55, 0, 19, 12, 0, 12),
        LEFT(0, 19, 12, 19, 12, 0),
        RIGHT(0, 0, 12, 19, 12, 0);

        protected final int u;
        protected final int v;
        protected final int width;
        protected final int height;
        protected final int tw;
        protected final int th;

        private Direction(int u, int v, int width, int height, int tw, int th) {
            this.u = u;
            this.v = v;
            this.width = width;
            this.height = height;
            this.tw = tw;
            this.th = th;
        }
    }
}

