/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.baseclasses.tileentity;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import elec332.core.api.wrench.IRightClickCancel;
import elec332.core.api.wrench.IWrenchable;
import elec332.core.baseclasses.tileentity.IActivatableMachine;
import elec332.core.baseclasses.tileentity.TileBase;
import elec332.core.helper.RegisterHelper;
import elec332.core.util.BlockSide;
import elec332.core.util.DirectionHelper;
import elec332.core.util.IComparatorOverride;
import elec332.core.util.IRedstoneHandler;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockTileBase
extends Block
implements IWrenchable,
ITileEntityProvider {
    public IIcon[][] icons = new IIcon[2][6];
    private Class<? extends TileEntity> tileClass;
    private String blockName;
    private String modID;

    public BlockTileBase(Material mat, Class<? extends TileEntity> tileClass, String blockName, String modID) {
        super(mat);
        this.func_149752_b(4.5f);
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149769_e);
        this.func_149663_c(modID + "." + blockName);
        this.tileClass = tileClass;
        this.blockName = blockName;
        this.modID = modID;
    }

    public BlockTileBase registerTile() {
        GameRegistry.registerTileEntity(this.tileClass, (String)this.blockName);
        return this;
    }

    public BlockTileBase register() {
        RegisterHelper.registerBlock(this, this.blockName);
        return this;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IRightClickCancel) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileBase) {
            return ((TileBase)tile).onBlockActivated(player, side, hitX, hitY, hitZ);
        }
        return super.func_149727_a(world, x, y, z, player, side, hitX, hitY, hitZ);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        try {
            return this.tileClass.newInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public ItemStack ItemDropped(World world, int x, int y, int z) {
        return new ItemStack((Block)this);
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    @Override
    public void onWrenched(World world, int i, int i1, int i2, ForgeDirection forgeDirection) {
        TileEntity tile = world.func_147438_o(i, i1, i2);
        if (tile instanceof TileBase) {
            ((TileBase)tile).onWrenched(forgeDirection);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack stack) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileBase) {
            ((TileBase)tile).onBlockPlacedBy(entityLiving, stack);
        }
        super.func_149689_a(world, x, y, z, entityLiving, stack);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileBase) {
            ((TileBase)tile).onNeighborBlockChange(block);
        }
        super.func_149695_a(world, x, y, z, block);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileBase) {
            ((TileBase)tile).onBlockAdded();
        }
        super.func_149726_b(world, x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileBase) {
            ((TileBase)tile).onBlockRemoved();
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileBase) {
            return ((TileBase)tile).getLightValue();
        }
        return super.getLightValue(world, x, y, z);
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileBase) {
            return ((TileBase)tile).getLightOpacity();
        }
        return super.getLightOpacity(world, x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileBase) {
            return ((TileBase)tile).getDrops(fortune);
        }
        return super.getDrops(world, x, y, z, metadata, fortune);
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IRedstoneHandler) {
            return ((IRedstoneHandler)tile).isProvidingWeakPower(side);
        }
        return super.func_149709_b(world, x, y, z, side);
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int direction) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IRedstoneHandler) {
            return ((IRedstoneHandler)tile).canConnectRedstone(direction);
        }
        return super.canConnectRedstone(world, x, y, z, direction);
    }

    public boolean func_149740_M() {
        return IComparatorOverride.class.isAssignableFrom(this.tileClass);
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IComparatorOverride) {
            return ((IComparatorOverride)tile).getComparatorInputOverride(side);
        }
        return super.func_149736_g(world, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.icons[0][DirectionHelper.ROTATION_MATRIX_YAW[2][side]];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        TileEntity tile = world.func_147438_o(x, y, z);
        int i = tile instanceof IActivatableMachine && ((IActivatableMachine)tile).isActive() ? 1 : 0;
        return this.icons[i][DirectionHelper.ROTATION_MATRIX_YAW[meta][side]];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons[0][0] = iconRegister.func_94245_a(this.getBottomIconName(true));
        this.icons[0][1] = iconRegister.func_94245_a(this.getTopIconName(true));
        this.icons[0][2] = iconRegister.func_94245_a(this.getFrontTexture(true));
        this.icons[0][3] = iconRegister.func_94245_a(this.getSideTexture(true, BlockSide.BACK));
        this.icons[0][4] = iconRegister.func_94245_a(this.getSideTexture(true, BlockSide.RIGHT));
        this.icons[0][5] = iconRegister.func_94245_a(this.getSideTexture(true, BlockSide.LEFT));
        this.icons[1][0] = iconRegister.func_94245_a(this.getBottomIconName(false));
        this.icons[1][1] = iconRegister.func_94245_a(this.getTopIconName(false));
        this.icons[1][2] = iconRegister.func_94245_a(this.getFrontTexture(false));
        this.icons[1][3] = iconRegister.func_94245_a(this.getSideTexture(false, BlockSide.BACK));
        this.icons[1][4] = iconRegister.func_94245_a(this.getSideTexture(false, BlockSide.RIGHT));
        this.icons[1][5] = iconRegister.func_94245_a(this.getSideTexture(false, BlockSide.LEFT));
    }

    @SideOnly(value=Side.CLIENT)
    public String getSideTexture(boolean active, BlockSide side) {
        return this.func_149641_N() + "_side";
    }

    @SideOnly(value=Side.CLIENT)
    public String getFrontTexture(boolean active) {
        return this.func_149641_N() + "_front";
    }

    @SideOnly(value=Side.CLIENT)
    public String getTopIconName(boolean active) {
        return this.func_149641_N() + "_top";
    }

    @SideOnly(value=Side.CLIENT)
    public String getBottomIconName(boolean active) {
        return this.func_149641_N() + "_bottom";
    }

    @SideOnly(value=Side.CLIENT)
    protected String func_149641_N() {
        if (this.field_149768_d != null) {
            return this.field_149768_d;
        }
        return this.modID + ":" + this.blockName;
    }
}

