/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.mfr.machines;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.block.IBlock;
import minetweaker.api.block.IBlockPattern;
import minetweaker.api.item.WeightedItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.mc1710.block.MCBlockDefinition;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryFruit;
import powercrystals.minefactoryreloaded.api.ReplacementBlock;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mfr.FruitPicker")
@ModOnly(value={"MineFactoryReloaded"})
public class FruitPicker {
    @ZenMethod
    public static void addFruit(IBlockPattern block, IBlock replacement, WeightedItemStack drop) {
        FruitPicker.addFruit(block, replacement, new WeightedItemStack[]{drop});
    }

    @ZenMethod
    public static void addFruit(IBlockPattern block, IBlock replacement, WeightedItemStack[] drops) {
        TweakerFruit fruit = new TweakerFruit(block, replacement, drops);
        MineTweakerAPI.apply(new AddFruitAction(fruit));
    }

    @ZenMethod
    public static void removeFruit(IBlockPattern block) {
        MineTweakerAPI.apply(new RemoveFruitAction(block));
    }

    @ZenMethod
    public static void addLog(IBlockPattern block) {
        MineTweakerAPI.apply(new AddLogAction(block));
    }

    @ZenMethod
    public static void removeLog(IBlockPattern block) {
        MineTweakerAPI.apply(new RemoveLogAction(block));
    }

    private static class RemoveLogAction
    implements IUndoableAction {
        private final IBlockPattern block;
        private final List<Block> removedLogs = new ArrayList<Block>();

        public RemoveLogAction(IBlockPattern block) {
            this.block = block;
            for (IBlock partial : block.getBlocks()) {
                Block mcBlock = MineTweakerMC.getBlock(partial);
                if (!MFRRegistry.getFruitLogBlocks().contains(mcBlock) || this.removedLogs.contains(mcBlock)) continue;
                this.removedLogs.add(mcBlock);
            }
        }

        @Override
        public void apply() {
            for (Block log : this.removedLogs) {
                MFRRegistry.getFruitLogBlocks().remove(log);
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            for (Block log : this.removedLogs) {
                MFRRegistry.registerFruitLogBlock((Block)log);
            }
        }

        @Override
        public String describe() {
            return "Removing MFR Fruit Picker log block " + this.block.getDisplayName();
        }

        @Override
        public String describeUndo() {
            return "Restoring MFR Fruit Picker log block " + this.block.getDisplayName();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddLogAction
    implements IUndoableAction {
        private final IBlockPattern block;
        private final List<Block> addedLogs = new ArrayList<Block>();

        public AddLogAction(IBlockPattern block) {
            this.block = block;
            for (IBlock partial : block.getBlocks()) {
                Block mcBlock = MineTweakerMC.getBlock(partial);
                if (MFRRegistry.getFruitLogBlocks().contains(mcBlock) || this.addedLogs.contains(mcBlock)) continue;
                this.addedLogs.add(mcBlock);
            }
        }

        @Override
        public void apply() {
            for (Block log : this.addedLogs) {
                MFRRegistry.registerFruitLogBlock((Block)log);
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            for (Block log : this.addedLogs) {
                MFRRegistry.getFruitLogBlocks().remove(log);
            }
        }

        @Override
        public String describe() {
            return "Adding MFR Fruit Picker log block " + this.block.getDisplayName();
        }

        @Override
        public String describeUndo() {
            return "Removing MFR Fruit Picker log block " + this.block.getDisplayName();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class RemoveFruitAction
    implements IUndoableAction {
        private final IBlockPattern block;
        private final Map<Block, IFactoryFruit> removed;

        public RemoveFruitAction(IBlockPattern block) {
            this.block = block;
            Map fruits = MFRRegistry.getFruits();
            this.removed = new HashMap<Block, IFactoryFruit>();
            for (IBlock partial : block.getBlocks()) {
                Block mcBlock = MineTweakerMC.getBlock(partial);
                if (!fruits.containsKey(mcBlock)) continue;
                this.removed.put(mcBlock, (IFactoryFruit)fruits.get(mcBlock));
            }
        }

        @Override
        public void apply() {
            Map fruits = MFRRegistry.getFruits();
            for (Block key : this.removed.keySet()) {
                fruits.remove(key);
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            Map fruits = MFRRegistry.getFruits();
            for (Map.Entry<Block, IFactoryFruit> restore : this.removed.entrySet()) {
                fruits.put(restore.getKey(), restore.getValue());
            }
        }

        @Override
        public String describe() {
            return "Removing fruit picker fruit block " + this.block.getDisplayName();
        }

        @Override
        public String describeUndo() {
            return "Restoring fruit picker fruit block " + this.block.getDisplayName();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddFruitAction
    implements IUndoableAction {
        private final TweakerFruit fruit;

        public AddFruitAction(TweakerFruit fruit) {
            this.fruit = fruit;
        }

        @Override
        public void apply() {
            Map fruits = MFRRegistry.getFruits();
            for (IBlock partial : this.fruit.block.getBlocks()) {
                Block block = ((MCBlockDefinition)partial.getDefinition()).getInternalBlock();
                if (fruits != null && fruits.containsKey(block)) {
                    IFactoryFruit existingFruit = (IFactoryFruit)fruits.get(block);
                    if (existingFruit instanceof TweakerFruitPartial) {
                        TweakerFruitPartial existingFruitPartial = (TweakerFruitPartial)existingFruit;
                        if (existingFruitPartial.fruits.contains(this.fruit)) continue;
                        existingFruitPartial.fruits.add(this.fruit);
                        continue;
                    }
                    MineTweakerAPI.logError("A non-MineTweaker fruit already exists for this ID");
                    continue;
                }
                TweakerFruitPartial factoryFruit = new TweakerFruitPartial(block);
                MFRRegistry.registerFruit((IFactoryFruit)factoryFruit);
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            Map fruits = MFRRegistry.getFruits();
            for (IBlock partial : this.fruit.block.getBlocks()) {
                Block block = MineTweakerMC.getBlock(partial);
                IFactoryFruit factoryFruit = (IFactoryFruit)fruits.get(block);
                if (factoryFruit == null || !(factoryFruit instanceof TweakerFruitPartial)) continue;
                ((TweakerFruitPartial)factoryFruit).fruits.remove(this.fruit);
            }
        }

        @Override
        public String describe() {
            return "Adding Fruit Picker fruit block " + this.fruit.block.getDisplayName();
        }

        @Override
        public String describeUndo() {
            return "Removing Fruit Picker fruit block " + this.fruit.block.getDisplayName();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class TweakerFruitPartial
    implements IFactoryFruit {
        private final Block block;
        private final List<TweakerFruit> fruits;

        public TweakerFruitPartial(Block block) {
            this.block = block;
            this.fruits = new ArrayList<TweakerFruit>();
        }

        public Block getPlant() {
            return this.block;
        }

        public boolean canBePicked(World world, int x, int y, int z) {
            for (TweakerFruit fruit : this.fruits) {
                if (!fruit.block.matches(MineTweakerMC.getBlock((IBlockAccess)world, x, y, z))) continue;
                return true;
            }
            return false;
        }

        public boolean breakBlock() {
            return false;
        }

        public ReplacementBlock getReplacementBlock(World world, int x, int y, int z) {
            IBlock iBlock = MineTweakerMC.getBlock((IBlockAccess)world, x, y, z);
            for (TweakerFruit fruit : this.fruits) {
                if (!fruit.block.matches(iBlock)) continue;
                return new ReplacementBlock(MineTweakerMC.getBlock(fruit.replacement)).setMeta(iBlock.getMeta());
            }
            return null;
        }

        public void prePick(World world, int x, int y, int z) {
        }

        public List<ItemStack> getDrops(World world, Random rand, int x, int y, int z) {
            IBlock iBlock = MineTweakerMC.getBlock((IBlockAccess)world, x, y, z);
            for (TweakerFruit fruit : this.fruits) {
                if (!fruit.block.matches(iBlock)) continue;
                return Arrays.asList(MineTweakerMC.getItemStacks(WeightedItemStack.pickRandomDrops(rand, fruit.possibleDrops)));
            }
            return Collections.EMPTY_LIST;
        }

        public void postPick(World world, int x, int y, int z) {
        }
    }

    private static class TweakerFruit {
        private final IBlockPattern block;
        private final IBlock replacement;
        private final WeightedItemStack[] possibleDrops;

        public TweakerFruit(IBlockPattern block, IBlock replacement, WeightedItemStack[] possibleDrops) {
            this.block = block;
            this.replacement = replacement;
            this.possibleDrops = possibleDrops;
        }
    }
}

