/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.utility;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import org.dave.CompactMachines.reference.Reference;
import org.dave.CompactMachines.utility.LogHelper;

public class WorldUtils {
    public static BiomeGenBase getBiomeByName(String name) {
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (biome == null || biome.field_76791_y == null || !biome.field_76791_y.toLowerCase().equals(name.toLowerCase())) continue;
            return biome;
        }
        LogHelper.error("Invalid biome specified in config. Using sky biome instead.");
        return BiomeGenBase.field_76779_k;
    }

    public static int updateNeighborAEGrids(World world, int x, int y, int z) {
        if (!Reference.AE_AVAILABLE) {
            return 0;
        }
        int countUpdated = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int offX = x + dir.offsetX;
            int offY = y + dir.offsetY;
            int offZ = z + dir.offsetZ;
            if (!(world.func_147438_o(offX, offY, offZ) instanceof IGridHost)) continue;
            IGridHost host = (IGridHost)world.func_147438_o(offX, offY, offZ);
            IGridNode node = host.getGridNode(dir.getOpposite());
            if (node == null) {
                node = host.getGridNode(ForgeDirection.UNKNOWN);
            }
            if (node == null) continue;
            node.updateState();
            ++countUpdated;
        }
        return countUpdated;
    }

    public static ArrayList<ItemStack> getItemStackFromBlock(World world, int i, int j, int k) {
        Block block = world.func_147439_a(i, j, k);
        if (block == null) {
            return null;
        }
        if (block.isAir((IBlockAccess)world, i, j, k)) {
            return null;
        }
        int meta = world.func_72805_g(i, j, k);
        return block.getDrops(world, i, j, k, meta, 0);
    }
}

