/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.utility;

import java.util.Comparator;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.dave.CompactMachines.utility.NBTHelper;

public class ItemHelper {
    public static Comparator<ItemStack> comparator = new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack itemStack1, ItemStack itemStack2) {
            if (itemStack1 != null && itemStack2 != null) {
                if (Item.func_150891_b((Item)itemStack1.func_77973_b()) - Item.func_150891_b((Item)itemStack2.func_77973_b()) == 0) {
                    if (itemStack1.func_77973_b() == itemStack2.func_77973_b()) {
                        if (itemStack1.func_77960_j() == itemStack2.func_77960_j()) {
                            if (itemStack1.func_77942_o() && itemStack2.func_77942_o()) {
                                if (ItemStack.func_77970_a((ItemStack)itemStack1, (ItemStack)itemStack2)) {
                                    return itemStack1.field_77994_a - itemStack2.field_77994_a;
                                }
                                return itemStack1.func_77978_p().hashCode() - itemStack2.func_77978_p().hashCode();
                            }
                            if (!itemStack1.func_77942_o() && itemStack2.func_77942_o()) {
                                return -1;
                            }
                            if (itemStack1.func_77942_o() && !itemStack2.func_77942_o()) {
                                return 1;
                            }
                            return itemStack1.field_77994_a - itemStack2.field_77994_a;
                        }
                        return itemStack1.func_77960_j() - itemStack2.func_77960_j();
                    }
                    return itemStack1.func_77973_b().func_77667_c(itemStack1).compareToIgnoreCase(itemStack2.func_77973_b().func_77667_c(itemStack2));
                }
                return Item.func_150891_b((Item)itemStack1.func_77973_b()) - Item.func_150891_b((Item)itemStack2.func_77973_b());
            }
            if (itemStack1 != null) {
                return -1;
            }
            if (itemStack2 != null) {
                return 1;
            }
            return 0;
        }
    };

    public static ItemStack cloneItemStack(ItemStack itemStack, int stackSize) {
        ItemStack clonedItemStack = itemStack.func_77946_l();
        clonedItemStack.field_77994_a = stackSize;
        return clonedItemStack;
    }

    public static int findBestSlotForSidedInventory(ISidedInventory inv, ItemStack stack, ForgeDirection side) {
        int result = -1;
        result = ItemHelper.findBestMatchingSlotForSidedInventory(inv, stack, side);
        if (result != -1) {
            return result;
        }
        result = ItemHelper.findFirstEmptySlotInSidedInventory(inv, stack, side);
        if (result != -1) {
            return result;
        }
        return result;
    }

    public static int findBestSlotForInventory(IInventory inv, ItemStack stack) {
        int result = -1;
        result = ItemHelper.findBestMatchingSlotForInventory(inv, stack);
        if (result != -1) {
            return result;
        }
        result = ItemHelper.findFirstEmptySlot(inv, stack);
        if (result != -1) {
            return result;
        }
        return result;
    }

    private static int findBestMatchingSlotForSidedInventory(ISidedInventory inv, ItemStack stack, ForgeDirection side) {
        int[] accessibleSlotsFromSide;
        for (int slot : accessibleSlotsFromSide = inv.func_94128_d(side.ordinal())) {
            ItemStack target = inv.func_70301_a(slot);
            if (target == null || target.func_77973_b() != stack.func_77973_b() || !target.func_77985_e() || !inv.func_94041_b(slot, stack) || target.field_77994_a >= target.func_77976_d() || target.field_77994_a >= inv.func_70297_j_() || !inv.func_102007_a(slot, stack, side.ordinal()) || target.func_77981_g() && target.func_77960_j() != stack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)target, (ItemStack)stack)) continue;
            return slot;
        }
        return -1;
    }

    private static int findFirstEmptySlotInSidedInventory(ISidedInventory inv, ItemStack stack, ForgeDirection side) {
        int[] accessibleSlotsFromSide;
        for (int slot : accessibleSlotsFromSide = inv.func_94128_d(side.ordinal())) {
            ItemStack target = inv.func_70301_a(slot);
            if (target != null || !inv.func_94041_b(slot, stack) || !inv.func_102007_a(slot, stack, side.ordinal())) continue;
            return slot;
        }
        return -1;
    }

    private static int findBestMatchingSlotForInventory(IInventory inv, ItemStack stack) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack target = inv.func_70301_a(i);
            if (target == null || target.func_77973_b() != stack.func_77973_b() || !target.func_77985_e() || !inv.func_94041_b(i, stack) || target.field_77994_a >= target.func_77976_d() || target.field_77994_a >= inv.func_70297_j_() || target.func_77981_g() && target.func_77960_j() != stack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)target, (ItemStack)stack)) continue;
            return i;
        }
        return -1;
    }

    private static int findFirstEmptySlot(IInventory inv, ItemStack stack) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack target = inv.func_70301_a(i);
            if (target != null || !inv.func_94041_b(i, stack)) continue;
            return i;
        }
        return -1;
    }

    public static boolean equals(ItemStack first, ItemStack second) {
        return comparator.compare(first, second) == 0;
    }

    public static boolean equalsIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2) {
        if (itemStack1 != null && itemStack2 != null && Item.func_150891_b((Item)itemStack1.func_77973_b()) - Item.func_150891_b((Item)itemStack2.func_77973_b()) == 0 && itemStack1.func_77973_b() == itemStack2.func_77973_b() && itemStack1.func_77960_j() == itemStack2.func_77960_j()) {
            if (itemStack1.func_77942_o() && itemStack2.func_77942_o()) {
                if (ItemStack.func_77970_a((ItemStack)itemStack1, (ItemStack)itemStack2)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static int compare(ItemStack itemStack1, ItemStack itemStack2) {
        return comparator.compare(itemStack1, itemStack2);
    }

    public static String toString(ItemStack itemStack) {
        if (itemStack != null) {
            return String.format("%sxitemStack[%s@%s]", itemStack.field_77994_a, itemStack.func_77977_a(), itemStack.func_77960_j());
        }
        return "null";
    }

    public static boolean hasOwner(ItemStack itemStack) {
        return NBTHelper.hasTag(itemStack, "OwnerUUIDmost") && NBTHelper.hasTag(itemStack, "OwnerUUIDleast") || NBTHelper.hasTag(itemStack, "owner");
    }

    public static String getOwnerName(ItemStack itemStack) {
        if (NBTHelper.hasTag(itemStack, "owner")) {
            return NBTHelper.getString(itemStack, "owner");
        }
        return StatCollector.func_74838_a((String)"tooltip.cm:none");
    }

    public static UUID getOwnerUUID(ItemStack itemStack) {
        if (NBTHelper.hasTag(itemStack, "OwnerUUIDmost") && NBTHelper.hasTag(itemStack, "OwnerUUIDleast")) {
            return new UUID(NBTHelper.getLong(itemStack, "OwnerUUIDmost"), NBTHelper.getLong(itemStack, "OwnerUUIDleast"));
        }
        return null;
    }

    public static void setOwner(ItemStack itemStack, EntityPlayer entityPlayer) {
        NBTHelper.setString(itemStack, "owner", entityPlayer.getDisplayName());
        NBTHelper.setLong(itemStack, "OwnerUUIDmost", entityPlayer.func_110124_au().getMostSignificantBits());
        NBTHelper.setLong(itemStack, "OwnerUUIDleast", entityPlayer.func_110124_au().getLeastSignificantBits());
    }

    public static void readItemStacksFromTag(ItemStack[] items, NBTTagList tagList) {
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            short b = tag.func_74765_d("Slot");
            items[b] = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (!tag.func_74764_b("Quantity")) continue;
            items[b].field_77994_a = ((NBTBase.NBTPrimitive)tag.func_74781_a("Quantity")).func_150287_d();
        }
    }

    public static NBTTagList writeItemStacksToTag(ItemStack[] items) {
        return ItemHelper.writeItemStacksToTag(items, 64);
    }

    public static NBTTagList writeItemStacksToTag(ItemStack[] items, int maxQuantity) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74777_a("Slot", (short)i);
            items[i].func_77955_b(tag);
            if (maxQuantity > Short.MAX_VALUE) {
                tag.func_74768_a("Quantity", items[i].field_77994_a);
            } else if (maxQuantity > 127) {
                tag.func_74777_a("Quantity", (short)items[i].field_77994_a);
            }
            tagList.func_74742_a((NBTBase)tag);
        }
        return tagList;
    }

    public static ItemStack decrStackSize(IInventory inv, int slot, int size) {
        ItemStack item = inv.func_70301_a(slot);
        if (item != null) {
            if (item.field_77994_a <= size) {
                inv.func_70299_a(slot, null);
                inv.func_70296_d();
                return item;
            }
            ItemStack itemstack1 = item.func_77979_a(size);
            if (item.field_77994_a == 0) {
                inv.func_70299_a(slot, null);
            }
            inv.func_70296_d();
            return itemstack1;
        }
        return null;
    }

    public static void consumeItem(IInventory inv, int slot) {
        ItemStack stack = inv.func_70301_a(slot);
        Item item = stack.func_77973_b();
        if (item.hasContainerItem(stack)) {
            ItemStack container = item.getContainerItem(stack);
            inv.func_70299_a(slot, container);
        } else {
            inv.func_70298_a(slot, 1);
        }
    }
}

