/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.utility;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import org.dave.CompactMachines.utility.ItemHelper;

public class FluidUtils {
    public static int B = 1000;
    public static FluidStack water = new FluidStack(FluidRegistry.WATER, 1000);
    public static FluidStack lava = new FluidStack(FluidRegistry.LAVA, 1000);

    public static boolean fillTankWithContainer(IFluidHandler tank, EntityPlayer player) {
        return FluidUtils.fillTankWithContainer(tank, player, ForgeDirection.UNKNOWN);
    }

    public static boolean fillTankWithContainer(IFluidHandler tank, EntityPlayer player, ForgeDirection dir) {
        ItemStack stack = player.func_71045_bC();
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        if (liquid == null) {
            return false;
        }
        if (tank.fill(dir, liquid, false) != liquid.amount) {
            return false;
        }
        tank.fill(dir, liquid, true);
        ItemHelper.consumeItem((IInventory)player.field_71071_by, player.field_71071_by.field_70461_c);
        player.field_71069_bz.func_75142_b();
        return true;
    }

    public static boolean emptyTankIntoContainer(IFluidHandler tank, EntityPlayer player, FluidStack tankLiquid) {
        return FluidUtils.emptyTankIntoContainer(tank, player, tankLiquid, ForgeDirection.UNKNOWN);
    }

    public static boolean emptyTankIntoContainer(IFluidHandler tank, EntityPlayer player, FluidStack tankLiquid, ForgeDirection dir) {
        ItemStack stack = player.func_71045_bC();
        if (!FluidContainerRegistry.isEmptyContainer((ItemStack)stack)) {
            return false;
        }
        ItemStack filled = FluidContainerRegistry.fillFluidContainer((FluidStack)tankLiquid, (ItemStack)stack);
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled);
        if (liquid == null || filled == null) {
            return false;
        }
        tank.drain(dir, liquid.amount, true);
        if (stack.field_77994_a == 1) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filled);
        } else if (player.field_71071_by.func_70441_a(filled)) {
            --stack.field_77994_a;
        } else {
            return false;
        }
        player.field_71069_bz.func_75142_b();
        return true;
    }

    public static FluidStack copy(FluidStack liquid, int quantity) {
        liquid = liquid.copy();
        liquid.amount = quantity;
        return liquid;
    }

    public static FluidStack read(NBTTagCompound tag) {
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
        return stack != null ? stack : new FluidStack(FluidRegistry.WATER, 0);
    }

    public static NBTTagCompound write(FluidStack fluid, NBTTagCompound tag) {
        return fluid == null || fluid.getFluid() == null ? new NBTTagCompound() : fluid.writeToNBT(new NBTTagCompound());
    }

    public static int getLuminosity(FluidStack stack, double density) {
        Fluid fluid = stack.getFluid();
        if (fluid == null) {
            return 0;
        }
        int light = fluid.getLuminosity(stack);
        if (fluid.isGaseous()) {
            light = (int)((double)light * density);
        }
        return light;
    }
}

