/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public abstract class ItemElectricTool
extends ItemTool
implements IElectricItem {
    public int co;
    public int operationEnergyCost;
    public int maxCharge;
    public int transferLimit;
    public int tier;
    public Set mineableBlocks = new HashSet();
    public int iconIndex;

    public ItemElectricTool(int sprite, Item.ToolMaterial toolmaterial, int operationEnergyCost) {
        super(0.0f, toolmaterial, new HashSet());
        this.iconIndex = sprite;
        this.operationEnergyCost = operationEnergyCost;
        this.func_77656_e(27);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return Ic2Icons.getTexture("i0")[this.iconIndex];
    }

    public float func_150893_a(ItemStack tool, Block block) {
        if (!ElectricItem.manager.canUse(tool, this.operationEnergyCost)) {
            return 1.0f;
        }
        if (ForgeHooks.isToolEffective((ItemStack)tool, (Block)block, (int)0)) {
            return this.field_77864_a;
        }
        if (this.func_150897_b(block)) {
            return this.field_77864_a;
        }
        return 1.0f;
    }

    public float getDigSpeed(ItemStack tool, Block block, int md) {
        if (!ElectricItem.manager.canUse(tool, this.operationEnergyCost)) {
            return 1.0f;
        }
        if (ForgeHooks.isToolEffective((ItemStack)tool, (Block)block, (int)md)) {
            return this.field_77864_a;
        }
        if (this.func_150897_b(block)) {
            return this.field_77864_a;
        }
        return super.getDigSpeed(tool, block, md);
    }

    public boolean func_150897_b(Block block) {
        return this.mineableBlocks.contains(block);
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase entityliving1) {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return false;
    }

    public Multimap func_111205_h() {
        Multimap multimap = super.func_111205_h();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.co, 0));
        return multimap;
    }

    public String getTextureFile() {
        return "/ic2/sprites/item_0.png";
    }

    @Override
    public boolean canProvideEnergy(ItemStack par1) {
        return false;
    }

    @Override
    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    @Override
    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    @Override
    public int getTier(ItemStack par1) {
        return this.tier;
    }

    public boolean func_150894_a(ItemStack par1ItemStack, World par2World, Block par3, int par4, int par5, int par6, EntityLivingBase par7EntityLiving) {
        Block block = par2World.func_147439_a(par4, par5, par6);
        if (block == null) {
            IC2.getInstance();
            IC2.log.debug("ItemElectricTool.onBlockDestroyed(): received invalid block id " + par3);
            return false;
        }
        if ((double)block.func_149712_f(par2World, par4, par5, par6) != 0.0) {
            if (par7EntityLiving instanceof EntityPlayer) {
                ElectricItem.manager.use(par1ItemStack, this.operationEnergyCost, (EntityLivingBase)((EntityPlayer)par7EntityLiving));
            } else {
                ElectricItem.manager.discharge(par1ItemStack, this.operationEnergyCost, this.tier, true, true, false);
            }
        }
        return true;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item i, CreativeTabs tabs, List itemList) {
        ItemStack charged = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
        itemList.add(charged);
        itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister p_94581_1_) {
    }
}

