/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal;

import ic2.api.Direction;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.machine.tileentity.TileEntityMachine;
import ic2.core.block.personal.ContainerFluidOMatClosed;
import ic2.core.block.personal.ContainerFluidOMatOpen;
import ic2.core.block.personal.IPersonalBlock;
import ic2.core.block.personal.IPersonalInventory;
import ic2.core.block.personal.PersonalInventory;
import ic2.core.block.personal.TileEntityPersonalChest;
import ic2.core.util.StackUtil;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityFluidOMat
extends TileEntityMachine
implements IHasGui,
IFluidHandler,
IPersonalInventory,
IPersonalBlock,
INetworkClientTileEntityEventListener {
    private static Direction[] directions = Direction.values();
    private UUID owner;
    public FluidTank fluid = new FluidTank(32000);
    public int transferlimit = 20;
    public int paidFor;
    public int fluidOffer = 1000;
    private PersonalInventory inv = new PersonalInventory(this, "Fluid-O-Mat", 2);

    public TileEntityFluidOMat() {
        super(1);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("PlayerOwner")) {
            NBTTagCompound nbtTag = nbt.func_74775_l("PlayerOwner");
            this.owner = new UUID(nbtTag.func_74763_f("UUIDMost"), nbtTag.func_74763_f("UUIDLeast"));
        } else {
            this.owner = null;
        }
        this.paidFor = nbt.func_74762_e("Paid");
        this.fluidOffer = nbt.func_74762_e("Offer");
        if (nbt.func_74764_b("Tank")) {
            this.fluid = this.fluid.readFromNBT(nbt.func_74775_l("Tank"));
        }
        this.inv.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("Paid", this.paidFor);
        nbt.func_74768_a("Offer", this.fluidOffer);
        NBTTagCompound data = new NBTTagCompound();
        this.fluid.writeToNBT(data);
        nbt.func_74782_a("Tank", (NBTBase)data);
        if (this.owner != null) {
            NBTTagCompound NBTTag = new NBTTagCompound();
            NBTTag.func_74772_a("UUIDMost", this.owner.getMostSignificantBits());
            NBTTag.func_74772_a("UUIDLeast", this.owner.getLeastSignificantBits());
            nbt.func_74782_a("PlayerOwner", (NBTBase)NBTTag);
        }
        this.inv.writeToNBT(nbt);
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{1};
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fluid.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        int amount = Math.min(this.paidFor, maxDrain);
        if (amount <= 0) {
            return null;
        }
        if (doDrain) {
            this.paidFor -= amount;
        }
        return this.fluid.drain(amount, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.getFacing() != from.ordinal();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.getFacing() == from.ordinal();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.fluid.getInfo()};
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer p0) {
        if (this.canAccess(p0)) {
            return new ContainerFluidOMatOpen(p0, this);
        }
        return new ContainerFluidOMatClosed(p0, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer p0) {
        if (this.canAccess(p0)) {
            return "block.personal.GuiFluidOMatOpen";
        }
        return "block.personal.GuiFluidOMatClosed";
    }

    @Override
    public void onGuiClosed(EntityPlayer p0) {
    }

    @Override
    public String func_145825_b() {
        return "Fluid-O-Mat";
    }

    @Override
    public List getNetworkedFields() {
        List l = super.getNetworkedFields();
        if (this.owner != null) {
            l.add("owner");
        }
        return l;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (IC2.platform.isSimulating()) {
            int mB;
            if (this.paidFor > 0 && (mB = Math.min(this.paidFor, this.transferlimit)) > 0) {
                Direction dir = this.getDirection(this.getFacing());
                ForgeDirection fDir = dir.toForgeDirection().getOpposite();
                TileEntity tile = dir.applyToTileEntity(this);
                if (tile != null && tile instanceof IFluidHandler) {
                    int filled;
                    IFluidHandler fluid = (IFluidHandler)tile;
                    FluidStack stack = this.drain(fDir, mB, false);
                    if (stack != null && fluid.canFill(fDir, stack.getFluid()) && (filled = fluid.fill(fDir, stack, true)) > 0) {
                        this.drain(fDir, filled, true);
                    }
                }
            }
            if (this.inventory[0] != null && this.inv.func_70301_a(0) != null && this.inventory[0].func_77969_a(this.inv.func_70301_a(0))) {
                int originalStackSize = this.inventory[0].field_77994_a;
                for (Direction direction : directions) {
                    TileEntity target = direction.applyToTileEntity(this);
                    if ((!(target instanceof IInventory) || target instanceof IPersonalBlock) && (!(target instanceof TileEntityPersonalChest) || !((TileEntityPersonalChest)target).canAccess(this.owner))) continue;
                    IInventory targetInventory = (IInventory)target;
                    if (target instanceof TileEntityChest) {
                        targetInventory = Blocks.field_150486_ae.func_149951_m(target.func_145831_w(), target.field_145851_c, target.field_145848_d, target.field_145849_e);
                    }
                    ItemStack stack = this.inventory[0].func_77946_l();
                    int amount = StackUtil.putInInventory(targetInventory, direction, this.owner, stack);
                    stack.field_77994_a -= amount;
                    if (stack.field_77994_a <= 0) {
                        stack = null;
                    }
                    this.inventory[0] = stack;
                }
                int numPaymentMoved = originalStackSize - this.inventory[1].field_77994_a;
                if (numPaymentMoved > 0) {
                    this.paidFor += this.fluidOffer / this.inventory[0].field_77994_a * numPaymentMoved;
                    if (this.inventory[0].field_77994_a == 0) {
                        this.inventory[0] = null;
                    }
                    this.func_70296_d();
                }
            }
        }
    }

    private Direction getDirection(int dir) {
        for (Direction dirs : directions) {
            if (dirs.toSideValue() != dir) continue;
            return dirs;
        }
        return null;
    }

    @Override
    public boolean canAccess(EntityPlayer player) {
        if (this.owner == null) {
            this.owner = player.func_146103_bH().getId();
            IC2.network.get().updateTileEntityField(this, "owner");
            return true;
        }
        return this.canAccess(player.func_146103_bH().getId());
    }

    @Override
    public boolean canAccess(UUID player) {
        if (this.owner == null) {
            return true;
        }
        return this.owner.equals(player);
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        if (!this.canAccess(player)) {
            return;
        }
        switch (event) {
            case 0: {
                this.attemptSet(-1000);
                break;
            }
            case 1: {
                this.attemptSet(-100);
                break;
            }
            case 2: {
                this.attemptSet(1000);
                break;
            }
            case 3: {
                this.attemptSet(100);
                break;
            }
            case 4: {
                this.attemptSet(-10);
                break;
            }
            case 5: {
                this.attemptSet(10);
            }
        }
    }

    private void attemptSet(int amount) {
        if (this.fluidOffer + amount <= 0) {
            amount = 0;
        }
        this.fluidOffer += amount;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side && this.canAccess(entityPlayer);
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return this.canAccess(entityPlayer);
    }

    @Override
    public IPersonalInventory getInventory(EntityPlayer player) {
        if (!this.canAccess(player)) {
            return this;
        }
        return this.getInventory(player.func_146103_bH().getId());
    }

    @Override
    public IPersonalInventory getInventory(UUID player) {
        if (!this.canAccess(player)) {
            return this;
        }
        return this.inv;
    }

    UUID getOwner() {
        return this.owner;
    }
}

