/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.generatornetwork;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class DRGeneratorNetwork
extends WorldSavedData {
    public static final String GENERATOR_NETWORK_NAME = "DRGeneratorNetwork";
    private static DRGeneratorNetwork instance = null;
    private int lastId = 0;
    private final Map<Integer, Network> networks = new HashMap<Integer, Network>();

    public DRGeneratorNetwork(String identifier) {
        super(identifier);
    }

    public void save(World world) {
        world.field_72988_C.func_75745_a(GENERATOR_NETWORK_NAME, (WorldSavedData)this);
        this.func_76185_a();
    }

    public static void clearInstance() {
        if (instance != null) {
            DRGeneratorNetwork.instance.networks.clear();
            instance = null;
        }
    }

    public static DRGeneratorNetwork getChannels() {
        return instance;
    }

    public static DRGeneratorNetwork getChannels(World world) {
        if (world.field_72995_K) {
            return null;
        }
        if (instance != null) {
            return instance;
        }
        instance = (DRGeneratorNetwork)world.field_72988_C.func_75742_a(DRGeneratorNetwork.class, GENERATOR_NETWORK_NAME);
        if (instance == null) {
            instance = new DRGeneratorNetwork(GENERATOR_NETWORK_NAME);
        }
        return instance;
    }

    public Network getOrCreateNetwork(int id) {
        Network channel = this.networks.get(id);
        if (channel == null) {
            channel = new Network();
            this.networks.put(id, channel);
        }
        return channel;
    }

    public Network getChannel(int id) {
        return this.networks.get(id);
    }

    public void deleteChannel(int id) {
        this.networks.remove(id);
    }

    public int newChannel() {
        ++this.lastId;
        return this.lastId;
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        this.networks.clear();
        NBTTagList lst = tagCompound.func_150295_c("networks", 10);
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            NBTTagCompound tc = lst.func_150305_b(i);
            int channel = tc.func_74762_e("channel");
            Network value = new Network();
            value.readFromNBT(tc);
            this.networks.put(channel, value);
        }
        this.lastId = tagCompound.func_74762_e("lastId");
    }

    public void func_76187_b(NBTTagCompound tagCompound) {
        NBTTagList lst = new NBTTagList();
        for (Map.Entry<Integer, Network> entry : this.networks.entrySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74768_a("channel", entry.getKey().intValue());
            entry.getValue().writeToNBT(tc);
            lst.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("networks", (NBTBase)lst);
        tagCompound.func_74768_a("lastId", this.lastId);
    }

    public static class Network {
        private int generatorBlocks = 0;
        private int collectorBlocks = 0;
        private int energy = 0;
        private boolean active = false;
        private int startupCounter = 0;
        private int shutdownCounter = 0;
        private int lastRfPerTick = 0;

        public int getGeneratorBlocks() {
            return this.generatorBlocks;
        }

        public void setGeneratorBlocks(int generatorBlocks) {
            this.generatorBlocks = generatorBlocks;
        }

        public void incGeneratorBlocks() {
            ++this.generatorBlocks;
        }

        public void decGeneratorBlocks() {
            --this.generatorBlocks;
        }

        public int getCollectorBlocks() {
            return this.collectorBlocks;
        }

        public void setCollectorBlocks(int collectorBlocks) {
            this.collectorBlocks = collectorBlocks;
        }

        public void incCollectorBlocks() {
            ++this.collectorBlocks;
        }

        public void decCollectorBlocks() {
            --this.collectorBlocks;
        }

        public int getEnergy() {
            return this.energy;
        }

        public void setEnergy(int energy) {
            this.energy = energy;
        }

        public int getLastRfPerTick() {
            return this.lastRfPerTick;
        }

        public void setLastRfPerTick(int lastRfPerTick) {
            this.lastRfPerTick = lastRfPerTick;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public int getStartupCounter() {
            return this.startupCounter;
        }

        public void setStartupCounter(int startupCounter) {
            this.startupCounter = startupCounter;
        }

        public int getShutdownCounter() {
            return this.shutdownCounter;
        }

        public void setShutdownCounter(int shutdownCounter) {
            this.shutdownCounter = shutdownCounter;
        }

        public void writeToNBT(NBTTagCompound tagCompound) {
            tagCompound.func_74768_a("refcount", this.generatorBlocks);
            tagCompound.func_74768_a("collectors", this.collectorBlocks);
            tagCompound.func_74768_a("energy", this.energy);
            tagCompound.func_74757_a("active", this.active);
            tagCompound.func_74768_a("startup", this.startupCounter);
            tagCompound.func_74768_a("shutdown", this.shutdownCounter);
        }

        public void readFromNBT(NBTTagCompound tagCompound) {
            this.generatorBlocks = tagCompound.func_74762_e("refcount");
            this.collectorBlocks = tagCompound.func_74762_e("collectors");
            this.energy = tagCompound.func_74762_e("energy");
            this.active = tagCompound.func_74767_n("active");
            this.startupCounter = tagCompound.func_74762_e("startup");
            this.shutdownCounter = tagCompound.func_74762_e("shutdown");
        }
    }
}

