/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.laser;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import java.util.List;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.blocks.laser.GuiLaser;
import mcjty.deepresonance.blocks.laser.LaserContainer;
import mcjty.deepresonance.blocks.laser.LaserTileEntity;
import mcjty.deepresonance.client.ClientHandler;
import mcjty.deepresonance.gui.GuiProxy;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericBlock;
import mcjty.lib.varia.BlockTools;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

@Optional.InterfaceList(value={@Optional.Interface(iface="crazypants.enderio.api.redstone.IRedstoneConnectable", modid="EnderIO")})
public class LaserBlock
extends GenericBlock
implements IRedstoneConnectable {
    private IIcon[] icons = new IIcon[4];

    public LaserBlock() {
        super((ModBase)DeepResonance.instance, Material.field_151573_f, LaserTileEntity.class, false);
        this.func_149663_c("laserBlock");
        this.setHorizRotation(true);
        this.func_149647_a(DeepResonance.tabDeepResonance);
    }

    public int getGuiID() {
        return GuiProxy.GUI_LASER;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, TileEntity tileEntity) {
        LaserTileEntity laserTileEntity = (LaserTileEntity)tileEntity;
        LaserContainer laserContainer = new LaserContainer(entityPlayer, laserTileEntity);
        return new GuiLaser(laserTileEntity, laserContainer);
    }

    public Container createServerContainer(EntityPlayer entityPlayer, TileEntity tileEntity) {
        return new LaserContainer(entityPlayer, (LaserTileEntity)tileEntity);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add("Place this laser so it faces a lens.");
            list.add("It will infuse the liquid in the tank");
            list.add("depending on the materials used.");
        } else {
            list.add(EnumChatFormatting.WHITE + ClientHandler.getShiftMessage());
        }
    }

    public String getIdentifyingIconName() {
        return "laserBlockFront";
    }

    public String getSideIconName() {
        return "laserBlock";
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.iconInd = iconRegister.func_94245_a("deepresonance:" + this.getIdentifyingIconName());
        this.iconSide = iconRegister.func_94245_a(this.modBase.getModId() + ":" + this.getSideIconName());
        this.icons[0] = iconRegister.func_94245_a("deepresonance:laserBlueBlock");
        this.icons[1] = iconRegister.func_94245_a("deepresonance:laserRedBlock");
        this.icons[2] = iconRegister.func_94245_a("deepresonance:laserGreenBlock");
        this.icons[3] = iconRegister.func_94245_a("deepresonance:laserYellowBlock");
        this.iconTop = iconRegister.func_94245_a("deepresonance:" + this.getTopIconName());
        this.iconBottom = iconRegister.func_94245_a("deepresonance:" + this.getBottomIconName());
    }

    protected void rotateBlock(World world, int x, int y, int z) {
        super.rotateBlock(world, x, y, z);
        if (world.field_72995_K) {
            world.func_147471_g(x, y, z);
        }
    }

    public boolean shouldRedstoneConduitConnect(World world, int x, int y, int z, ForgeDirection from) {
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.checkRedstoneWithTE(world, x, y, z);
    }

    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return this.getIconInternal(side, blockAccess.func_72805_g(x, y, z));
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.getIconInternal(side, meta);
    }

    private IIcon getIconInternal(int side, int meta) {
        ForgeDirection k = this.getOrientation(meta);
        if (this.iconInd != null && side == k.ordinal()) {
            return this.iconInd;
        }
        if (this.iconTop != null && side == BlockTools.getTopDirection((ForgeDirection)k).ordinal()) {
            return this.iconTop;
        }
        if (this.iconBottom != null && side == BlockTools.getBottomDirection((ForgeDirection)k).ordinal()) {
            return this.iconBottom;
        }
        int color = meta >> 2 & 3;
        if (color == 1) {
            return this.icons[0];
        }
        if (color == 2) {
            return this.icons[1];
        }
        if (color == 3) {
            return this.icons[2];
        }
        return this.iconSide;
    }
}

