/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.generator;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.blocks.generator.GeneratorConfiguration;
import mcjty.deepresonance.blocks.generator.GeneratorSetup;
import mcjty.deepresonance.blocks.generator.GeneratorTileEntity;
import mcjty.deepresonance.client.ClientHandler;
import mcjty.deepresonance.generatornetwork.DRGeneratorNetwork;
import mcjty.deepresonance.network.PacketGetGeneratorInfo;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericBlock;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

public class GeneratorBlock
extends GenericBlock {
    private IIcon iconUpDown;
    private IIcon[] icons = new IIcon[8];
    public static final int META_ON = 1;
    public static final int META_OFF = 0;
    public static final int META_HASUPPER = 2;
    public static final int META_HASLOWER = 4;
    public static int tooltipEnergy = 0;
    public static int tooltipRefCount = 0;
    public static int tooltipRfPerTick = 0;
    private static long lastTime = 0L;

    public GeneratorBlock() {
        super((ModBase)DeepResonance.instance, Material.field_151573_f, GeneratorTileEntity.class, false);
        this.func_149663_c("generatorBlock");
        this.setHorizRotation(true);
        this.func_149647_a(DeepResonance.tabDeepResonance);
    }

    public int getGuiID() {
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add(EnumChatFormatting.YELLOW + "Energy: " + tagCompound.func_74762_e("energy"));
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add("Part of a generator multi-block.");
            list.add("You can place these in any configuration.");
        } else {
            list.add(EnumChatFormatting.WHITE + ClientHandler.getShiftMessage());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof GeneratorTileEntity) {
            GeneratorTileEntity generatorTileEntity = (GeneratorTileEntity)tileEntity;
            currenttip.add(EnumChatFormatting.GREEN + "ID: " + new DecimalFormat("#.##").format(generatorTileEntity.getNetworkId()));
            if (System.currentTimeMillis() - lastTime > 250L) {
                lastTime = System.currentTimeMillis();
                DeepResonance.networkHandler.getNetworkWrapper().sendToServer((IMessage)new PacketGetGeneratorInfo(generatorTileEntity.getNetworkId()));
            }
            currenttip.add(EnumChatFormatting.GREEN + "Energy: " + tooltipEnergy + "/" + tooltipRefCount * GeneratorConfiguration.rfPerGeneratorBlock + " RF");
            currenttip.add(EnumChatFormatting.YELLOW + Integer.toString(tooltipRfPerTick) + " RF/t");
        }
        return currenttip;
    }

    public String getSideIconName() {
        return "machineGenerator";
    }

    protected ForgeDirection getOrientation(int x, int y, int z, EntityLivingBase entityLivingBase) {
        return ForgeDirection.NORTH;
    }

    private void updateMeta(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z) & 8;
        if (world.func_147439_a(x, y + 1, z) == GeneratorSetup.generatorBlock) {
            meta |= 2;
        }
        if (world.func_147439_a(x, y - 1, z) == GeneratorSetup.generatorBlock) {
            meta |= 4;
        }
        world.func_72921_c(x, y, z, meta, 3);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, entityLivingBase, itemStack);
        if (!world.field_72995_K) {
            TileEntity te;
            this.updateMeta(world, x, y, z);
            if (world.func_147439_a(x, y + 1, z) == GeneratorSetup.generatorBlock) {
                this.updateMeta(world, x, y + 1, z);
            }
            if (world.func_147439_a(x, y - 1, z) == GeneratorSetup.generatorBlock) {
                this.updateMeta(world, x, y - 1, z);
            }
            if ((te = world.func_147438_o(x, y, z)) instanceof GeneratorTileEntity) {
                ((GeneratorTileEntity)te).addBlockToNetwork();
                DRGeneratorNetwork.Network network = ((GeneratorTileEntity)te).getNetwork();
                if (network != null) {
                    NBTTagCompound tagCompound = itemStack.func_77978_p();
                    network.setEnergy(network.getEnergy() + (tagCompound == null ? 0 : tagCompound.func_74762_e("energy")));
                    DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(world);
                    generatorNetwork.save(world);
                }
            }
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        DRGeneratorNetwork.Network network;
        TileEntity te;
        ArrayList drops = super.getDrops(world, x, y, z, metadata, fortune);
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof GeneratorTileEntity && (network = ((GeneratorTileEntity)te).getNetwork()) != null) {
            int energy = network.getEnergy() / network.getGeneratorBlocks();
            if (!drops.isEmpty()) {
                NBTTagCompound tagCompound = ((ItemStack)drops.get(0)).func_77978_p();
                if (tagCompound == null) {
                    tagCompound = new NBTTagCompound();
                    ((ItemStack)drops.get(0)).func_77982_d(tagCompound);
                }
                tagCompound.func_74768_a("energy", energy);
            }
        }
        return drops;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof GeneratorTileEntity) {
            DRGeneratorNetwork.Network network = ((GeneratorTileEntity)te).getNetwork();
            if (network != null) {
                int energy = network.getEnergy() / network.getGeneratorBlocks();
                network.setEnergy(network.getEnergy() - energy);
            }
            ((GeneratorTileEntity)te).removeBlockFromNetwork();
        }
        super.func_149749_a(world, x, y, z, block, meta);
        if (!world.field_72995_K) {
            if (world.func_147439_a(x, y + 1, z) == GeneratorSetup.generatorBlock) {
                this.updateMeta(world, x, y + 1, z);
            }
            if (world.func_147439_a(x, y - 1, z) == GeneratorSetup.generatorBlock) {
                this.updateMeta(world, x, y - 1, z);
            }
        }
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.iconUpDown = iconRegister.func_94245_a("deepresonance:machineBase");
        IIcon[] iconFull = new IIcon[2];
        IIcon[] iconTop = new IIcon[2];
        IIcon[] iconBottom = new IIcon[2];
        IIcon[] iconMiddle = new IIcon[2];
        for (int i = 0; i < 2; ++i) {
            iconFull[i] = iconRegister.func_94245_a("deepresonance:generatorSideFull" + (i == 0 ? "Off" : "On"));
            iconTop[i] = iconRegister.func_94245_a("deepresonance:generatorSideTop" + (i == 0 ? "Off" : "On"));
            iconBottom[i] = iconRegister.func_94245_a("deepresonance:generatorSideBottom" + (i == 0 ? "Off" : "On"));
            iconMiddle[i] = iconRegister.func_94245_a("deepresonance:generatorSideMiddle" + (i == 0 ? "Off" : "On"));
        }
        this.icons[0] = iconFull[0];
        this.icons[1] = iconFull[1];
        this.icons[2] = iconBottom[0];
        this.icons[3] = iconBottom[1];
        this.icons[4] = iconTop[0];
        this.icons[5] = iconTop[1];
        this.icons[6] = iconMiddle[0];
        this.icons[7] = iconMiddle[1];
    }

    public IIcon func_149691_a(int side, int meta) {
        if (side == ForgeDirection.DOWN.ordinal() || side == ForgeDirection.UP.ordinal()) {
            return this.iconUpDown;
        }
        return this.icons[meta & 7];
    }

    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        if (side == ForgeDirection.DOWN.ordinal() || side == ForgeDirection.UP.ordinal()) {
            return this.iconUpDown;
        }
        int meta = blockAccess.func_72805_g(x, y, z);
        return this.icons[meta & 7];
    }
}

