/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.crystals;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import elec332.core.main.ElecCore;
import java.text.DecimalFormat;
import java.util.List;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.blocks.crystals.ResonatingCrystalTileEntity;
import mcjty.deepresonance.boom.TestExplosion;
import mcjty.deepresonance.network.PacketGetCrystalInfo;
import mcjty.deepresonance.radiation.DRRadiationManager;
import mcjty.deepresonance.radiation.RadiationConfiguration;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericBlock;
import mcjty.lib.varia.Coordinate;
import mcjty.lib.varia.GlobalCoordinate;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ResonatingCrystalBlock
extends GenericBlock {
    public static int tooltipRFTick = 0;
    public static float tooltipPower = 0.0f;
    private static long lastTime = 0L;

    public ResonatingCrystalBlock() {
        super((ModBase)DeepResonance.instance, Material.field_151592_s, ResonatingCrystalTileEntity.class, false);
        this.func_149663_c("resonatingCrystalBlock");
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149658_d("deepresonance:crystal");
        this.func_149672_a(field_149778_k);
        this.func_149647_a(DeepResonance.tabDeepResonance);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean advancedToolTips) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            tagCompound.func_82580_o("owner");
            tagCompound.func_82580_o("ownerM");
            tagCompound.func_82580_o("idM");
        }
        super.addInformation(itemStack, player, list, advancedToolTips);
        float power = 100.0f;
        if (tagCompound != null) {
            power = tagCompound.func_74760_g("power");
        }
        if (power > 1.0E-5f) {
            list.add("You can feel the latent power present in this crystal.");
        } else {
            list.add("This crystal is depleted. Perhaps it still has a future use?");
        }
        if (tagCompound != null) {
            DecimalFormat decimalFormat = new DecimalFormat("#.##");
            list.add(EnumChatFormatting.GREEN + "Strength/Efficiency/Purity: " + decimalFormat.format(tagCompound.func_74760_g("strength")) + "% " + decimalFormat.format(tagCompound.func_74760_g("efficiency")) + "% " + decimalFormat.format(tagCompound.func_74760_g("purity")) + "%");
            list.add(EnumChatFormatting.YELLOW + "Power left: " + decimalFormat.format(power) + "%");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)tileEntity;
            DecimalFormat decimalFormat = new DecimalFormat("#.##");
            currenttip.add(EnumChatFormatting.GREEN + "Strength/Efficiency/Purity: " + decimalFormat.format(resonatingCrystalTileEntity.getStrength()) + "% " + decimalFormat.format(resonatingCrystalTileEntity.getEfficiency()) + "% " + decimalFormat.format(resonatingCrystalTileEntity.getPurity()) + "%");
            currenttip.add(EnumChatFormatting.YELLOW + "Power left: " + decimalFormat.format(tooltipPower) + "% (" + tooltipRFTick + " RF/t)");
            if (System.currentTimeMillis() - lastTime > 250L) {
                lastTime = System.currentTimeMillis();
                DeepResonance.networkHandler.getNetworkWrapper().sendToServer((IMessage)new PacketGetCrystalInfo(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e));
            }
        }
        return currenttip;
    }

    public void onBlockExploded(final World world, final int x, final int y, final int z, Explosion explosion) {
        if (!world.field_72995_K) {
            final TileEntity theCrystalTile = world.func_147438_o(x, y, z);
            ElecCore.tickHandler.registerCall(new Runnable(){

                @Override
                public void run() {
                    float forceMultiplier = 1.0f;
                    if (theCrystalTile instanceof ResonatingCrystalTileEntity) {
                        ResonatingCrystalTileEntity resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)theCrystalTile;
                        float explosionStrength = resonatingCrystalTileEntity.getPower() * resonatingCrystalTileEntity.getStrength() / 10000.0f;
                        forceMultiplier = explosionStrength * (RadiationConfiguration.maximumExplosionMultiplier - RadiationConfiguration.minimumExplosionMultiplier) + RadiationConfiguration.minimumExplosionMultiplier;
                        if (forceMultiplier > RadiationConfiguration.absoluteMaximumExplosionMultiplier) {
                            forceMultiplier = RadiationConfiguration.absoluteMaximumExplosionMultiplier;
                        }
                        if (forceMultiplier > 0.001f) {
                            DRRadiationManager radiationManager = DRRadiationManager.getManager(world);
                            DRRadiationManager.RadiationSource source = radiationManager.getOrCreateRadiationSource(new GlobalCoordinate(new Coordinate(x, y, z), world.field_73011_w.field_76574_g));
                            float radiationRadius = DRRadiationManager.calculateRadiationRadius(resonatingCrystalTileEntity.getEfficiency(), resonatingCrystalTileEntity.getPurity());
                            float radiationStrength = DRRadiationManager.calculateRadiationStrength(resonatingCrystalTileEntity.getStrength(), resonatingCrystalTileEntity.getPurity());
                            source.update(radiationRadius * RadiationConfiguration.radiationExplosionFactor, radiationStrength / RadiationConfiguration.radiationExplosionFactor, 1000);
                        }
                    }
                    if (forceMultiplier > 0.001f) {
                        TestExplosion boom = new TestExplosion(world, null, x, y, z, forceMultiplier);
                        boom.explode();
                    }
                }
            }, world);
        }
        super.onBlockExploded(world, x, y, z, explosion);
    }

    public int getGuiID() {
        return -1;
    }

    public String getSideIconName() {
        return "crystal";
    }

    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }
}

