/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.integration;

import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBloodOrb;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.SteamcraftItems;
import flaxbeard.steamcraft.api.SteamcraftRegistry;
import flaxbeard.steamcraft.api.book.BookRecipeRegistry;
import flaxbeard.steamcraft.api.exosuit.ExosuitPlate;
import flaxbeard.steamcraft.api.exosuit.UtilPlates;
import flaxbeard.steamcraft.integration.thaumcraft.LifeEssenceCap;
import flaxbeard.steamcraft.item.ItemExosuitArmor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BloodMagicIntegration {
    public static void postInit() {
        if (Config.enableSadistPlate) {
            SteamcraftRegistry.addExosuitPlate(new ExosuitPlate("Sadist", new ItemStack(SteamcraftItems.exosuitPlate, 1, 10), "Sadist", "Sadist", "steamcraft.plate.sadist", new DamageSource[0]));
            BookRecipeRegistry.addRecipe("exoSadist", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.exosuitPlate, 1, 10), new Object[]{" s ", "sbs", " s ", Character.valueOf('s'), ModItems.reinforcedSlate, Character.valueOf('b'), ModBlocks.runeOfSelfSacrifice}));
        }
    }

    public static void clickLeft(PlayerInteractEvent event) {
        Item item;
        ItemStack stack;
        if (!event.world.field_72995_K && (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR || event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) && (stack = event.entityPlayer.func_70694_bm()) != null && (item = stack.func_77973_b()) != null && item instanceof IBloodOrb) {
            LifeEssenceCap data = BloodMagicIntegration.getData(event.entityPlayer.func_70005_c_());
            int cap = ((IBloodOrb)item).getMaxEssence();
            if (cap > data.cap) {
                data.cap = cap;
                data.func_76185_a();
            }
        }
    }

    public static LifeEssenceCap getData(String name) {
        WorldServer world = MinecraftServer.func_71276_C().field_71305_c[0];
        LifeEssenceCap data = (LifeEssenceCap)world.func_72943_a(LifeEssenceCap.class, name + "cap");
        if (data == null) {
            data = new LifeEssenceCap(name + "cap");
            world.func_72823_a(name + "cap", (WorldSavedData)data);
        }
        return data;
    }

    public static void handleAttack(LivingHurtEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            int bmPlates = 0;
            for (int i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                ItemExosuitArmor armorItem;
                ItemStack armor = player.field_71071_by.field_70460_b[i];
                if (armor == null || !(armor.func_77973_b() instanceof ItemExosuitArmor) || !(armorItem = (ItemExosuitArmor)armor.func_77973_b()).hasPlates(armor) || UtilPlates.getPlate(armor.field_77990_d.func_74779_i("plate")).getIdentifier() != "Sadist") continue;
                ++bmPlates;
            }
            if (bmPlates > 0) {
                int lp = (int)event.ammount * 12 * bmPlates;
                EnergyItems.addEssenceToMaximum((String)player.func_70005_c_(), (int)lp, (int)BloodMagicIntegration.getData((String)player.func_70005_c_()).cap);
            }
        }
    }
}

