/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Weaponry;

import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Interfaces.TileEntity.AdjacentUpdateWatcher;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import Reika.RotaryCraft.API.Event.VDGAttackEvent;
import Reika.RotaryCraft.API.Interfaces.Shockable;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Entities.EntityDischarge;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemArmor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityVanDeGraff
extends TileEntityPowerReceiver
implements RangedEffect,
AdjacentUpdateWatcher {
    private final WeightedRandom<ForgeDirection> sideMap = new WeightedRandom();
    private int charge;

    private void updateSidedMappings(World world, int x, int y, int z) {
        this.sideMap.clear();
        for (int i = 1; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            Block b = world.func_147439_a(dx, dy, dz);
            int metadata = world.func_72805_g(dx, dy, dz);
            if (b.isAir((IBlockAccess)world, dx, dy, dz)) {
                this.sideMap.addEntry((Object)dir, 0.0);
                continue;
            }
            Material mat = b.func_149688_o();
            MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, dx, dy, dz);
            if (m == MachineRegistry.VANDEGRAFF) {
                this.sideMap.addEntry((Object)dir, 0.0);
                continue;
            }
            TileEntity te = this.getAdjacentTileEntity(dir);
            if (te instanceof Shockable) {
                this.sideMap.addEntry((Object)dir, 1000.0);
                continue;
            }
            if (mat == Material.field_151573_f || mat == Material.field_151574_g || InterfaceCache.BCPIPE.instanceOf((Object)te)) {
                this.sideMap.addEntry((Object)dir, 50.0);
                continue;
            }
            if (mat == Material.field_151586_h) {
                this.sideMap.addEntry((Object)dir, 20.0);
                continue;
            }
            if (b != Blocks.field_150335_W) continue;
            this.sideMap.addEntry((Object)dir, 100.0);
        }
        this.sideMap.addEntry((Object)ForgeDirection.UNKNOWN, 1.0);
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.updateSidedMappings(world, x, y, z);
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getPowerBelow();
        this.charge = (int)((double)this.charge + 4.0 * Math.sqrt(this.power));
        int r = this.getRange();
        if (r > 0) {
            ForgeDirection dir = (ForgeDirection)this.sideMap.getRandomEntry();
            if (dir != null && dir != ForgeDirection.UNKNOWN) {
                this.shock(world, x, y, z, dir);
                return;
            }
            for (int i = 2; i < 4; ++i) {
                TileEntity te = this.getTileEntity(x, y + i, z);
                if (!(te instanceof Shockable) || !((Shockable)te).canDischargeLongRange()) continue;
                this.dischargeToBlock(x, y + i, z, (Shockable)te);
                return;
            }
        }
        if (this.charge <= 0) {
            return;
        }
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72314_b((double)r, (double)r, (double)r);
        EntityLivingBase e = ReikaWorldHelper.getClosestLivingEntityNoPlayers((World)world, (double)((double)x + 0.5), (double)((double)y + 0.75), (double)((double)z + 0.5), (AxisAlignedBB)box, (boolean)true);
        if (e != null) {
            EntityDischarge d = new EntityDischarge(world, (double)x + 0.5, (double)y + 0.75, (double)z + 0.5, this.charge, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e() * 0.8, e.field_70161_v);
            if (!world.field_72995_K) {
                this.shock(e);
                world.func_72838_d((Entity)d);
            }
            this.charge = 0;
        }
        if (this.charge > 0x200000 && !world.field_72995_K) {
            this.detonate(world, x, y, z);
        }
        if (world.func_72896_J() && world.func_72951_B(x, y + 1, z)) {
            this.charge = (int)((double)this.charge * 0.5);
        }
    }

    private void shock(World world, int x, int y, int z, ForgeDirection dir) {
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        TileEntity te = this.getAdjacentTileEntity(dir);
        Block b = world.func_147439_a(dx, dy, dz);
        if (b.isAir((IBlockAccess)world, dx, dy, dz)) {
            return;
        }
        this.dischargeToBlock(dx, dy, dz, te instanceof Shockable ? (Shockable)te : null);
        if (b == Blocks.field_150335_W) {
            world.func_147468_f(dx, dy, dz);
            EntityTNTPrimed e = new EntityTNTPrimed(world, (double)dx + 0.5, (double)dy + 0.5, (double)dz + 0.5, null);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)e);
            }
            world.func_72956_a((Entity)e, "random.fuse", 1.0f, 1.0f);
            world.func_72869_a("lava", (double)((float)dx + rand.nextFloat()), (double)((float)dy + rand.nextFloat()), (double)((float)dz + rand.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    private void detonate(World world, int x, int y, int z) {
        EntityLightningBolt b = new EntityLightningBolt(world, (double)x + 0.5, (double)y, (double)z + 0.5);
        world.func_72942_c((Entity)b);
        this.charge = 0;
        world.func_147468_f(x, y, z);
        world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 4.0f, true, true);
    }

    public void dischargeToBlock(int x, int y, int z, Shockable s) {
        float dx = 0.5f;
        float dy = 0.5f;
        float dz = 0.5f;
        if (s != null) {
            int min = s.getMinDischarge();
            if (this.charge < min) {
                return;
            }
            s.onDischarge(this.charge, ReikaMathLibrary.py3d((double)(this.field_145851_c - x), (double)(this.field_145848_d - y), (double)(this.field_145849_e - z)));
            dx = s.getAimX();
            dy = s.getAimY();
            dz = s.getAimZ();
        }
        SoundRegistry.SPARK.playSoundAtBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.25f, 1.0f);
        EntityDischarge d = new EntityDischarge(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.75, (double)this.field_145849_e + 0.5, this.charge, (float)x + dx, (float)y + dy, (float)z + dz);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72838_d((Entity)d);
        }
        this.charge = 0;
    }

    private void shock(EntityLivingBase e) {
        int dmg = this.getAttackDamage();
        if (ReikaEntityHelper.isEntityWearingFullSuitOf((EntityLivingBase)e, (ItemArmor.ArmorMaterial)ItemArmor.ArmorMaterial.CHAIN)) {
            dmg = 0;
        } else if (ReikaEntityHelper.isEntityWearingFullSuitOf((EntityLivingBase)e, (ItemArmor.ArmorMaterial)ItemArmor.ArmorMaterial.CLOTH)) {
            dmg /= 2;
        }
        if (dmg > 0) {
            e.func_70097_a((DamageSource)RotaryCraft.shock, (float)dmg);
            if (e instanceof EntityCreeper) {
                this.field_145850_b.func_72876_a((Entity)e, e.field_70165_t, e.field_70163_u, e.field_70161_v, 3.0f, true);
                e.func_70097_a(DamageSource.field_76376_m, 2.1474836E9f);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new VDGAttackEvent((TileEntity)this, this.charge, dmg));
        SoundRegistry.SPARK.playSoundAtBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.25f, 1.0f);
    }

    private int getAttackDamage() {
        return 1 + (int)(Math.pow(this.charge, 2.0) / 3.3554432E7);
    }

    public int getCharge() {
        return this.charge;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.VANDEGRAFF;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public int getRange() {
        return Math.min(this.charge / 1024, this.getMaxRange());
    }

    @Override
    public int getMaxRange() {
        return 16;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("c", this.charge);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.charge = NBT.func_74762_e("c");
    }

    public void onAdjacentUpdate(World world, int x, int y, int z, Block b) {
        this.updateSidedMappings(world, x, y, z);
    }
}

