/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Weaponry;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.ModInteract.ModExplosiveHandler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import Reika.MeteorCraft.API.MeteorEntity;
import Reika.RotaryCraft.API.Event.ForceFieldEvent;
import Reika.RotaryCraft.Auxiliary.Interfaces.EnchantableMachine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityProtectionDome;
import Reika.RotaryCraft.Entities.EntityRailGunShot;
import Reika.RotaryCraft.Registry.MachineRegistry;
import com.builtbroken.icbm.api.missile.IMissileEntity;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class TileEntityForceField
extends TileEntityProtectionDome
implements EnchantableMachine {
    private HashMap<Enchantment, Integer> enchantments = new HashMap();
    public static final int FALLOFF = 32768;

    public double[] getBoundaryCoord(double x, double y, double z) {
        double[] xyz = new double[3];
        Vec3 vec = ReikaVectorHelper.getVec2Pt((double)x, (double)y, (double)z, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5));
        xyz[0] = vec.func_72432_b().field_72450_a;
        xyz[1] = vec.func_72432_b().field_72448_b;
        xyz[2] = vec.func_72432_b().field_72449_c;
        int i = 0;
        while (i < 3) {
            int n = i++;
            xyz[n] = xyz[n] * (double)this.getRange();
        }
        return xyz;
    }

    @Override
    public int getRangeBoost() {
        return 8 * this.getEnchantment(Enchantment.field_77332_c);
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        this.getPowerBelow();
        if (this.power < this.MINPOWER) {
            return;
        }
        this.spawnParticles(world, x, y, z);
        this.setColor(256 / this.tickcount, 128 + 512 / this.tickcount, 255);
        AxisAlignedBB field = this.getRangedBox();
        List threats = world.func_72872_a(Entity.class, field);
        for (Entity e : threats) {
            this.protect(world, e);
        }
    }

    private void protect(World world, Entity threat) {
        double x = threat.field_70165_t;
        double y = threat.field_70163_u;
        double z = threat.field_70161_v;
        if (ModList.METEORCRAFT.isLoaded() && threat instanceof MeteorEntity) {
            ((MeteorEntity)threat).destroy();
        }
        if (this.isAtBorder(x, y, z) || threat instanceof EntityArrow) {
            double dist;
            double dz;
            double dz2;
            double dy;
            double dx;
            double dd;
            int j;
            List var4;
            if (threat instanceof EntityWitherSkull) {
                ((EntityWitherSkull)threat).func_70106_y();
                if (!world.field_72995_K) {
                    world.func_72876_a(null, x, y, z, 1.0f, false);
                }
                this.tickcount = 0;
            }
            if (threat instanceof EntityFireball) {
                if (((EntityFireball)threat).field_70235_a instanceof EntityGhast && !world.field_72995_K) {
                    world.func_72876_a(null, x, y, z, 2.0f, true);
                }
                if (((EntityFireball)threat).field_70235_a instanceof EntityBlaze) {
                    for (int k = 0; k < 6 + rand.nextInt(7); ++k) {
                        world.func_72869_a("flame", x - 0.2 + 0.4 * (double)rand.nextFloat(), y - 0.2 + 0.4 * (double)rand.nextFloat(), z - 0.2 + 0.4 * (double)rand.nextFloat(), 0.0, 0.0, 0.0);
                    }
                    world.func_72926_e(1008, (int)x, (int)y, (int)z, 1);
                }
                if (((EntityFireball)threat).field_70235_a instanceof EntityPlayer && !world.field_72995_K) {
                    world.func_72876_a(null, x, y, z, 2.0f, true);
                }
                threat.func_70106_y();
                this.tickcount = 0;
            }
            if (threat instanceof EntityRailGunShot) {
                EntityRailGunShot e = (EntityRailGunShot)threat;
                e.func_70227_a(null);
                this.tickcount = 0;
            }
            if (threat instanceof EntityPotion) {
                if (!threat.field_70128_L) {
                    AxisAlignedBB var3;
                    List var2 = Items.field_151068_bn.func_77834_f(((EntityPotion)threat).func_70196_i());
                    if (var2 != null && !var2.isEmpty() && (var4 = ((EntityPotion)threat).field_70170_p.func_72872_a(EntityLivingBase.class, var3 = ((EntityPotion)threat).field_70121_D.func_72314_b(4.0, 2.0, 4.0))) != null && !var4.isEmpty()) {
                        for (EntityLivingBase var6 : var4) {
                            double var7 = ((EntityPotion)threat).func_70068_e((Entity)var6);
                            if (!(var7 < 16.0)) continue;
                            double var9 = 1.0 - Math.sqrt(var7) / 4.0;
                            for (PotionEffect var12 : var2) {
                                int var13 = var12.func_76456_a();
                                if (Potion.field_76425_a[var13].func_76403_b()) {
                                    Potion.field_76425_a[var13].func_76402_a(((EntityPotion)threat).func_85052_h(), var6, var12.func_76458_c(), var9);
                                    continue;
                                }
                                int var14 = (int)(var9 * (double)var12.func_76459_b() + 0.5);
                                if (var14 <= 20) continue;
                                var6.func_70690_d(new PotionEffect(var13, var14, var12.func_76458_c()));
                            }
                        }
                    }
                    ((EntityPotion)threat).field_70170_p.func_72926_e(2002, (int)Math.round(((EntityPotion)threat).field_70165_t), (int)Math.round(((EntityPotion)threat).field_70163_u), (int)Math.round(((EntityPotion)threat).field_70161_v), ((EntityPotion)threat).func_70196_i());
                    ((EntityPotion)threat).func_70106_y();
                }
                this.tickcount = 0;
            }
            if (threat instanceof EntitySnowball) {
                threat.func_70106_y();
                for (j = 0; j < 3 + rand.nextInt(3); ++j) {
                    world.func_72869_a("snowballpoof", x - 0.2 + 0.4 * (double)rand.nextFloat(), y - 0.2 + 0.4 * (double)rand.nextFloat(), z - 0.2 + 0.4 * (double)rand.nextFloat(), 0.0, 0.0, 0.0);
                }
                world.func_72908_a(x, y, z, "dig.snow", 1.0f, 1.0f);
                this.tickcount = 0;
            }
            if (threat instanceof EntityEgg) {
                threat.func_70106_y();
                for (j = 0; j < 3 + rand.nextInt(3); ++j) {
                    world.func_72869_a("snowballpoof", x - 0.2 + 0.4 * (double)rand.nextFloat(), y - 0.2 + 0.4 * (double)rand.nextFloat(), z - 0.2 + 0.4 * (double)rand.nextFloat(), 0.0, 0.0, 0.0);
                }
                world.func_72908_a(x, y, z, "random.glass", 1.0f, 5.0f);
                if (!world.field_72995_K && rand.nextInt(8) == 0) {
                    int var2 = 1;
                    if (rand.nextInt(32) == 0) {
                        var2 = 4;
                    }
                    for (int var3 = 0; var3 < var2; ++var3) {
                        var4 = new EntityChicken(world);
                        var4.func_70873_a(-24000);
                        var4.func_70012_b(x, y, z, threat.field_70177_z, 0.0f);
                        this.field_145850_b.func_72838_d((Entity)var4);
                    }
                }
                this.tickcount = 0;
            }
            if (threat instanceof EntityPlayer && !threat.func_110124_au().equals(this.placerUUID) && (dd = ReikaMathLibrary.py3d((double)(dx = threat.field_70165_t - (double)this.field_145851_c - 0.5), (double)(dy = threat.field_70163_u - (double)this.field_145848_d - 1.0), (double)(dz2 = threat.field_70161_v - (double)this.field_145849_e - 0.5))) >= (double)this.getRange() - 1.5) {
                double v = 1.0;
                threat.field_70159_w = v * dx / dd;
                threat.field_70181_x = v * dy / dd;
                threat.field_70179_y = v * dz2 / dd;
                threat.field_70133_I = true;
                this.tickcount = 0;
            }
            if (threat instanceof EntityArrow) {
                if (threat.field_70159_w != 0.0 || threat.field_70179_y != 0.0) {
                    world.func_72908_a(x, y, z, "random.bowhit", 1.0f, 1.0f);
                }
                threat.field_70125_A = -90.0f;
                threat.field_70159_w = 0.0;
                if (threat.field_70181_x > 0.0) {
                    threat.field_70181_x = 0.0;
                }
                threat.field_70179_y = 0.0;
                this.tickcount = 0;
            }
            if (threat instanceof EntityTNTPrimed) {
                threat.func_70106_y();
                if (!world.field_72995_K) {
                    world.func_72876_a(null, x, y, z, 4.0f, true);
                }
                this.tickcount = 0;
            }
            if (ModExplosiveHandler.getInstance().isModExplosive(threat)) {
                threat.func_70106_y();
                if (!world.field_72995_K) {
                    world.func_72876_a(null, x, y, z, 4.0f, true);
                }
                this.tickcount = 0;
            }
            if (InterfaceCache.IMISSILE.instanceOf((Object)threat)) {
                ((IMissileEntity)threat).destroyMissile((Object)this, null, 1.0f, false, true, true);
                if (!world.field_72995_K) {
                    world.func_72876_a(null, x, y, z, 4.0f, true);
                }
                this.tickcount = 0;
            }
            if (threat instanceof EntityMob || threat instanceof EntityGhast || threat instanceof EntitySlime) {
                boolean mult = true;
                double dx2 = x - (double)this.field_145851_c;
                double dy2 = y - (double)this.field_145848_d;
                dz = z - (double)this.field_145849_e;
                dist = ReikaMathLibrary.py3d((double)dx2, (double)dy2, (double)dz);
                threat.field_70159_w = (double)mult * dx2 / dist / 10.0;
                if (threat.field_70122_E) {
                    threat.field_70181_x = (double)mult * dy2 / dist / 10.0;
                }
                threat.field_70179_y = (double)mult * dz / dist / 10.0;
                threat.field_70177_z = threat.field_70177_z - 30.0f + (float)rand.nextInt(61);
                threat.field_70133_I = true;
            }
            if (threat instanceof EntityWolf && ((EntityWolf)threat).func_70919_bu()) {
                int mult = 1;
                if (this.isInside(x, y, z)) {
                    mult = -1;
                }
                double dx3 = x - (double)this.field_145851_c;
                double dy3 = y - (double)this.field_145848_d;
                dz = z - (double)this.field_145849_e;
                dist = ReikaMathLibrary.py3d((double)dx3, (double)dy3, (double)dz);
                threat.field_70159_w = (double)mult * dx3 / dist / 15.0;
                if (threat.field_70122_E) {
                    threat.field_70181_x = (double)mult * dy3 / dist / 15.0;
                }
                threat.field_70179_y = (double)mult * dz / dist / 15.0;
                threat.field_70177_z = rand.nextInt(360);
                threat.field_70133_I = true;
            }
            ForceFieldEvent evt = new ForceFieldEvent((TileEntity)this, threat);
            MinecraftForge.EVENT_BUS.post((Event)evt);
            if (evt.getResult() == Event.Result.ALLOW) {
                threat.func_70106_y();
                world.func_72876_a(null, x, y, z, 4.0f, true);
            }
        }
    }

    private boolean isAtBorder(double x, double y, double z) {
        double dx = x - (double)this.field_145851_c - 0.5;
        double dy = y - (double)this.field_145848_d - 0.5;
        double dz = z - (double)this.field_145849_e - 0.5;
        double dist = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
        if (dist > (double)this.getRange()) {
            return false;
        }
        return ReikaMathLibrary.approxr((double)dist, (double)this.getRange(), (double)3.0);
    }

    private boolean isInside(double x, double y, double z) {
        double dx = x - (double)this.field_145851_c;
        double dy = y - (double)this.field_145848_d;
        double dz = z - (double)this.field_145849_e;
        double dist = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
        if (dist > (double)this.getRange()) {
            // empty if block
        }
        return ReikaMathLibrary.approxr((double)dist, (double)this.getRange(), (double)3.0);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("setRange", this.setRange);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.setRange = NBT.func_74762_e("setRange");
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            int lvl;
            if (Enchantment.field_77331_b[i] == null || (lvl = this.getEnchantment(Enchantment.field_77331_b[i])) <= 0) continue;
            NBT.func_74768_a(Enchantment.field_77331_b[i].func_77320_a(), lvl);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.enchantments = new HashMap();
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            if (Enchantment.field_77331_b[i] == null) continue;
            int lvl = NBT.func_74762_e(Enchantment.field_77331_b[i].func_77320_a());
            this.enchantments.put(Enchantment.field_77331_b[i], lvl);
        }
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.FORCEFIELD;
    }

    @Override
    public boolean applyEnchants(ItemStack is) {
        boolean accepted = false;
        if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)Enchantment.field_77332_c, (ItemStack)is)) {
            this.enchantments.put(Enchantment.field_77332_c, ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77332_c, (ItemStack)is));
            accepted = true;
        }
        return accepted;
    }

    @Override
    public ArrayList<Enchantment> getValidEnchantments() {
        ArrayList<Enchantment> li = new ArrayList<Enchantment>();
        li.add(Enchantment.field_77332_c);
        return li;
    }

    @Override
    public HashMap<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    @Override
    public boolean hasEnchantment(Enchantment e) {
        return this.getEnchantments().containsKey(e);
    }

    @Override
    public boolean hasEnchantments() {
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            if (Enchantment.field_77331_b[i] == null || this.getEnchantment(Enchantment.field_77331_b[i]) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getEnchantment(Enchantment e) {
        if (!this.hasEnchantment(e)) {
            return 0;
        }
        return this.getEnchantments().get(e);
    }

    @Override
    public String getParticleType() {
        return "magicCrit";
    }

    @Override
    public int getFallOff() {
        return 32768;
    }
}

