/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Transmission;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Libraries.MathSci.ReikaEngLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.RotaryCraft.API.Event.FlywheelFailureEvent;
import Reika.RotaryCraft.API.Power.PowerGenerator;
import Reika.RotaryCraft.API.Power.PowerTracker;
import Reika.RotaryCraft.API.Power.ShaftMerger;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.Interfaces.SimpleProvider;
import Reika.RotaryCraft.Auxiliary.PowerSourceList;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Auxiliary.ShaftPowerEmitter;
import Reika.RotaryCraft.Auxiliary.TorqueUsage;
import Reika.RotaryCraft.Base.TileEntity.TileEntityTransmissionMachine;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityPowerBus;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityShaft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntitySplitter;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Collection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFlywheel
extends TileEntityTransmissionMachine
implements SimpleProvider,
PowerGenerator,
ShaftMerger {
    public static final int MINTORQUERATIO = 4;
    private int decayTime;
    private int maxtorque;
    public boolean failed = false;
    private int soundtick = 0;
    private int lasttorque;
    private int oppTorque = 0;
    private int updateticks = 0;

    public int getOppTorque(TileEntityFlywheel reading) {
        if (reading.getTypeOrdinal().ordinal() < this.getTypeOrdinal().ordinal()) {
            return this.getMinTorque() * 4;
        }
        return this.omega < this.omegain - this.omegain / 20 ? this.torque + this.oppTorque : this.oppTorque;
    }

    public int getMinTorque() {
        return this.getTypeOrdinal().getMinTorque();
    }

    public void testFailure() {
        double factor = 0.25 * Math.sqrt(this.omega);
        switch (this.getTypeOrdinal().ordinal()) {
            case 1: {
                factor /= 2.5;
            }
            case 3: {
                factor *= 1.25;
            }
        }
        factor *= ReikaMathLibrary.doubpow((double)((double)this.omega / 65536.0), (double)1.5);
        double energy = ReikaEngLibrary.rotenergy((double)this.getDensity(), (double)0.25, (double)this.omega, (double)0.75);
        if (ReikaEngLibrary.mat_rotfailure((double)this.getDensity(), (double)0.75, (double)this.omega, (double)(100.0 * this.getStrength()))) {
            this.fail(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, energy / factor);
        }
    }

    private void fail(World world, int x, int y, int z, double e) {
        this.failed = true;
        float f = ReikaPhysicsHelper.getExplosionFromEnergy((double)e);
        if (!world.field_72995_K) {
            world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, f, ConfigRegistry.BLOCKDAMAGE.getState());
        }
        MinecraftForge.EVENT_BUS.post((Event)new FlywheelFailureEvent((TileEntity)this, f));
    }

    private double getDensity() {
        return this.getTypeOrdinal().density;
    }

    private Flywheels getTypeOrdinal() {
        return Flywheels.list[this.func_145832_p() / 4];
    }

    private double getStrength() {
        return this.getTypeOrdinal().tensileStrength;
    }

    public int frictionLosses(int speed) {
        int fric = 0;
        return speed * fric;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getType(meta / 4);
        this.getIOSides(world, x, y, z, meta % 4);
        if (this.failed) {
            this.omega = 0;
            this.torque = 0;
            this.power = 0L;
            return;
        }
        if (this.read != null && this.write != null) {
            this.process(world, x, y, z);
        }
        this.power = this.omega * this.torque;
        this.testFailure();
        this.playSounds();
        this.basicPowerReceiver();
    }

    private void playSounds() {
        if (this.omega == 0) {
            this.soundtick = 20000;
            return;
        }
        float pitch = (float)Math.sqrt((float)this.omega / 1024.0f);
        if (pitch == 0.0f) {
            pitch = 0.01f;
        }
        ++this.soundtick;
        if ((float)this.soundtick < -3.0f / (pitch * pitch) + 69.0f / pitch) {
            return;
        }
        this.soundtick = 0;
        SoundRegistry.FLYWHEEL.playSoundAtBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, RotaryAux.isMuffled((TileEntity)this) ? 0.3f : 1.0f, pitch);
    }

    public void getType(int meta) {
        this.maxtorque = this.getTypeOrdinal().maxTorque;
        this.decayTime = this.getTypeOrdinal().decayTime;
    }

    public void getIOSides(World world, int x, int y, int z, int metadata) {
        switch (metadata % 4) {
            case 0: {
                this.read = ForgeDirection.WEST;
                break;
            }
            case 1: {
                this.read = ForgeDirection.EAST;
                break;
            }
            case 2: {
                this.read = ForgeDirection.NORTH;
                break;
            }
            case 3: {
                this.read = ForgeDirection.SOUTH;
            }
        }
        this.write = this.read.getOpposite();
    }

    public void process(World world, int x, int y, int z) {
        WorldRift sr;
        WorldLocation loc;
        TileEntity te;
        this.omegain = 0;
        ++this.tickcount;
        boolean isCentered = x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e;
        int dx = x + this.read.offsetX;
        int dy = y + this.read.offsetY;
        int dz = z + this.read.offsetZ;
        MachineRegistry m = isCentered ? this.getMachine(this.read) : MachineRegistry.getMachine((IBlockAccess)world, dx, dy, dz);
        TileEntity tileEntity = te = isCentered ? this.getAdjacentTileEntity(this.read) : world.func_147438_o(dx, dy, dz);
        if (this.isProvider(te)) {
            ShaftPowerEmitter sp;
            TileEntityTransmissionMachine devicein;
            if (m == MachineRegistry.SHAFT) {
                devicein = (TileEntityShaft)te;
                if (((TileEntityShaft)devicein).isCross()) {
                    this.omegain = this.readFromCross((TileEntityShaft)devicein, false);
                    this.torquein = this.readFromCross((TileEntityShaft)devicein, true);
                } else if (devicein.isWritingTo(this)) {
                    this.omegain = ((TileEntityShaft)devicein).omega;
                    this.torquein = ((TileEntityShaft)devicein).torque;
                }
            }
            if (te instanceof SimpleProvider) {
                this.copyStandardPower(te);
            }
            if (m == MachineRegistry.POWERBUS) {
                TileEntityPowerBus pwr = (TileEntityPowerBus)te;
                ForgeDirection dir = this.getInputForgeDirection().getOpposite();
                this.omegain = pwr.getSpeedToSide(dir);
                this.torquein = pwr.getTorqueToSide(dir);
            }
            if (te instanceof ShaftPowerEmitter && (sp = (ShaftPowerEmitter)te).isEmitting() && sp.canWriteTo(this.read.getOpposite())) {
                this.torquein = sp.getTorque();
                this.omegain = sp.getOmega();
            }
            if (m == MachineRegistry.SPLITTER) {
                devicein = (TileEntitySplitter)te;
                if (((TileEntitySplitter)devicein).isSplitting()) {
                    int om = this.omega;
                    int tq = this.torque;
                    this.readFromSplitter(world, x, y, z, (TileEntitySplitter)devicein);
                    this.omegain = this.omega;
                    this.torquein = this.torque;
                    this.omega = om;
                    this.torque = tq;
                    return;
                }
                if (devicein.isWritingTo(this)) {
                    this.omegain = ((TileEntitySplitter)devicein).omega;
                    this.torquein = ((TileEntitySplitter)devicein).torque;
                }
            }
        } else if (te instanceof WorldRift && (loc = (sr = (WorldRift)te).getLinkTarget()) != null) {
            this.process(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord);
        }
        double r = 0.75;
        double h = 0.4;
        double iner = h * r * r * Math.PI * this.getDensity() * r * r / 2.0;
        this.updateticks = 0;
        if (this.torquein >= this.getMinTorque()) {
            this.oppTorque = TorqueUsage.getTorque(this);
            if (this.oppTorque <= this.torquein) {
                if (this.omega <= this.omegain) {
                    if ((double)(this.torquein - this.oppTorque) / iner < 1.0 && this.torquein - this.oppTorque > 0) {
                        int i = 1;
                        while (((double)this.torquein - (double)this.oppTorque) / iner * (double)i < 1.0) {
                            ++i;
                        }
                        this.updateticks = i;
                        if (this.tickcount % this.updateticks == 0) {
                            ++this.omega;
                            this.tickcount = 0;
                        }
                    } else {
                        this.omega = (int)((double)this.omega + (double)(this.torquein - this.oppTorque) / iner);
                    }
                    if (this.omega > this.omegain) {
                        this.omega = this.omegain;
                    }
                } else if ((double)(this.torquein + this.oppTorque) / iner < 1.0) {
                    int i = 1;
                    while (((double)this.torquein + (double)this.oppTorque) / iner * (double)i < 1.0) {
                        ++i;
                    }
                    this.updateticks = i;
                    if (this.tickcount % this.updateticks == 0) {
                        --this.omega;
                        this.tickcount = 0;
                    }
                } else {
                    this.omega = (int)Math.max(0.0, (double)this.omega - (double)(this.torquein + this.oppTorque) / iner);
                }
                this.torque = Math.min(this.torquein, this.maxtorque);
            } else {
                if ((double)(this.oppTorque - this.torquein) / iner < 1.0) {
                    int i = 1;
                    while ((double)(this.oppTorque - this.torquein) / iner * (double)i < 1.0) {
                        ++i;
                    }
                    this.updateticks = i;
                    if (this.tickcount % this.updateticks == 0) {
                        --this.omega;
                        this.tickcount = 0;
                    }
                } else {
                    this.omega = (int)Math.max(0.0, (double)this.omega - (double)(this.oppTorque - this.torquein) / iner);
                }
                if (this.omega < 0) {
                    this.omega = 0;
                }
            }
        } else if (this.omega == 0) {
            this.torque = 0;
            this.tickcount = 0;
        } else {
            this.oppTorque = TorqueUsage.getTorque(this);
            if ((double)this.oppTorque / iner < 1.0 && this.oppTorque > 0) {
                int i = 1;
                while ((double)this.oppTorque / iner * (double)i < 1.0) {
                    ++i;
                }
                this.updateticks = i;
                if (this.tickcount % this.updateticks == 0) {
                    --this.omega;
                }
            } else {
                this.omega = (int)Math.max(0.0, (double)this.omega - (double)this.oppTorque / iner);
            }
            if (this.omega < 0) {
                this.omega = 0;
            }
        }
        if (this.omega <= 0) {
            this.torque = 0;
        }
    }

    private void decrSpeed() {
        if (this.omega > 0 && this.tickcount >= this.decayTime) {
            --this.omega;
            this.tickcount = 0;
        }
    }

    public int readFromCross(TileEntityShaft cross, boolean isTorque) {
        if (cross.isWritingTo(this)) {
            if (isTorque) {
                return cross.readtorque[0];
            }
            return cross.readomega[0];
        }
        if (cross.isWritingTo2(this)) {
            if (isTorque) {
                return cross.readtorque[1];
            }
            return cross.readomega[1];
        }
        return 0;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("failed", this.failed);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.failed = NBT.func_74767_n("failed");
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.FLYWHEEL;
    }

    public int getRedstoneOverride() {
        return 15 * this.omega / this.getTypeOrdinal().maxSpeed;
    }

    @Override
    public void onEMP() {
    }

    @Override
    public PowerSourceList getPowerSources(PowerSourceTracker io, ShaftMerger caller) {
        PowerSourceList pwr = new PowerSourceList();
        pwr.addAll(PowerSourceList.getAllFrom(this.field_145850_b, this.read, this.field_145851_c + this.read.offsetX, this.field_145848_d + this.read.offsetY, this.field_145849_e + this.read.offsetZ, this, caller));
        if (pwr.isEmpty()) {
            pwr.addSource(this);
        }
        return pwr;
    }

    @Override
    public long getMaxPower() {
        return this.maxtorque * this.omega;
    }

    @Override
    public long getCurrentPower() {
        return this.power;
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public int getEmittingX() {
        return this.field_145851_c + this.write.offsetX;
    }

    @Override
    public int getEmittingY() {
        return this.field_145848_d + this.write.offsetY;
    }

    @Override
    public int getEmittingZ() {
        return this.field_145849_e + this.write.offsetZ;
    }

    @Override
    public void onPowerLooped(PowerTracker pwr) {
        this.torque = 0;
        this.omega = 0;
        this.power = 0L;
    }

    @Override
    public void getAllOutputs(Collection<TileEntity> c, ForgeDirection dir) {
        if (dir == this.read) {
            c.add(this.getAdjacentTileEntity(this.write));
        }
    }

    @Override
    public void fail() {
        this.fail(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ReikaPhysicsHelper.getEnergyFromExplosion((float)4.0f));
    }

    @Override
    public final int getItemMetadata() {
        return this.getTypeOrdinal().ordinal();
    }

    public static enum Flywheels {
        WOOD(16, 2, 800.0, 2.0E7),
        STONE(128, 5, 3000.0, 9.0E7),
        IRON(512, 15, 7800.0, 1.0E9),
        GOLD(4096, 40, 19300.0, 1.08E8);

        public final int maxTorque;
        public final int maxSpeed;
        public final int decayTime;
        public final double density;
        public final double tensileStrength;
        public static final Flywheels[] list;

        private Flywheels(int t, int dec, double rho, double str) {
            this.maxTorque = t;
            this.tensileStrength = str;
            this.decayTime = dec;
            this.density = rho;
            this.maxSpeed = this.getLimitLoad();
        }

        private int getLimitLoad() {
            double r = 0.75;
            double s = 100.0 * this.tensileStrength;
            double frac = 2.0 * s / (this.density * r * r);
            double base = Math.sqrt(frac);
            return (int)base;
        }

        public int getMinTorque() {
            return this.maxTorque / 4;
        }

        static {
            list = Flywheels.values();
        }
    }
}

