/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities;

import Reika.DragonAPI.Base.OneSlotMachine;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.RotaryCraft.API.Interfaces.TensionStorage;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Auxiliary.Interfaces.SimpleProvider;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.DifficultyEffects;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileEntityWinder
extends InventoriedPowerReceiver
implements OneSlotMachine,
SimpleProvider,
DiscreteFunction,
ConditionalOperation {
    public boolean winding = true;

    public final int getUnwindTorque() {
        if (this.inv[0] == null) {
            return 0;
        }
        return 8 * ((TensionStorage)this.inv[0].func_77973_b()).getPowerScale(this.inv[0]);
    }

    public final int getUnwindSpeed() {
        if (this.inv[0] == null) {
            return 0;
        }
        return 1024 * ((TensionStorage)this.inv[0].func_77973_b()).getPowerScale(this.inv[0]);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return j == 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSidesDefault(world, x, y, z, meta);
        this.getPower(false);
        if (!this.winding) {
            this.write = this.read;
            this.read = null;
        }
        ++this.tickcount;
        if (this.inv[0] == null) {
            if (!this.winding) {
                this.torque = 0;
                this.omega = 0;
            }
            return;
        }
        if (!(this.inv[0].func_77973_b() instanceof TensionStorage)) {
            if (!this.winding) {
                this.torque = 0;
                this.omega = 0;
            }
            return;
        }
        if (this.winding) {
            if (this.tickcount < this.getOperationTime()) {
                return;
            }
            this.tickcount = 0;
            if (this.inv[0].func_77960_j() >= this.getMaxWind()) {
                return;
            }
            this.inv[0] = new ItemStack(this.inv[0].func_77973_b(), 1, this.inv[0].func_77960_j() + 1);
            if (!world.field_72995_K && this.breakCoil()) {
                this.inv[0] = null;
                world.func_72908_a((double)x, (double)y, (double)z, "random.break", 1.0f, 1.0f);
            }
        } else {
            if (this.inv[0].func_77960_j() <= 0) {
                this.omega = 0;
                this.torque = 0;
                this.power = 0L;
                return;
            }
            this.omega = this.getUnwindSpeed();
            this.torque = this.getUnwindTorque();
            this.power = (long)this.omega * (long)this.torque;
            if (this.tickcount < this.getUnwindTime()) {
                return;
            }
            this.tickcount = 0;
            this.inv[0] = new ItemStack(this.inv[0].func_77973_b(), 1, this.inv[0].func_77960_j() - 1);
        }
    }

    protected final int getUnwindTime() {
        ItemStack is = this.inv[0];
        int base = 20;
        return base * ((TensionStorage)is.func_77973_b()).getStiffness(is);
    }

    private boolean breakCoil() {
        ItemStack is = this.inv[0];
        if (is == null) {
            return false;
        }
        if (!(is.func_77973_b() instanceof TensionStorage)) {
            return false;
        }
        TensionStorage ts = (TensionStorage)is.func_77973_b();
        if (!ts.isBreakable(is)) {
            return false;
        }
        int dmg = this.inv[0].func_77960_j();
        double diff = (double)dmg / 65536.0 * DifficultyEffects.BREAKCOIL.getDouble();
        boolean rand = ReikaRandomHelper.doWithChance((double)diff);
        return rand;
    }

    @Override
    public int getOperationTime() {
        if (this.inv[0] == null) {
            return 1;
        }
        int base = (int)ReikaMathLibrary.logbase((long)this.inv[0].func_77960_j(), (int)2);
        double factor = 1.0 / (double)((int)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2));
        return (int)((double)base * factor);
    }

    public int getMaxWind() {
        if (this.inv[0] == null) {
            return 0;
        }
        if (!(this.inv[0].func_77973_b() instanceof TensionStorage)) {
            return 0;
        }
        Item id = this.inv[0].func_77973_b();
        int max = this.torque / ((TensionStorage)this.inv[0].func_77973_b()).getStiffness(this.inv[0]);
        if (max > ItemRegistry.SPRING.getNumberMetadatas()) {
            return ItemRegistry.SPRING.getNumberMetadatas();
        }
        return max;
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.winding = NBT.func_74767_n("winding");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("winding", this.winding);
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public boolean canProvidePower() {
        return !this.winding;
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.WINDER;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        if (is.func_77973_b() == ItemRegistry.SPRING.getItemInstance()) {
            return true;
        }
        return is.func_77973_b() == ItemRegistry.STRONGCOIL.getItemInstance();
    }

    public int getRedstoneOverride() {
        if (this.inv[0] == null) {
            return 15;
        }
        if (this.inv[0].func_77973_b() != ItemRegistry.SPRING.getItemInstance()) {
            return 15;
        }
        if (this.inv[0].func_77960_j() >= this.torque && this.winding) {
            return 15;
        }
        return 0;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public void onEMP() {
    }

    @Override
    public boolean areConditionsMet() {
        return this.inv[0] != null && this.inv[0].func_77973_b() instanceof TensionStorage;
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "No Coil";
    }
}

