/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Surveying;

import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.RotaryCraft.Base.TileEntity.RemoteControlMachine;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class TileEntityCCTV
extends RemoteControlMachine {
    public boolean cameraIsMoved = false;
    private double[] playerCam = new double[5];
    private double[] cameraPos = new double[5];
    public String owner;
    public EntityPlayer clicked;
    public float theta;
    public static final boolean ISCAMERAMODE = true;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.theta > 60.0f) {
            this.theta = -60.0f;
        }
        if (this.theta < -60.0f) {
            this.theta = 60.0f;
        }
        if (this.theta > 0.0f) {
            this.setBlockMetadata(1);
        }
        if (this.theta < 0.0f) {
            this.setBlockMetadata(0);
        }
        this.setColors();
        if (!this.hasCoil()) {
            this.on = false;
            return;
        }
        ++this.tickcount2;
        if (this.tickcount2 > this.getUnwindTime()) {
            ItemStack is;
            this.inv[0] = is = this.getDecrementedCharged();
            this.tickcount2 = 0;
        }
        EntityPlayer e = world.func_72924_a(this.owner);
        this.on = true;
        if (this.cameraIsMoved) {
            this.movePlayerToCamera(e);
            ++this.tickcount;
        }
        double[] dd = ReikaPhysicsHelper.polarToCartesian((double)1.0, (double)this.theta, (double)this.phi);
        if (this.tickcount < 20) {
            // empty if block
        }
        if (!this.cameraIsMoved) {
            return;
        }
        if (!Keyboard.isKeyDown((int)43) && this.inv[0] != null && this.inv[0].func_77973_b() == ItemRegistry.SPRING.getItemInstance() && this.inv[0].func_77960_j() > 0) {
            return;
        }
        this.tickcount = 0;
        this.movePlayerBack(e);
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public void setLook(double x, double y, double z, double t, double p) {
        this.cameraPos[0] = x;
        this.cameraPos[1] = y;
        this.cameraPos[2] = z;
        this.cameraPos[3] = t;
        this.cameraPos[4] = p;
    }

    public void moveCameraToLook(EntityPlayer ep) {
        if (!this.on) {
            return;
        }
        this.clicked = ep;
        if (!this.cameraIsMoved) {
            this.setPlayerCam();
        }
        this.cameraIsMoved = true;
        this.alignCameras(false);
    }

    private void setPlayerCam() {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityLivingBase e = mc.field_71451_h;
        if (e == null) {
            return;
        }
        this.playerCam[0] = e.field_70165_t;
        this.playerCam[1] = e.field_70163_u;
        this.playerCam[2] = e.field_70161_v;
        this.playerCam[3] = e.field_70177_z;
        while (this.playerCam[3] < 0.0) {
            this.playerCam[3] = this.playerCam[3] + 360.0;
        }
        while (this.playerCam[3] >= 360.0) {
            this.playerCam[3] = this.playerCam[3] - 360.0;
        }
        this.playerCam[4] = e.field_70125_A;
    }

    public void moveCameraToPlayer() {
        for (int i = 0; i < 5; ++i) {
            this.cameraPos[i] = this.playerCam[i];
        }
        this.cameraIsMoved = false;
        this.alignCameras(true);
    }

    private void alignCameras(boolean toPlayer) {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityLivingBase e = mc.field_71451_h;
        if (toPlayer) {
            e.field_70165_t = this.playerCam[0];
            e.field_70163_u = this.playerCam[1] + (double)e.func_70047_e();
            e.field_70161_v = this.playerCam[2];
            e.field_70177_z = (float)this.playerCam[3];
            e.field_70125_A = (float)this.playerCam[4];
        } else {
            e.field_70165_t = this.cameraPos[0];
            e.field_70163_u = this.cameraPos[1];
            e.field_70161_v = this.cameraPos[2];
            e.field_70177_z = (float)this.cameraPos[3];
            e.field_70125_A = (float)this.cameraPos[4];
        }
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.CCTV;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.theta = NBT.func_74760_g("thetad");
        this.owner = NBT.func_74779_i("sowner");
        this.cameraIsMoved = NBT.func_74767_n("moved");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (this.owner != null && !this.owner.isEmpty()) {
            NBT.func_74778_a("sowner", this.owner);
        }
        NBT.func_74776_a("thetad", this.theta);
        NBT.func_74757_a("moved", this.cameraIsMoved);
    }

    public int getRedstoneOverride() {
        return 0;
    }

    private void movePlayerToCamera(EntityPlayer ep) {
        if (ep == null) {
            return;
        }
        this.cameraIsMoved = true;
        double[] dd = ReikaPhysicsHelper.polarToCartesian((double)1.0, (double)this.theta, (double)this.phi);
        double dx = 0.5 + dd[2];
        double dy = 0.25 - dd[1] - (double)ep.func_70047_e();
        double dz = 0.40625 + dd[0];
        this.playerCam[0] = ep.field_70165_t;
        this.playerCam[1] = ep.field_70163_u;
        this.playerCam[2] = ep.field_70161_v;
        this.playerCam[3] = ep.field_70177_z;
        this.playerCam[4] = ep.field_70125_A;
        ep.field_70165_t = (double)this.field_145851_c + dx;
        ep.field_70163_u = (double)this.field_145848_d + dy;
        ep.field_70161_v = (double)this.field_145849_e + dz;
        ep.field_70177_z = -this.phi;
        ep.field_70125_A = this.theta;
        this.owner = ep.func_70005_c_();
        ep.field_71075_bZ.field_75099_e = false;
        ep.field_71075_bZ.field_75102_a = true;
    }

    private void movePlayerBack(EntityPlayer ep) {
        this.cameraIsMoved = false;
        ep.field_70165_t = this.playerCam[0];
        ep.field_70163_u = this.playerCam[1];
        ep.field_70161_v = this.playerCam[2];
        ep.field_70177_z = (float)this.playerCam[3];
        ep.field_70125_A = (float)this.playerCam[4];
    }

    @Override
    public void activate(World world, EntityPlayer ep, int x, int y, int z) {
        this.movePlayerToCamera(ep);
    }
}

