/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Production;

import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaBiomeHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.AtmosphereHandler;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Base.TileEntity.PoweredLiquidProducer;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Piping.TileEntityPipe;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityAggregator
extends PoweredLiquidProducer
implements TemperatureTE {
    public static final int CAPACITY = 128000;
    private StepTimer timer = new StepTimer(20);
    private int temperature;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getPowerBelow();
        this.timer.update();
        if (this.timer.checkCap()) {
            this.updateTemperature(world, x, y, z, meta);
        }
        if (!this.tank.isEmpty()) {
            this.dumpLiquid(world, x, y, z);
        }
        if (this.power < this.MINPOWER || this.omega < this.MINSPEED) {
            return;
        }
        if (this.tank.isFull()) {
            return;
        }
        if (this.temperature >= this.getMaxTemperature()) {
            return;
        }
        if (AtmosphereHandler.isNoAtmo((World)world, (int)x, (int)y, (int)z, (Block)this.field_145854_h, (boolean)false)) {
            return;
        }
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        if (this.temperature < Tamb) {
            BiomeGenBase biome = world.func_72807_a(x, z);
            int amt = this.getProductionPerTick(biome);
            this.tank.addLiquid(amt, FluidRegistry.WATER);
        }
    }

    private void dumpLiquid(World world, int x, int y, int z) {
        for (int i = 2; i < 6; ++i) {
            IFluidHandler ifl;
            int added;
            ForgeDirection dir = this.dirs[i];
            TileEntity te = this.getAdjacentTileEntity(dir);
            if (te instanceof TileEntityPipe) {
                TileEntityPipe p = (TileEntityPipe)te;
                int dL = (this.tank.getLevel() - p.getFluidLevel()) / 4;
                if (dL <= 0 || p.getFluidType() != null && !this.tank.getActualFluid().equals(p.getFluidType())) continue;
                p.setFluid(this.tank.getActualFluid());
                p.addFluid(dL);
                this.tank.removeLiquid(dL);
                continue;
            }
            if (!(te instanceof IFluidHandler) || (added = (ifl = (IFluidHandler)te).fill(dir.getOpposite(), this.tank.getFluid(), true)) <= 0) continue;
            this.tank.removeLiquid(added);
            if (!this.tank.isEmpty()) continue;
            return;
        }
    }

    public int getProductionPerTick(BiomeGenBase biome) {
        if (this.omega < this.MINSPEED || this.power < this.MINPOWER) {
            return 0;
        }
        int n = Math.max(1, this.getOriginalOperationTime());
        return this.getOriginalWaterProduced(biome) / n;
    }

    private int getOriginalOperationTime() {
        return Math.max(0, (int)(80.0 - 5.0 * ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2)));
    }

    private int getOriginalWaterProduced(BiomeGenBase biome) {
        return Math.max(2, (int)((float)(this.torque * this.torque) * ReikaBiomeHelper.getBiomeHumidity((BiomeGenBase)biome)));
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.AGGREGATOR;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 15 * this.tank.getLevel() / this.tank.getCapacity();
    }

    public int getWater() {
        return this.tank.getLevel();
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public boolean canOutputTo(ForgeDirection to) {
        return to.offsetY == 0;
    }

    @Override
    public int getCapacity() {
        return 128000;
    }

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        int dT = Tamb - this.temperature;
        this.temperature += dT / 4;
    }

    @Override
    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public int getThermalDamage() {
        return 0;
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
    }

    @Override
    public boolean canBeCooledWithFins() {
        return true;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    @Override
    public int getMaxTemperature() {
        return 100;
    }

    @Override
    public boolean allowExternalHeating() {
        return true;
    }
}

