/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Engine;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import Reika.RotaryCraft.RotaryCraft;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class TileEntityPerformanceEngine
extends TileEntityEngine {
    public int additives;
    private boolean starvedengine;

    @Override
    public int getMaxTemperature() {
        return 240;
    }

    @Override
    protected void consumeFuel() {
        this.fuel.removeLiquid(this.getConsumedFuel());
        if (rand.nextInt(30) == 0 && this.additives > 0) {
            --this.additives;
        }
    }

    @Override
    protected void internalizeFuel() {
        Item id;
        if (this.inv[0] != null && this.fuel.getLevel() + 1000 < 240000 && this.inv[0].func_77973_b() == ItemRegistry.ETHANOL.getItemInstance()) {
            ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
            this.fuel.addLiquid(1000, (Fluid)RotaryCraft.ethanolFluid);
        }
        if (this.inv[1] != null && this.additives < 240 && ((id = this.inv[1].func_77973_b()) == Items.field_151065_br || id == Items.field_151137_ax || id == Items.field_151016_H)) {
            ReikaInventoryHelper.decrStack((int)1, (ItemStack[])this.inv);
            if (id == Items.field_151137_ax) {
                ++this.additives;
            }
            if (id == Items.field_151016_H) {
                this.additives += 2;
            }
            if (id == Items.field_151065_br) {
                this.additives += 4;
            }
        }
    }

    @Override
    protected boolean getRequirements(World world, int x, int y, int z, int meta) {
        if (this.fuel.isEmpty()) {
            return false;
        }
        this.starvedengine = this.additives <= 0;
        return true;
    }

    @Override
    protected void playSounds(World world, int x, int y, int z, float pitchMultiplier, float volume) {
        ++this.soundtick;
        if (this.isMuffled(world, x, y, z)) {
            volume *= 0.3125f;
        }
        if (this.soundtick < this.getSoundLength(1.0f / pitchMultiplier) && this.soundtick < 2000) {
            return;
        }
        this.soundtick = 0;
        SoundRegistry.CAR.playSoundAtBlock(world, x, y, z, 0.33f * volume, 0.9f * pitchMultiplier);
    }

    @Override
    protected void offlineCooldown(World world, int x, int y, int z, int Tamb) {
        this.temperature = this.temperature > Tamb + 300 ? (this.temperature -= (this.temperature - Tamb) / 100) : (this.temperature > Tamb + 100 ? (this.temperature -= (this.temperature - Tamb) / 50) : (this.temperature > Tamb + 40 ? (this.temperature -= (this.temperature - Tamb) / 10) : (this.temperature > Tamb + 4 ? (this.temperature -= (this.temperature - Tamb) / 2) : Tamb)));
    }

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        super.updateTemperature(world, x, y, z, meta);
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        if (this.temperature < Tamb) {
            this.temperature += ReikaMathLibrary.extrema((int)((Tamb - this.temperature) / 40), (int)1, (String)"max");
        }
        if (this.omega > 0 && this.torque > 0) {
            ++this.temperature;
            if (this.water.getLevel() > 0 && this.temperature > Tamb) {
                this.water.removeLiquid(20);
                --this.temperature;
            }
            if (this.temperature > this.getMaxTemperature() / 2 && rand.nextInt(10) == 0) {
                world.func_72869_a("smoke", (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 1.0f, 1.0f);
            }
            if ((double)this.temperature > (double)this.getMaxTemperature() / 1.25) {
                if (rand.nextInt(3) == 0) {
                    world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 1.0f, 1.0f);
                }
                world.func_72869_a("smoke", (double)x + 0.0, (double)y + 1.0625, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.func_72869_a("smoke", (double)x + 0.5, (double)y + 1.0625, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.func_72869_a("smoke", (double)(x + 1), (double)y + 1.0625, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.func_72869_a("smoke", (double)x + 0.0, (double)y + 1.0625, (double)(z + 0), 0.0, 0.0, 0.0);
                world.func_72869_a("smoke", (double)x + 0.0, (double)y + 1.0625, (double)(z + 1), 0.0, 0.0, 0.0);
                world.func_72869_a("smoke", (double)(x + 1), (double)y + 1.0625, (double)(z + 0), 0.0, 0.0, 0.0);
                world.func_72869_a("smoke", (double)(x + 1), (double)y + 1.0625, (double)(z + 1), 0.0, 0.0, 0.0);
            }
        }
        if (this.temperature > this.getMaxTemperature()) {
            this.overheat(world, x, y, z);
        }
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
        this.temperature = this.getMaxTemperature();
        ReikaWorldHelper.overheat((World)world, (int)x, (int)y, (int)z, (ItemStack)ItemStacks.scrap.func_77946_l(), (int)0, (int)27, (boolean)true, (float)1.5f, (boolean)true, (boolean)ConfigRegistry.BLOCKDAMAGE.getState(), (float)6.0f);
        world.func_147468_f(x, y, z);
    }

    @Override
    public int getFuelLevel() {
        return this.fuel.getLevel();
    }

    public int getAdditivesScaled(int par1) {
        return this.additives * par1 * 1000 / 240000;
    }

    @Override
    protected int getMaxSpeed(World world, int x, int y, int z, int meta) {
        return this.starvedengine ? EngineType.GAS.getSpeed() : EngineType.SPORT.getSpeed();
    }

    @Override
    protected int getGenTorque(World world, int x, int y, int z, int meta) {
        return this.starvedengine ? EngineType.GAS.getTorque() : EngineType.SPORT.getTorque();
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (this.type.usesAdditives()) {
            NBT.func_74768_a("additive", this.additives);
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        if (this.type.usesAdditives()) {
            this.additives = NBT.func_74762_e("additive");
        }
    }

    @Override
    protected void affectSurroundings(World world, int x, int y, int z, int meta) {
    }
}

