/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Renders;

import Reika.DragonAPI.Instantiable.Effects.Glow;
import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.RotaryCraft.Auxiliary.HeatRippleRenderer;
import Reika.RotaryCraft.Auxiliary.IORenderer;
import Reika.RotaryCraft.Auxiliary.Interfaces.AlternatingRedstoneUser;
import Reika.RotaryCraft.Auxiliary.Interfaces.RedstoneUpgradeable;
import Reika.RotaryCraft.Base.RotaryTERenderer;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Models.Engine.ModelAC;
import Reika.RotaryCraft.Models.Engine.ModelCombustion;
import Reika.RotaryCraft.Models.Engine.ModelDC;
import Reika.RotaryCraft.Models.Engine.ModelHydro;
import Reika.RotaryCraft.Models.Engine.ModelJet;
import Reika.RotaryCraft.Models.Engine.ModelMicroTurbine;
import Reika.RotaryCraft.Models.Engine.ModelPerformance;
import Reika.RotaryCraft.Models.Engine.ModelSteam;
import Reika.RotaryCraft.Models.Engine.ModelWind;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityHydroEngine;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityJetEngine;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderSEngine
extends RotaryTERenderer {
    private ModelDC DCModel = new ModelDC();
    private ModelSteam SteamModel = new ModelSteam();
    private ModelCombustion CombModel = new ModelCombustion();
    private ModelAC ACModel = new ModelAC();
    private ModelPerformance PerfModel = new ModelPerformance();
    private ModelMicroTurbine MicroModel = new ModelMicroTurbine();
    private ModelJet JetModel = new ModelJet();
    private ModelHydro HydroModel = new ModelHydro();
    private ModelWind WindModel = new ModelWind();
    private static final Glow jetGlow = new Glow(255, 150, 20, 192).setScale(0.4);

    public void renderTileEntityEngineAt(TileEntityEngine tile, double par2, double par4, double par6, float par8) {
        if (!tile.isInWorld()) {
            boolean var9 = false;
        } else {
            int var9 = tile.func_145832_p();
        }
        ModelDC var14 = this.DCModel;
        ModelSteam var15 = this.SteamModel;
        ModelCombustion var16 = this.CombModel;
        ModelAC var17 = this.ACModel;
        ModelPerformance var18 = this.PerfModel;
        ModelMicroTurbine var19 = this.MicroModel;
        ModelJet var20 = this.JetModel;
        ModelHydro var21 = this.HydroModel;
        ModelWind var22 = this.WindModel;
        switch (tile.getEngineType()) {
            case DC: {
                this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/dc.png");
                break;
            }
            case WIND: {
                this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/windtex.png");
                break;
            }
            case STEAM: {
                this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/steamtex.png");
                break;
            }
            case GAS: {
                this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/combtex.png");
                break;
            }
            case AC: {
                this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/actex.png");
                break;
            }
            case SPORT: {
                this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/perftex.png");
                break;
            }
            case HYDRO: {
                TileEntityHydroEngine eng = (TileEntityHydroEngine)tile;
                String sg = "/Reika/RotaryCraft/Textures/TileEntityTex/" + (eng.isBedrock() ? "bedhydrotex.png" : "hydrotex.png");
                this.bindTextureByName(sg);
                break;
            }
            case MICRO: {
                this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/microtex.png");
                break;
            }
            case JET: {
                String s;
                String string = s = ((TileEntityJetEngine)tile).canAfterBurn() ? "_b" : "";
                if (tile.isInWorld()) {
                    // empty if block
                }
                this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/jettex" + s + ".png");
            }
        }
        this.setupGL(tile, par2, par4, par6);
        int var11 = 0;
        if (tile.isInWorld()) {
            switch (tile.func_145832_p()) {
                case 0: {
                    var11 = 0;
                    break;
                }
                case 1: {
                    var11 = 180;
                    break;
                }
                case 2: {
                    var11 = 90;
                    break;
                }
                case 3: {
                    var11 = 270;
                }
            }
            if (tile.getEngineType().isJetFueled()) {
                var11 += 90;
            }
        } else {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            switch (tile.getEngineType()) {
                case DC: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/dc.png");
                    var14.renderAll((TileEntity)tile, null);
                    break;
                }
                case WIND: {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    double s = 0.7;
                    double d = 0.375;
                    GL11.glScaled((double)s, (double)s, (double)s);
                    double d2 = 0.2;
                    GL11.glTranslated((double)0.0, (double)d, (double)0.0);
                    GL11.glTranslated((double)d2, (double)0.0, (double)0.0);
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/windtex.png");
                    var22.renderAll((TileEntity)tile, null);
                    GL11.glTranslated((double)0.0, (double)(-d), (double)0.0);
                    GL11.glTranslated((double)(-d2), (double)0.0, (double)0.0);
                    GL11.glScaled((double)(1.0 / s), (double)(1.0 / s), (double)(1.0 / s));
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case STEAM: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/steamtex.png");
                    var15.renderAll((TileEntity)tile, null);
                    break;
                }
                case GAS: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/combtex.png");
                    var16.renderAll((TileEntity)tile, null);
                    break;
                }
                case AC: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/actex.png");
                    var17.renderAll((TileEntity)tile, null);
                    break;
                }
                case SPORT: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/perftex.png");
                    var18.renderAll((TileEntity)tile, null, Float.MIN_NORMAL, 0.0f);
                    break;
                }
                case HYDRO: {
                    TileEntityHydroEngine eng = (TileEntityHydroEngine)tile;
                    String sg = "/Reika/RotaryCraft/Textures/TileEntityTex/" + (eng.isBedrock() ? "bedhydrotex.png" : "hydrotex.png");
                    this.bindTextureByName(sg);
                    double s = 0.7;
                    double d = 0.375;
                    GL11.glTranslated((double)0.0, (double)d, (double)0.0);
                    GL11.glScaled((double)s, (double)s, (double)s);
                    var21.renderAll((TileEntity)tile, ReikaJavaLibrary.makeListFrom((Object[])new Boolean[]{eng.failed, eng.isBedrock()}), 0.0f, 0.0f);
                    GL11.glScaled((double)(1.0 / s), (double)(1.0 / s), (double)(1.0 / s));
                    GL11.glTranslated((double)0.0, (double)(-d), (double)0.0);
                    break;
                }
                case MICRO: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/microtex.png");
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    var19.renderAll((TileEntity)tile, null);
                    break;
                }
                case JET: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/jettex.png");
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    var20.renderAll((TileEntity)tile, null);
                }
            }
            this.closeGL(tile);
            return;
        }
        GL11.glRotatef((float)var11, (float)0.0f, (float)1.0f, (float)0.0f);
        this.prepareShader(tile);
        switch (tile.getEngineType()) {
            case DC: {
                var14.renderAll((TileEntity)tile, null, -tile.phi);
                break;
            }
            case WIND: {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                var22.renderAll((TileEntity)tile, null, -tile.phi);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case STEAM: {
                var15.renderAll((TileEntity)tile, null, -tile.phi);
                break;
            }
            case GAS: {
                var16.renderAll((TileEntity)tile, null, -tile.phi);
                break;
            }
            case AC: {
                var17.renderAll((TileEntity)tile, null, -tile.phi);
                break;
            }
            case SPORT: {
                var18.renderAll((TileEntity)tile, null, -tile.phi);
                break;
            }
            case HYDRO: {
                TileEntityHydroEngine eng = (TileEntityHydroEngine)tile;
                var21.renderAll((TileEntity)tile, ReikaJavaLibrary.makeListFrom((Object[])new Boolean[]{eng.failed, eng.isBedrock()}), -tile.phi, 0.0f);
                break;
            }
            case MICRO: {
                var19.renderAll((TileEntity)tile, null, -tile.phi);
                break;
            }
            case JET: {
                float f = 1.0f;
                var20.renderAll((TileEntity)tile, null, -tile.phi);
                if (!(f > 0.0f)) break;
                int temp = Math.max(tile.temperature - 600, (tile.temperature - 1000) * 5 / 2);
                int c = ReikaPhysicsHelper.getColorForTemperature((int)temp);
                GL11.glPushMatrix();
                GL11.glPushAttrib((int)1048575);
                double s = 1.005;
                ReikaRenderHelper.disableLighting();
                ReikaRenderHelper.disableEntityLighting();
                GL11.glEnable((int)3042);
                GL11.glColor4f((float)((float)ReikaColorAPI.getRed((int)c) / 255.0f), (float)((float)ReikaColorAPI.getGreen((int)c) / 255.0f), (float)((float)ReikaColorAPI.getBlue((int)c) / 255.0f), (float)1.0f);
                ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
                this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/jettex_glow_mask2.png");
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.0, (double)(1.0 - s), (double)((1.0 - s) / 4.0));
                GL11.glScaled((double)s, (double)s, (double)s);
                var20.renderAll((TileEntity)tile, null, -tile.phi);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.0, (double)(s - 1.0), (double)(-(1.0 - s) / 4.0));
                GL11.glScaled((double)(1.0 / s), (double)(1.0 / s), (double)(1.0 / s));
                var20.renderAll((TileEntity)tile, null, -tile.phi);
                GL11.glPopMatrix();
                GL11.glDisable((int)3553);
                Tessellator.field_78398_a.func_78371_b(6);
                Tessellator.field_78398_a.func_78378_d(ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)0.65f));
                Tessellator.field_78398_a.func_78372_c(-0.5f, 0.5625f, -0.45f);
                Tessellator.field_78398_a.func_78377_a(0.5, 0.5, 0.0);
                Tessellator.field_78398_a.func_78377_a(0.3, 0.8, 0.0);
                Tessellator.field_78398_a.func_78377_a(0.7, 0.8, 0.0);
                Tessellator.field_78398_a.func_78377_a(0.8, 0.5, 0.0);
                Tessellator.field_78398_a.func_78377_a(0.7, 0.2, 0.0);
                Tessellator.field_78398_a.func_78377_a(0.3, 0.2, 0.0);
                Tessellator.field_78398_a.func_78377_a(0.2, 0.5, 0.0);
                Tessellator.field_78398_a.func_78377_a(0.3, 0.8, 0.0);
                Tessellator.field_78398_a.func_78372_c(0.5f, -0.5625f, 0.45f);
                Tessellator.field_78398_a.func_78381_a();
                GL11.glPopAttrib();
                GL11.glPopMatrix();
            }
        }
        this.closeGL(tile);
    }

    private void prepareShader(TileEntityEngine tile) {
        if (tile.getEngineType() == EngineType.JET) {
            TileEntityJetEngine te = (TileEntityJetEngine)tile;
            double dx = 0.625 * (double)tile.getWriteDirection().offsetX;
            double dz = 0.625 * (double)tile.getWriteDirection().offsetZ;
            EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)1.0, (double)-0.625);
            double dist = ep.func_70011_f((double)tile.field_145851_c + 0.5 + dx, (double)tile.field_145848_d + 0.5, (double)tile.field_145849_e + 0.5 + dz);
            float f = 0.0f;
            if (te.omega > 0) {
                f = Math.max(f, (float)Math.sqrt((float)te.omega * 0.5f / (float)EngineType.JET.getSpeed()));
            }
            if (te.temperature > 100) {
                f = Math.max(f, Math.min(1.0f, ((float)te.temperature - 100.0f) / ((float)te.getMaxExhaustTemperature() - 100.0f)));
            }
            double dd = 0.25;
            float fac = te.isAfterburning() ? 1.0f : 0.75f;
            for (double d = 0.0; d <= 3.0; d += dd) {
                HeatRippleRenderer.instance.addHeatRippleEffectIfLOS((TileEntity)tile, (double)tile.field_145851_c + 0.5 + (dx += dd * (double)tile.getWriteDirection().offsetX), (double)tile.field_145848_d + 0.5, (double)tile.field_145849_e + 0.5 + (dz += dd * (double)tile.getWriteDirection().offsetZ), (EntityPlayer)ep, dist, f, fac, 1.0f, 1.0f);
                GL11.glTranslated((double)0.0, (double)0.0, (double)(-dd));
                fac = (float)((double)fac * (te.isAfterburning() ? 0.875 : 0.825));
                if ((double)fac <= 0.01) break;
            }
            GL11.glPopMatrix();
        }
    }

    public void func_147500_a(TileEntity tile, double par2, double par4, double par6, float par8) {
        if (this.doRenderModel((RotaryCraftTileEntity)tile)) {
            this.renderTileEntityEngineAt((TileEntityEngine)tile, par2, par4, par6, par8);
        }
        if (tile instanceof RedstoneUpgradeable && ((RotaryCraftTileEntity)tile).isInWorld() && MinecraftForgeClient.getRenderPass() == 0) {
            this.renderRedstoneFrame((TileEntityEngine)tile, par2, par4, par6, par8);
        }
        if (((RotaryCraftTileEntity)tile).isInWorld() && MinecraftForgeClient.getRenderPass() == 1) {
            IORenderer.renderIO(tile, par2, par4, par6);
        }
    }

    private void renderRedstoneFrame(TileEntityEngine tile, double par2, double par4, double par6, float par8) {
        RedstoneUpgradeable ar = (RedstoneUpgradeable)((Object)tile);
        if (!ar.hasRedstoneUpgrade()) {
            return;
        }
        boolean bright = true;
        if (tile instanceof AlternatingRedstoneUser) {
            bright = tile.getTicksExisted() / 3 % 2 == 0;
        }
        int c = bright ? 0xFF0000 : 0x900000;
        int c2 = bright ? 0xFFA7A7 : 0xDA0000;
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par4, (double)par6);
        if (bright) {
            GL11.glDisable((int)2896);
        }
        GL11.glEnable((int)3553);
        double o = 0.005;
        double t = 0.05;
        double p = 0.125;
        double h = tile.isFlipped ? 1.0 - p - o : p + o + t;
        double h2 = tile.isFlipped ? 1.0 - p - o - t : p + o;
        double w = 0.475;
        ReikaTextureHelper.bindTerrainTexture();
        IIcon ico = Blocks.field_150451_bX.field_149761_L;
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float du = ico.func_94212_f();
        float dv = ico.func_94210_h();
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        v5.func_78380_c(240);
        v5.func_78384_a(c, 255);
        if (tile.isFlipped) {
            v5.func_78374_a(0.5 - w, h2, 0.5 - w, (double)u, (double)dv);
            v5.func_78374_a(0.5 + w, h2, 0.5 - w, (double)du, (double)dv);
            v5.func_78374_a(0.5 + w, h2, 0.5 + w, (double)du, (double)v);
            v5.func_78374_a(0.5 - w, h2, 0.5 + w, (double)u, (double)v);
        } else {
            v5.func_78374_a(0.5 - w, h, 0.5 + w, (double)u, (double)v);
            v5.func_78374_a(0.5 + w, h, 0.5 + w, (double)du, (double)v);
            v5.func_78374_a(0.5 + w, h, 0.5 - w, (double)du, (double)dv);
            v5.func_78374_a(0.5 - w, h, 0.5 - w, (double)u, (double)dv);
        }
        v5.func_78374_a(0.5 + w, h2, 0.5 - w, (double)u, (double)v);
        v5.func_78374_a(0.5 - w, h2, 0.5 - w, (double)du, (double)v);
        v5.func_78374_a(0.5 - w, h, 0.5 - w, (double)du, (double)dv);
        v5.func_78374_a(0.5 + w, h, 0.5 - w, (double)u, (double)dv);
        v5.func_78374_a(0.5 + w, h, 0.5 + w, (double)u, (double)v);
        v5.func_78374_a(0.5 - w, h, 0.5 + w, (double)du, (double)v);
        v5.func_78374_a(0.5 - w, h2, 0.5 + w, (double)du, (double)dv);
        v5.func_78374_a(0.5 + w, h2, 0.5 + w, (double)u, (double)dv);
        v5.func_78374_a(0.5 - w, h, 0.5 + w, (double)u, (double)v);
        v5.func_78374_a(0.5 - w, h, 0.5 - w, (double)du, (double)v);
        v5.func_78374_a(0.5 - w, h2, 0.5 - w, (double)du, (double)dv);
        v5.func_78374_a(0.5 - w, h2, 0.5 + w, (double)u, (double)dv);
        v5.func_78374_a(0.5 + w, h2, 0.5 + w, (double)u, (double)v);
        v5.func_78374_a(0.5 + w, h2, 0.5 - w, (double)du, (double)v);
        v5.func_78374_a(0.5 + w, h, 0.5 - w, (double)du, (double)dv);
        v5.func_78374_a(0.5 + w, h, 0.5 + w, (double)u, (double)dv);
        v5.func_78381_a();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    public String getImageFileName(RenderFetcher te) {
        if (te == null) {
            return null;
        }
        TileEntityEngine tile = (TileEntityEngine)te;
        switch (tile.getEngineType()) {
            case DC: {
                return "dc.png";
            }
            case WIND: {
                return "windtex.png";
            }
            case STEAM: {
                return "steamtex.png";
            }
            case GAS: {
                return "combtex.png";
            }
            case AC: {
                return "actex.png";
            }
            case SPORT: {
                return "perftex.png";
            }
            case HYDRO: {
                return "hydrotex.png";
            }
            case MICRO: {
                return "microtex.png";
            }
            case JET: {
                return "jettex.png";
            }
        }
        return null;
    }
}

