/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.WTFException;
import Reika.DragonAPI.Interfaces.ISBRH;
import Reika.DragonAPI.Libraries.IO.ReikaLiquidRenderer;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.RenderableDuct;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.RotaryCraft;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

public class PipeBodyRenderer
implements ISBRH {
    public final int renderID;
    public int renderPass;
    private static final ForgeDirection[] dirs = ForgeDirection.values();

    public PipeBodyRenderer(int ID) {
        this.renderID = ID;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks rb) {
        Tessellator v5 = Tessellator.field_78398_a;
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        double s = 1.25;
        GL11.glScaled((double)s, (double)s, (double)s);
        ReikaTextureHelper.bindTerrainTexture();
        v5.func_78382_b();
        IIcon ico = block.func_149691_a(0, metadata);
        IIcon gico = block.func_149691_a(1, metadata);
        if (ico == null) {
            ico = BlockRegistry.LIGHT.getBlockInstance().func_149691_a(0, 0);
        }
        if (gico == null) {
            gico = BlockRegistry.LIGHT.getBlockInstance().func_149691_a(0, 0);
        }
        float dx = -0.5f;
        float dy = -0.5f;
        float dz = -0.5f;
        v5.func_78372_c(dx, dy, dz);
        v5.func_78375_b(0.0f, 0.75f, 0.0f);
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = dirs[i];
            this.renderInventoryFace(ico, gico, dir);
        }
        v5.func_78372_c(-dx, -dy, -dz);
        v5.func_78381_a();
        GL11.glScaled((double)(1.0 / s), (double)(1.0 / s), (double)(1.0 / s));
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        RenderableDuct tile = (RenderableDuct)world.func_147438_o(x, y, z);
        block4: for (int i = 0; i < 6; ++i) {
            switch (this.renderPass) {
                case 0: {
                    this.renderFace(tile, world, x, y, z, dirs[i]);
                    continue block4;
                }
                case 1: {
                    if (!tile.isFluidPipe()) continue block4;
                    this.renderLiquid(tile, x, y, z, dirs[i]);
                    continue block4;
                }
                default: {
                    throw new WTFException((DragonAPIMod)RotaryCraft.instance, "Who screwed up the render passes?", true);
                }
            }
        }
        Tessellator.field_78398_a.func_78377_a(0.0, 0.0, 0.0);
        Tessellator.field_78398_a.func_78377_a(0.0, 0.0, 0.0);
        Tessellator.field_78398_a.func_78377_a(0.0, 0.0, 0.0);
        Tessellator.field_78398_a.func_78377_a(0.0, 0.0, 0.0);
        return true;
    }

    public boolean shouldRender3DInInventory(int model) {
        return true;
    }

    public int getRenderId() {
        return this.renderID;
    }

    private void renderOverlay(RenderableDuct tile, IBlockAccess world, int x, int y, int z, ForgeDirection dir, IIcon ico) {
        if (tile.isConnectionValidForSide(dir)) {
            return;
        }
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78381_a();
        ReikaTextureHelper.bindTerrainTexture();
        float size = 0.375f;
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float du = ico.func_94212_f();
        float dv = ico.func_94210_h();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)32826);
        v5.func_78382_b();
        v5.func_78376_a(255, 255, 255);
        v5.func_78380_c(240);
        v5.func_78372_c((float)x, (float)y, (float)z);
        v5.func_78375_b((float)dir.offsetX, (float)dir.offsetY, (float)dir.offsetZ);
        switch (dir) {
            case DOWN: {
                v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size - 0.001, 0.5 + (double)size, (double)u, (double)v);
                v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size - 0.001, 0.5 + (double)size, (double)du, (double)v);
                v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size - 0.001, 0.5 - (double)size, (double)du, (double)dv);
                v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size - 0.001, 0.5 - (double)size, (double)u, (double)dv);
                break;
            }
            case EAST: {
                break;
            }
            case NORTH: {
                break;
            }
            case SOUTH: {
                break;
            }
            case UP: {
                v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size + 0.001, 0.5 - (double)size, (double)u, (double)dv);
                v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size + 0.001, 0.5 - (double)size, (double)du, (double)dv);
                v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size + 0.001, 0.5 + (double)size, (double)du, (double)v);
                v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size + 0.001, 0.5 + (double)size, (double)u, (double)v);
                break;
            }
            case WEST: {
                break;
            }
        }
        v5.func_78372_c((float)(-x), (float)(-y), (float)(-z));
        v5.func_78381_a();
        GL11.glEnable((int)2896);
        GL11.glDisable((int)2884);
        v5.func_78382_b();
    }

    private void renderLiquid(RenderableDuct tile, int x, int y, int z, ForgeDirection dir) {
        Fluid f = tile.getFluidType();
        if (f == null) {
            return;
        }
        Tessellator v5 = Tessellator.field_78398_a;
        float size = 0.375f;
        float window = 0.25f;
        float dl = size - window;
        float dd = 0.5f - size;
        double in = 0.5 + (double)size - 0.01;
        double in2 = 0.5 - (double)size + 0.01;
        double dd2 = in - in2;
        IIcon ico = ReikaLiquidRenderer.getFluidIconSafe((Fluid)f);
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float u2 = ico.func_94212_f();
        float v2 = ico.func_94210_h();
        double du = dd2 * (double)(u2 - u) / 4.0;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        v5.func_78372_c((float)x, (float)y, (float)z);
        int mix = tile.getPipeBlockType().func_149677_c((IBlockAccess)Minecraft.func_71410_x().field_71441_e, x, y, z);
        ReikaLiquidRenderer.bindFluidTexture((Fluid)f);
        v5.func_78376_a(255, 255, 255);
        int clr = -1;
        if (f.canBePlacedInWorld()) {
            clr = f.getBlock().func_149720_d((IBlockAccess)Minecraft.func_71410_x().field_71441_e, x * 2, y * 2, z * 2);
            v5.func_78378_d(clr);
        }
        if (f.getLuminosity() > 0) {
            v5.func_78380_c(240);
        } else {
            v5.func_78380_c(mix);
        }
        v5.func_78375_b((float)dir.offsetX, (float)(-dir.offsetY), (float)(-dir.offsetZ));
        if (!tile.isConnectionValidForSide(dir)) {
            switch (dir) {
                case DOWN: {
                    v5.func_78374_a(in2, in, in, (double)u, (double)v2);
                    v5.func_78374_a(in, in, in, (double)u2, (double)v2);
                    v5.func_78374_a(in, in, in2, (double)u2, (double)v);
                    v5.func_78374_a(in2, in, in2, (double)u, (double)v);
                    break;
                }
                case UP: {
                    v5.func_78374_a(in2, in2, in2, (double)u, (double)v);
                    v5.func_78374_a(in, in2, in2, (double)u2, (double)v);
                    v5.func_78374_a(in, in2, in, (double)u2, (double)v2);
                    v5.func_78374_a(in2, in2, in, (double)u, (double)v2);
                    break;
                }
                case NORTH: {
                    v5.func_78374_a(in, in, in, (double)u, (double)v);
                    v5.func_78374_a(in2, in, in, (double)u2, (double)v);
                    v5.func_78374_a(in2, in2, in, (double)u2, (double)v2);
                    v5.func_78374_a(in, in2, in, (double)u, (double)v2);
                    break;
                }
                case SOUTH: {
                    v5.func_78374_a(in, in2, in2, (double)u, (double)v2);
                    v5.func_78374_a(in2, in2, in2, (double)u2, (double)v2);
                    v5.func_78374_a(in2, in, in2, (double)u2, (double)v);
                    v5.func_78374_a(in, in, in2, (double)u, (double)v);
                    break;
                }
                case EAST: {
                    v5.func_78374_a(in, in2, in, (double)u, (double)v2);
                    v5.func_78374_a(in, in2, in2, (double)u2, (double)v2);
                    v5.func_78374_a(in, in, in2, (double)u2, (double)v);
                    v5.func_78374_a(in, in, in, (double)u, (double)v);
                    break;
                }
                case WEST: {
                    v5.func_78374_a(in2, in, in, (double)u, (double)v);
                    v5.func_78374_a(in2, in, in2, (double)u2, (double)v);
                    v5.func_78374_a(in2, in2, in2, (double)u2, (double)v2);
                    v5.func_78374_a(in2, in2, in, (double)u, (double)v2);
                }
            }
        } else {
            switch (dir) {
                case UP: {
                    v5.func_78375_b(-1.0f, 0.0f, 0.0f);
                    v5.func_78374_a(in2, in2, in, (double)u, (double)v);
                    v5.func_78374_a(in2, in2, in2, (double)u2, (double)v);
                    v5.func_78374_a(in2, 0.0, in2, (double)u2, (double)v + du);
                    v5.func_78374_a(in2, 0.0, in, (double)u, (double)v + du);
                    v5.func_78375_b(1.0f, 0.0f, 0.0f);
                    v5.func_78374_a(in, 0.0, in, (double)u, (double)v + du);
                    v5.func_78374_a(in, 0.0, in2, (double)u2, (double)v + du);
                    v5.func_78374_a(in, in2, in2, (double)u2, (double)v);
                    v5.func_78374_a(in, in2, in, (double)u, (double)v);
                    v5.func_78375_b(0.0f, 0.0f, -1.0f);
                    v5.func_78374_a(in, 0.0, in2, (double)u, (double)v + du);
                    v5.func_78374_a(in2, 0.0, in2, (double)u2, (double)v + du);
                    v5.func_78374_a(in2, in2, in2, (double)u2, (double)v);
                    v5.func_78374_a(in, in2, in2, (double)u, (double)v);
                    v5.func_78375_b(0.0f, 0.0f, 1.0f);
                    v5.func_78374_a(in, in2, in, (double)u, (double)v);
                    v5.func_78374_a(in2, in2, in, (double)u2, (double)v);
                    v5.func_78374_a(in2, 0.0, in, (double)u2, (double)v + du);
                    v5.func_78374_a(in, 0.0, in, (double)u, (double)v + du);
                    break;
                }
                case DOWN: {
                    v5.func_78375_b(-1.0f, 0.0f, 0.0f);
                    v5.func_78374_a(in2, 1.0, in, (double)u, (double)v + du);
                    v5.func_78374_a(in2, 1.0, in2, (double)u2, (double)v + du);
                    v5.func_78374_a(in2, in, in2, (double)u2, (double)v);
                    v5.func_78374_a(in2, in, in, (double)u, (double)v);
                    v5.func_78375_b(1.0f, 0.0f, 0.0f);
                    v5.func_78374_a(in, in, in, (double)u, (double)v);
                    v5.func_78374_a(in, in, in2, (double)u2, (double)v);
                    v5.func_78374_a(in, 1.0, in2, (double)u2, (double)v + du);
                    v5.func_78374_a(in, 1.0, in, (double)u, (double)v + du);
                    v5.func_78375_b(0.0f, 0.0f, -1.0f);
                    v5.func_78374_a(in, in, in2, (double)u, (double)v);
                    v5.func_78374_a(in2, in, in2, (double)u2, (double)v);
                    v5.func_78374_a(in2, 1.0, in2, (double)u2, (double)v + du);
                    v5.func_78374_a(in, 1.0, in2, (double)u, (double)v + du);
                    v5.func_78375_b(0.0f, 0.0f, 1.0f);
                    v5.func_78374_a(in, 1.0, in, (double)u, (double)v + du);
                    v5.func_78374_a(in2, 1.0, in, (double)u2, (double)v + du);
                    v5.func_78374_a(in2, in, in, (double)u2, (double)v);
                    v5.func_78374_a(in, in, in, (double)u, (double)v);
                    break;
                }
                case SOUTH: {
                    v5.func_78375_b(-1.0f, 0.0f, 0.0f);
                    v5.func_78374_a(in2, in2, 0.0, (double)u, (double)v2);
                    v5.func_78374_a(in2, in2, in2, (double)u + du, (double)v2);
                    v5.func_78374_a(in2, in, in2, (double)u + du, (double)v);
                    v5.func_78374_a(in2, in, 0.0, (double)u, (double)v);
                    v5.func_78375_b(1.0f, 0.0f, 0.0f);
                    v5.func_78374_a(in, in, 0.0, (double)u, (double)v);
                    v5.func_78374_a(in, in, in2, (double)u + du, (double)v);
                    v5.func_78374_a(in, in2, in2, (double)u + du, (double)v2);
                    v5.func_78374_a(in, in2, 0.0, (double)u, (double)v2);
                    v5.func_78375_b(0.0f, 1.0f, 0.0f);
                    v5.func_78374_a(in2, in, 0.0, (double)u, (double)v2);
                    v5.func_78374_a(in2, in, in2, (double)u + du, (double)v2);
                    v5.func_78374_a(in, in, in2, (double)u + du, (double)v);
                    v5.func_78374_a(in, in, 0.0, (double)u, (double)v);
                    v5.func_78375_b(0.0f, -1.0f, 0.0f);
                    v5.func_78374_a(in, in2, 0.0, (double)u, (double)v);
                    v5.func_78374_a(in, in2, in2, (double)u + du, (double)v);
                    v5.func_78374_a(in2, in2, in2, (double)u + du, (double)v2);
                    v5.func_78374_a(in2, in2, 0.0, (double)u, (double)v2);
                    break;
                }
                case NORTH: {
                    v5.func_78375_b(-1.0f, 0.0f, 0.0f);
                    v5.func_78374_a(in2, in, 1.0, (double)u, (double)v);
                    v5.func_78374_a(in2, in, in, (double)u + du, (double)v);
                    v5.func_78374_a(in2, in2, in, (double)u + du, (double)v2);
                    v5.func_78374_a(in2, in2, 1.0, (double)u, (double)v2);
                    v5.func_78375_b(1.0f, 0.0f, 0.0f);
                    v5.func_78374_a(in, in2, 1.0, (double)u, (double)v2);
                    v5.func_78374_a(in, in2, in, (double)u + du, (double)v2);
                    v5.func_78374_a(in, in, in, (double)u + du, (double)v);
                    v5.func_78374_a(in, in, 1.0, (double)u, (double)v);
                    v5.func_78375_b(0.0f, 1.0f, 0.0f);
                    v5.func_78374_a(in, in, 1.0, (double)u, (double)v);
                    v5.func_78374_a(in, in, in, (double)u + du, (double)v);
                    v5.func_78374_a(in2, in, in, (double)u + du, (double)v2);
                    v5.func_78374_a(in2, in, 1.0, (double)u, (double)v2);
                    v5.func_78375_b(0.0f, -1.0f, 0.0f);
                    v5.func_78374_a(in2, in2, 1.0, (double)u, (double)v2);
                    v5.func_78374_a(in2, in2, in, (double)u + du, (double)v2);
                    v5.func_78374_a(in, in2, in, (double)u + du, (double)v);
                    v5.func_78374_a(in, in2, 1.0, (double)u, (double)v);
                    break;
                }
                case EAST: {
                    v5.func_78375_b(0.0f, 0.0f, 1.0f);
                    v5.func_78374_a(1.0, in, in, (double)u, (double)v);
                    v5.func_78374_a(in, in, in, (double)u + du, (double)v);
                    v5.func_78374_a(in, in2, in, (double)u + du, (double)v2);
                    v5.func_78374_a(1.0, in2, in, (double)u, (double)v2);
                    v5.func_78375_b(0.0f, 0.0f, -1.0f);
                    v5.func_78374_a(1.0, in2, in2, (double)u, (double)v2);
                    v5.func_78374_a(in, in2, in2, (double)u + du, (double)v2);
                    v5.func_78374_a(in, in, in2, (double)u + du, (double)v);
                    v5.func_78374_a(1.0, in, in2, (double)u, (double)v);
                    v5.func_78375_b(0.0f, 1.0f, 0.0f);
                    v5.func_78374_a(1.0, in, in2, (double)u, (double)v2);
                    v5.func_78374_a(in, in, in2, (double)u + du, (double)v2);
                    v5.func_78374_a(in, in, in, (double)u + du, (double)v);
                    v5.func_78374_a(1.0, in, in, (double)u, (double)v);
                    v5.func_78375_b(0.0f, -1.0f, 0.0f);
                    v5.func_78374_a(1.0, in2, in, (double)u, (double)v);
                    v5.func_78374_a(in, in2, in, (double)u + du, (double)v);
                    v5.func_78374_a(in, in2, in2, (double)u + du, (double)v2);
                    v5.func_78374_a(1.0, in2, in2, (double)u, (double)v2);
                    break;
                }
                case WEST: {
                    v5.func_78375_b(0.0f, 0.0f, 1.0f);
                    v5.func_78374_a(0.0, in2, in, (double)u, (double)v2);
                    v5.func_78374_a(in2, in2, in, (double)u + du, (double)v2);
                    v5.func_78374_a(in2, in, in, (double)u + du, (double)v);
                    v5.func_78374_a(0.0, in, in, (double)u, (double)v);
                    v5.func_78375_b(0.0f, 0.0f, -1.0f);
                    v5.func_78374_a(0.0, in, in2, (double)u, (double)v);
                    v5.func_78374_a(in2, in, in2, (double)u + du, (double)v);
                    v5.func_78374_a(in2, in2, in2, (double)u + du, (double)v2);
                    v5.func_78374_a(0.0, in2, in2, (double)u, (double)v2);
                    v5.func_78375_b(0.0f, 1.0f, 0.0f);
                    v5.func_78374_a(0.0, in, in, (double)u, (double)v);
                    v5.func_78374_a(in2, in, in, (double)u + du, (double)v);
                    v5.func_78374_a(in2, in, in2, (double)u + du, (double)v2);
                    v5.func_78374_a(0.0, in, in2, (double)u, (double)v2);
                    v5.func_78375_b(0.0f, -1.0f, 0.0f);
                    v5.func_78374_a(0.0, in2, in2, (double)u, (double)v2);
                    v5.func_78374_a(in2, in2, in2, (double)u + du, (double)v2);
                    v5.func_78374_a(in2, in2, in, (double)u + du, (double)v);
                    v5.func_78374_a(0.0, in2, in, (double)u, (double)v);
                    break;
                }
            }
        }
        if (tile.isConnectedToNonSelf(dir)) {
            v5.func_78375_b((float)dir.offsetX, (float)dir.offsetY, (float)dir.offsetZ);
            switch (dir) {
                case DOWN: {
                    v5.func_78374_a(in2, 0.99, in, (double)u, (double)v2);
                    v5.func_78374_a(in, 0.99, in, (double)u2, (double)v2);
                    v5.func_78374_a(in, 0.99, in2, (double)u2, (double)v);
                    v5.func_78374_a(in2, 0.99, in2, (double)u, (double)v);
                    break;
                }
                case UP: {
                    v5.func_78374_a(in2, 0.01, in2, (double)u, (double)v);
                    v5.func_78374_a(in, 0.01, in2, (double)u2, (double)v);
                    v5.func_78374_a(in, 0.01, in, (double)u2, (double)v2);
                    v5.func_78374_a(in2, 0.01, in, (double)u, (double)v2);
                    break;
                }
                case NORTH: {
                    v5.func_78374_a(in, in, 0.99, (double)u, (double)v);
                    v5.func_78374_a(in2, in, 0.99, (double)u2, (double)v);
                    v5.func_78374_a(in2, in2, 0.99, (double)u2, (double)v2);
                    v5.func_78374_a(in, in2, 0.99, (double)u, (double)v2);
                    break;
                }
                case SOUTH: {
                    v5.func_78374_a(in, in2, 0.01, (double)u, (double)v2);
                    v5.func_78374_a(in2, in2, 0.01, (double)u2, (double)v2);
                    v5.func_78374_a(in2, in, 0.01, (double)u2, (double)v);
                    v5.func_78374_a(in, in, 0.01, (double)u, (double)v);
                    break;
                }
                case EAST: {
                    v5.func_78374_a(0.99, in2, in, (double)u, (double)v2);
                    v5.func_78374_a(0.99, in2, in2, (double)u2, (double)v2);
                    v5.func_78374_a(0.99, in, in2, (double)u2, (double)v);
                    v5.func_78374_a(0.99, in, in, (double)u, (double)v);
                    break;
                }
                case WEST: {
                    v5.func_78374_a(0.01, in, in, (double)u, (double)v);
                    v5.func_78374_a(0.01, in, in2, (double)u2, (double)v);
                    v5.func_78374_a(0.01, in2, in2, (double)u2, (double)v2);
                    v5.func_78374_a(0.01, in2, in, (double)u, (double)v2);
                }
            }
        }
        v5.func_78372_c((float)(-x), (float)(-y), (float)(-z));
    }

    public void renderBlockInInventory(RenderableDuct tile, double par2, double par4, double par6) {
        GL11.glTranslated((double)par2, (double)par4, (double)par6);
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = dirs[i];
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            this.doRenderFace(tile, (IBlockAccess)world, dir);
        }
        Tessellator.field_78398_a.func_78381_a();
        GL11.glTranslated((double)(-par2), (double)(-par4), (double)(-par6));
    }

    private void renderFace(RenderableDuct tile, IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        if (tile == null) {
            return;
        }
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78372_c((float)x, (float)y, (float)z);
        int br = tile.getPipeBlockType().func_149677_c(world, x, y, z);
        v5.func_78380_c(br);
        this.doRenderFace(tile, world, dir);
        v5.func_78372_c((float)(-x), (float)(-y), (float)(-z));
    }

    private void doRenderFace(RenderableDuct tile, IBlockAccess world, ForgeDirection dir) {
        Tessellator v5 = Tessellator.field_78398_a;
        float size = 0.375f;
        float window = 0.25f;
        float dl = size - window;
        float dd = 0.5f - size;
        IIcon ico = tile.getBlockIcon();
        if (ico == null) {
            ico = BlockRegistry.LIGHT.getBlockInstance().func_149691_a(0, 0);
        }
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float u2 = ico.func_94212_f();
        float v2 = ico.func_94210_h();
        float ddu = u2 - u;
        float ddv = v2 - v;
        float uo = u;
        float vo = v;
        float u2o = u2;
        float v2o = v2;
        u += ddu * (1.0f - size) / 5.0f;
        v += ddv * (1.0f - size) / 5.0f;
        u2 -= ddu * (1.0f - size) / 5.0f;
        v2 -= ddv * (1.0f - size) / 5.0f;
        float du = ddu * dd;
        float dv = ddv * dd;
        float lx = dd + dl;
        float ly = dd + dl;
        float mx = 1.0f - dd - dl;
        float my = 1.0f - dd - dl;
        IIcon gico = tile.getGlassIcon();
        if (gico == null) {
            gico = BlockRegistry.LIGHT.getBlockInstance().func_149691_a(0, 0);
        }
        float gu = gico.func_94209_e();
        float gv = gico.func_94206_g();
        float gu2 = gico.func_94212_f();
        float gv2 = gico.func_94210_h();
        float dgu = gu2 - gu;
        float dgv = gv2 - gv;
        float guu = gu + dgu / 2.0f;
        float gvv = gv + dgv / 2.0f;
        gu += dgu / 8.0f;
        gv += dgv / 8.0f;
        gu2 -= dgu / 8.0f;
        gv2 -= dgv / 8.0f;
        if (world != null && tile.isConnectionValidForSide(dir)) {
            switch (dir) {
                case DOWN: {
                    this.faceBrightness(ForgeDirection.SOUTH, v5);
                    v5.func_78374_a(0.5 + (double)size - (double)dd, 0.5 + (double)size, 0.5 + (double)size, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size, 0.5 + (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size + (double)dd, 0.5 + (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 + (double)size - (double)dd, 0.5 + (double)size + (double)dd, 0.5 + (double)size, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 - (double)size + (double)dd, 0.5 + (double)size + (double)dd, 0.5 + (double)size, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size + (double)dd, 0.5 + (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size, 0.5 + (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 - (double)size + (double)dd, 0.5 + (double)size, 0.5 + (double)size, (double)(u2 - du), (double)v);
                    this.faceBrightness(ForgeDirection.EAST, v5);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size + (double)dd, 0.5 + (double)size - (double)dd, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size + (double)dd, 0.5 + (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size, 0.5 + (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size, 0.5 + (double)size - (double)dd, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size, 0.5 - (double)size + (double)dd, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size, 0.5 - (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size + (double)dd, 0.5 - (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size + (double)dd, 0.5 - (double)size + (double)dd, (double)(u2 - du), (double)vo);
                    this.faceBrightness(ForgeDirection.WEST, v5);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size, 0.5 + (double)size - (double)dd, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size, 0.5 + (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size + (double)dd, 0.5 + (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size + (double)dd, 0.5 + (double)size - (double)dd, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size + (double)dd, 0.5 - (double)size + (double)dd, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size + (double)dd, 0.5 - (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size, 0.5 - (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size, 0.5 - (double)size + (double)dd, (double)(u2 - du), (double)v);
                    this.faceBrightness(ForgeDirection.NORTH, v5);
                    v5.func_78374_a(0.5 + (double)size - (double)dd, 0.5 + (double)size + (double)dd, 0.5 - (double)size, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size + (double)dd, 0.5 - (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size, 0.5 - (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 + (double)size - (double)dd, 0.5 + (double)size, 0.5 - (double)size, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 - (double)size + (double)dd, 0.5 + (double)size, 0.5 - (double)size, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size, 0.5 - (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size + (double)dd, 0.5 - (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 - (double)size + (double)dd, 0.5 + (double)size + (double)dd, 0.5 - (double)size, (double)(u2 - du), (double)vo);
                    break;
                }
                case EAST: {
                    this.faceBrightness(ForgeDirection.DOWN, v5);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size, 0.5 + (double)window, (double)u2, (double)(v + dv));
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size, 0.5 + (double)size, (double)u2, (double)v);
                    v5.func_78374_a(1.0, 0.5 + (double)size, 0.5 + (double)size, (double)u2o, (double)v);
                    v5.func_78374_a(1.0, 0.5 + (double)size, 0.5 + (double)window, (double)u2o, (double)(v + dv));
                    v5.func_78374_a(1.0, 0.5 + (double)size, 0.5 - (double)window, (double)u2o, (double)(v2 - dv));
                    v5.func_78374_a(1.0, 0.5 + (double)size, 0.5 - (double)size, (double)u2o, (double)v2);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size, 0.5 - (double)size, (double)u2, (double)v2);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size, 0.5 - (double)window, (double)u2, (double)(v2 - dv));
                    this.faceBrightness(ForgeDirection.SOUTH, v5);
                    v5.func_78374_a(0.5 + (double)size + (double)dd, 0.5 + (double)size, 0.5 + (double)size, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size, 0.5 + (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size - (double)dd, 0.5 + (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 + (double)size + (double)dd, 0.5 + (double)size - (double)dd, 0.5 + (double)size, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 + (double)size + (double)dd, 0.5 - (double)size + (double)dd, 0.5 + (double)size, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size + (double)dd, 0.5 + (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size, 0.5 + (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 + (double)size + (double)dd, 0.5 - (double)size, 0.5 + (double)size, (double)(u2 - du), (double)v);
                    this.faceBrightness(ForgeDirection.UP, v5);
                    v5.func_78374_a(1.0, 0.5 - (double)size, 0.5 + (double)window, (double)u2o, (double)(v + dv));
                    v5.func_78374_a(1.0, 0.5 - (double)size, 0.5 + (double)size, (double)u2o, (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size, 0.5 + (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size, 0.5 + (double)window, (double)u2, (double)(v + dv));
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size, 0.5 - (double)window, (double)u2, (double)(v2 - dv));
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size, 0.5 - (double)size, (double)u2, (double)v2);
                    v5.func_78374_a(1.0, 0.5 - (double)size, 0.5 - (double)size, (double)u2o, (double)v2);
                    v5.func_78374_a(1.0, 0.5 - (double)size, 0.5 - (double)window, (double)u2o, (double)(v2 - dv));
                    this.faceBrightness(ForgeDirection.NORTH, v5);
                    v5.func_78374_a(0.5 + (double)size + (double)dd, 0.5 + (double)size - (double)dd, 0.5 - (double)size, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size - (double)dd, 0.5 - (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size, 0.5 - (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 + (double)size + (double)dd, 0.5 + (double)size, 0.5 - (double)size, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 + (double)size + (double)dd, 0.5 - (double)size, 0.5 - (double)size, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size, 0.5 - (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size + (double)dd, 0.5 - (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 + (double)size + (double)dd, 0.5 - (double)size + (double)dd, 0.5 - (double)size, (double)(u2 - du), (double)vo);
                    break;
                }
                case NORTH: {
                    this.faceBrightness(ForgeDirection.DOWN, v5);
                    v5.func_78374_a(0.5 - (double)window, 0.5 + (double)size, 0.5 + (double)size, (double)(u2 - du), (double)v2);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size, 0.5 + (double)size, (double)u2, (double)v2);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size, 1.0, (double)u2, (double)v2o);
                    v5.func_78374_a(0.5 - (double)window, 0.5 + (double)size, 1.0, (double)(u2 - du), (double)v2o);
                    v5.func_78374_a(0.5 + (double)window, 0.5 + (double)size, 1.0, (double)(u + du), (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size, 1.0, (double)u, (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size, 0.5 + (double)size, (double)u, (double)v);
                    v5.func_78374_a(0.5 + (double)window, 0.5 + (double)size, 0.5 + (double)size, (double)(u + du), (double)v);
                    this.faceBrightness(ForgeDirection.EAST, v5);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size - (double)dd, 0.5 + (double)size + (double)dd, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size - (double)dd, 0.5 + (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size, 0.5 + (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size, 0.5 + (double)size + (double)dd, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size, 0.5 + (double)size + (double)dd, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size, 0.5 + (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size + (double)dd, 0.5 + (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size + (double)dd, 0.5 + (double)size + (double)dd, (double)(u2 - du), (double)vo);
                    this.faceBrightness(ForgeDirection.WEST, v5);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size, 0.5 + (double)size + (double)dd, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size, 0.5 + (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size - (double)dd, 0.5 + (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size - (double)dd, 0.5 + (double)size + (double)dd, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size + (double)dd, 0.5 + (double)size + (double)dd, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size + (double)dd, 0.5 + (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size, 0.5 + (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size, 0.5 + (double)size + (double)dd, (double)(u2 - du), (double)v);
                    this.faceBrightness(ForgeDirection.UP, v5);
                    v5.func_78374_a(0.5 - (double)window, 0.5 - (double)size, 1.0, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size, 1.0, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size, 0.5 + (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 - (double)window, 0.5 - (double)size, 0.5 + (double)size, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 + (double)window, 0.5 - (double)size, 0.5 + (double)size, (double)(u + du), (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size, 0.5 + (double)size, (double)u, (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size, 1.0, (double)u, (double)vo);
                    v5.func_78374_a(0.5 + (double)window, 0.5 - (double)size, 1.0, (double)(u + du), (double)vo);
                    break;
                }
                case SOUTH: {
                    this.faceBrightness(ForgeDirection.DOWN, v5);
                    v5.func_78374_a(0.5 + (double)window, 0.5 + (double)size, 0.5 - (double)size, (double)(u2 - du), (double)v2);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size, 0.5 - (double)size, (double)u2, (double)v2);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size, 0.0, (double)u2, (double)v2o);
                    v5.func_78374_a(0.5 + (double)window, 0.5 + (double)size, 0.0, (double)(u2 - du), (double)v2o);
                    v5.func_78374_a(0.5 - (double)window, 0.5 + (double)size, 0.0, (double)(u + du), (double)v2o);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size, 0.0, (double)u, (double)v2o);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size, 0.5 - (double)size, (double)u, (double)v2);
                    v5.func_78374_a(0.5 - (double)window, 0.5 + (double)size, 0.5 - (double)size, (double)(u + du), (double)v2);
                    this.faceBrightness(ForgeDirection.EAST, v5);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size, 0.5 - (double)size - (double)dd, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size, 0.5 - (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size - (double)dd, 0.5 - (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 + (double)size - (double)dd, 0.5 - (double)size - (double)dd, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size + (double)dd, 0.5 - (double)size - (double)dd, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size + (double)dd, 0.5 - (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size, 0.5 - (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size, 0.5 - (double)size - (double)dd, (double)(u2 - du), (double)v);
                    this.faceBrightness(ForgeDirection.WEST, v5);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size - (double)dd, 0.5 - (double)size - (double)dd, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size - (double)dd, 0.5 - (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size, 0.5 - (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size, 0.5 - (double)size - (double)dd, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size, 0.5 - (double)size - (double)dd, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size, 0.5 - (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size + (double)dd, 0.5 - (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size + (double)dd, 0.5 - (double)size - (double)dd, (double)(u2 - du), (double)vo);
                    this.faceBrightness(ForgeDirection.UP, v5);
                    v5.func_78374_a(0.5 + (double)window, 0.5 - (double)size, 0.0, (double)(u2 - du), (double)v2o);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size, 0.0, (double)u2, (double)v2o);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size, 0.5 - (double)size, (double)u2, (double)v2);
                    v5.func_78374_a(0.5 + (double)window, 0.5 - (double)size, 0.5 - (double)size, (double)(u2 - du), (double)v2);
                    v5.func_78374_a(0.5 - (double)window, 0.5 - (double)size, 0.5 - (double)size, (double)(u + du), (double)v2);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size, 0.5 - (double)size, (double)u, (double)v2);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size, 0.0, (double)u, (double)v2o);
                    v5.func_78374_a(0.5 - (double)window, 0.5 - (double)size, 0.0, (double)(u + du), (double)v2o);
                    break;
                }
                case UP: {
                    this.faceBrightness(ForgeDirection.SOUTH, v5);
                    v5.func_78374_a(0.5 + (double)size - (double)dd, 0.5 - (double)size - (double)dd, 0.5 + (double)size, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size - (double)dd, 0.5 + (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size, 0.5 + (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 + (double)size - (double)dd, 0.5 - (double)size, 0.5 + (double)size, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 - (double)size + (double)dd, 0.5 - (double)size, 0.5 + (double)size, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size, 0.5 + (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size - (double)dd, 0.5 + (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 - (double)size + (double)dd, 0.5 - (double)size - (double)dd, 0.5 + (double)size, (double)(u2 - du), (double)vo);
                    this.faceBrightness(ForgeDirection.EAST, v5);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size, 0.5 + (double)size - (double)dd, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size, 0.5 + (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size - (double)dd, 0.5 + (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size - (double)dd, 0.5 + (double)size - (double)dd, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size - (double)dd, 0.5 - (double)size + (double)dd, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size - (double)dd, 0.5 - (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size, 0.5 - (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size, 0.5 - (double)size + (double)dd, (double)(u2 - du), (double)v);
                    this.faceBrightness(ForgeDirection.WEST, v5);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size - (double)dd, 0.5 + (double)size - (double)dd, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size - (double)dd, 0.5 + (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size, 0.5 + (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size, 0.5 + (double)size - (double)dd, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size, 0.5 - (double)size + (double)dd, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size, 0.5 - (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size - (double)dd, 0.5 - (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size - (double)dd, 0.5 - (double)size + (double)dd, (double)(u2 - du), (double)vo);
                    this.faceBrightness(ForgeDirection.NORTH, v5);
                    v5.func_78374_a(0.5 + (double)size - (double)dd, 0.5 - (double)size, 0.5 - (double)size, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size, 0.5 - (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 + (double)size, 0.5 - (double)size - (double)dd, 0.5 - (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 + (double)size - (double)dd, 0.5 - (double)size - (double)dd, 0.5 - (double)size, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 - (double)size + (double)dd, 0.5 - (double)size - (double)dd, 0.5 - (double)size, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size - (double)dd, 0.5 - (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size, 0.5 - (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 - (double)size + (double)dd, 0.5 - (double)size, 0.5 - (double)size, (double)(u2 - du), (double)v);
                    break;
                }
                case WEST: {
                    this.faceBrightness(ForgeDirection.DOWN, v5);
                    v5.func_78374_a(0.0, 0.5 + (double)size, 0.5 + (double)window, (double)u2o, (double)(v2 - dv));
                    v5.func_78374_a(0.0, 0.5 + (double)size, 0.5 + (double)size, (double)u2o, (double)v2);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size, 0.5 + (double)size, (double)u2, (double)v2);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size, 0.5 + (double)window, (double)u2, (double)(v2 - dv));
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size, 0.5 - (double)window, (double)u2, (double)(v + dv));
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size, 0.5 - (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.0, 0.5 + (double)size, 0.5 - (double)size, (double)u2o, (double)v);
                    v5.func_78374_a(0.0, 0.5 + (double)size, 0.5 - (double)window, (double)u2o, (double)(v + dv));
                    this.faceBrightness(ForgeDirection.SOUTH, v5);
                    v5.func_78374_a(0.5 - (double)size - (double)dd, 0.5 + (double)size - (double)dd, 0.5 + (double)size, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size - (double)dd, 0.5 + (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size, 0.5 + (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 - (double)size - (double)dd, 0.5 + (double)size, 0.5 + (double)size, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 - (double)size - (double)dd, 0.5 - (double)size, 0.5 + (double)size, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size, 0.5 + (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size + (double)dd, 0.5 + (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 - (double)size - (double)dd, 0.5 - (double)size + (double)dd, 0.5 + (double)size, (double)(u2 - du), (double)vo);
                    this.faceBrightness(ForgeDirection.UP, v5);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size, 0.5 + (double)window, (double)u2, (double)(v2 - dv));
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size, 0.5 + (double)size, (double)u2, (double)v2);
                    v5.func_78374_a(0.0, 0.5 - (double)size, 0.5 + (double)size, (double)u2o, (double)v2);
                    v5.func_78374_a(0.0, 0.5 - (double)size, 0.5 + (double)window, (double)u2o, (double)(v2 - dv));
                    v5.func_78374_a(0.0, 0.5 - (double)size, 0.5 - (double)window, (double)u2o, (double)(v + dv));
                    v5.func_78374_a(0.0, 0.5 - (double)size, 0.5 - (double)size, (double)u2o, (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size, 0.5 - (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size, 0.5 - (double)window, (double)u2, (double)(v + dv));
                    this.faceBrightness(ForgeDirection.NORTH, v5);
                    v5.func_78374_a(0.5 - (double)size - (double)dd, 0.5 + (double)size, 0.5 - (double)size, (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size, 0.5 - (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 - (double)size, 0.5 + (double)size - (double)dd, 0.5 - (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 - (double)size - (double)dd, 0.5 + (double)size - (double)dd, 0.5 - (double)size, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 - (double)size - (double)dd, 0.5 - (double)size + (double)dd, 0.5 - (double)size, (double)(u2 - du), (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size + (double)dd, 0.5 - (double)size, (double)u2, (double)vo);
                    v5.func_78374_a(0.5 - (double)size, 0.5 - (double)size, 0.5 - (double)size, (double)u2, (double)v);
                    v5.func_78374_a(0.5 - (double)size - (double)dd, 0.5 - (double)size, 0.5 - (double)size, (double)(u2 - du), (double)v);
                    break;
                }
            }
        } else {
            this.faceBrightness(dir, v5);
            switch (dir) {
                case DOWN: {
                    if (!tile.isConnectionValidForSide(ForgeDirection.WEST)) {
                        v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd), (double)u, (double)v);
                        v5.func_78374_a((double)(dd + dl), (double)(1.0f - dd), (double)(1.0f - dd), (double)(u + du), (double)v);
                        v5.func_78374_a((double)(dd + dl), (double)(1.0f - dd), (double)dd, (double)(u + du), (double)v2);
                        v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)dd, (double)u, (double)v2);
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.EAST)) {
                        v5.func_78374_a((double)(1.0f - dd - dl), (double)(1.0f - dd), (double)(1.0f - dd), (double)(u2 - du), (double)v);
                        v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                        v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)dd, (double)u2, (double)v2);
                        v5.func_78374_a((double)(1.0f - dd - dl), (double)(1.0f - dd), (double)dd, (double)(u2 - du), (double)v2);
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.SOUTH)) {
                        v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(dd + dl), (double)u, (double)(v2 - dv));
                        v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(dd + dl), (double)u2, (double)(v2 - dv));
                        v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)dd, (double)u2, (double)v2);
                        v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)dd, (double)u, (double)v2);
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.NORTH)) {
                        v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd), (double)u, (double)v);
                        v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                        v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd - dl), (double)u2, (double)(v + dv));
                        v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd - dl), (double)u, (double)(v + dv));
                    }
                    v5.func_78374_a((double)mx, (double)(1.0f - dd), (double)ly, (double)gu2, (double)gv);
                    v5.func_78374_a((double)lx, (double)(1.0f - dd), (double)ly, (double)gu, (double)gv);
                    v5.func_78374_a((double)lx, (double)(1.0f - dd), (double)my, (double)gu, (double)gv2);
                    v5.func_78374_a((double)mx, (double)(1.0f - dd), (double)my, (double)gu2, (double)gv2);
                    if (tile.isConnectionValidForSide(ForgeDirection.EAST)) {
                        v5.func_78374_a((double)mx + 0.5, (double)(1.0f - dd), (double)ly, (double)gu2, (double)gv);
                        v5.func_78374_a((double)lx + 0.5, (double)(1.0f - dd), (double)ly, (double)gu, (double)gv);
                        v5.func_78374_a((double)lx + 0.5, (double)(1.0f - dd), (double)my, (double)gu, (double)gv2);
                        v5.func_78374_a((double)mx + 0.5, (double)(1.0f - dd), (double)my, (double)gu2, (double)gv2);
                    }
                    if (tile.isConnectionValidForSide(ForgeDirection.WEST)) {
                        v5.func_78374_a((double)mx - 0.5, (double)(1.0f - dd), (double)ly, (double)gu2, (double)gv);
                        v5.func_78374_a((double)lx - 0.5, (double)(1.0f - dd), (double)ly, (double)gu, (double)gv);
                        v5.func_78374_a((double)lx - 0.5, (double)(1.0f - dd), (double)my, (double)gu, (double)gv2);
                        v5.func_78374_a((double)mx - 0.5, (double)(1.0f - dd), (double)my, (double)gu2, (double)gv2);
                    }
                    if (tile.isConnectionValidForSide(ForgeDirection.NORTH)) {
                        v5.func_78374_a((double)mx, (double)(1.0f - dd), (double)ly + 0.5, (double)gu2, (double)gv);
                        v5.func_78374_a((double)lx, (double)(1.0f - dd), (double)ly + 0.5, (double)gu, (double)gv);
                        v5.func_78374_a((double)lx, (double)(1.0f - dd), (double)my + 0.5, (double)gu, (double)gv2);
                        v5.func_78374_a((double)mx, (double)(1.0f - dd), (double)my + 0.5, (double)gu2, (double)gv2);
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.SOUTH)) break;
                    v5.func_78374_a((double)mx, (double)(1.0f - dd), (double)ly - 0.5, (double)gu2, (double)gv);
                    v5.func_78374_a((double)lx, (double)(1.0f - dd), (double)ly - 0.5, (double)gu, (double)gv);
                    v5.func_78374_a((double)lx, (double)(1.0f - dd), (double)my - 0.5, (double)gu, (double)gv2);
                    v5.func_78374_a((double)mx, (double)(1.0f - dd), (double)my - 0.5, (double)gu2, (double)gv2);
                    break;
                }
                case NORTH: {
                    if (!tile.isConnectionValidForSide(ForgeDirection.WEST)) {
                        v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd), (double)u, (double)v2);
                        v5.func_78374_a((double)(dd + dl), (double)dd, (double)(1.0f - dd), (double)(u + du), (double)v2);
                        v5.func_78374_a((double)(dd + dl), (double)(1.0f - dd), (double)(1.0f - dd), (double)(u + du), (double)v);
                        v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd), (double)u, (double)v);
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.EAST)) {
                        v5.func_78374_a((double)(1.0f - dd - dl), (double)dd, (double)(1.0f - dd), (double)(u2 - du), (double)v2);
                        v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                        v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                        v5.func_78374_a((double)(1.0f - dd - dl), (double)(1.0f - dd), (double)(1.0f - dd), (double)(u2 - du), (double)v);
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.UP)) {
                        v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd), (double)u, (double)v2);
                        v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                        v5.func_78374_a((double)(1.0f - dd), (double)(dd + dl), (double)(1.0f - dd), (double)u2, (double)(v2 - dv));
                        v5.func_78374_a((double)dd, (double)(dd + dl), (double)(1.0f - dd), (double)u, (double)(v2 - dv));
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.DOWN)) {
                        v5.func_78374_a((double)dd, (double)(1.0f - dd - dl), (double)(1.0f - dd), (double)u, (double)(v + dv));
                        v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd - dl), (double)(1.0f - dd), (double)u2, (double)(v + dv));
                        v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                        v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd), (double)u, (double)v);
                    }
                    v5.func_78374_a((double)mx, (double)my, (double)(1.0f - dd), (double)gu2, (double)gv2);
                    v5.func_78374_a((double)lx, (double)my, (double)(1.0f - dd), (double)gu, (double)gv2);
                    v5.func_78374_a((double)lx, (double)ly, (double)(1.0f - dd), (double)gu, (double)gv);
                    v5.func_78374_a((double)mx, (double)ly, (double)(1.0f - dd), (double)gu2, (double)gv);
                    if (tile.isConnectionValidForSide(ForgeDirection.EAST)) {
                        v5.func_78374_a((double)mx + 0.5, (double)my, (double)(1.0f - dd), (double)gu2, (double)gv2);
                        v5.func_78374_a((double)lx + 0.5, (double)my, (double)(1.0f - dd), (double)gu, (double)gv2);
                        v5.func_78374_a((double)lx + 0.5, (double)ly, (double)(1.0f - dd), (double)gu, (double)gv);
                        v5.func_78374_a((double)mx + 0.5, (double)ly, (double)(1.0f - dd), (double)gu2, (double)gv);
                    }
                    if (tile.isConnectionValidForSide(ForgeDirection.WEST)) {
                        v5.func_78374_a((double)mx - 0.5, (double)my, (double)(1.0f - dd), (double)gu2, (double)gv2);
                        v5.func_78374_a((double)lx - 0.5, (double)my, (double)(1.0f - dd), (double)gu, (double)gv2);
                        v5.func_78374_a((double)lx - 0.5, (double)ly, (double)(1.0f - dd), (double)gu, (double)gv);
                        v5.func_78374_a((double)mx - 0.5, (double)ly, (double)(1.0f - dd), (double)gu2, (double)gv);
                    }
                    if (tile.isConnectionValidForSide(ForgeDirection.DOWN)) {
                        v5.func_78374_a((double)mx, (double)my + 0.5, (double)(1.0f - dd), (double)gu2, (double)gv2);
                        v5.func_78374_a((double)lx, (double)my + 0.5, (double)(1.0f - dd), (double)gu, (double)gv2);
                        v5.func_78374_a((double)lx, (double)ly + 0.5, (double)(1.0f - dd), (double)gu, (double)gv);
                        v5.func_78374_a((double)mx, (double)ly + 0.5, (double)(1.0f - dd), (double)gu2, (double)gv);
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.UP)) break;
                    v5.func_78374_a((double)mx, (double)my - 0.5, (double)(1.0f - dd), (double)gu2, (double)gv2);
                    v5.func_78374_a((double)lx, (double)my - 0.5, (double)(1.0f - dd), (double)gu, (double)gv2);
                    v5.func_78374_a((double)lx, (double)ly - 0.5, (double)(1.0f - dd), (double)gu, (double)gv);
                    v5.func_78374_a((double)mx, (double)ly - 0.5, (double)(1.0f - dd), (double)gu2, (double)gv);
                    break;
                }
                case EAST: {
                    if (!tile.isConnectionValidForSide(ForgeDirection.SOUTH)) {
                        v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                        v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(dd + dl), (double)(u + du), (double)v);
                        v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(dd + dl), (double)(u + du), (double)v2);
                        v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)dd, (double)u, (double)v2);
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.NORTH)) {
                        v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd - dl), (double)(u2 - du), (double)v);
                        v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                        v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                        v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd - dl), (double)(u2 - du), (double)v2);
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.UP)) {
                        v5.func_78374_a((double)(1.0f - dd), (double)(dd + dl), (double)dd, (double)u, (double)(v2 - dv));
                        v5.func_78374_a((double)(1.0f - dd), (double)(dd + dl), (double)(1.0f - dd), (double)u2, (double)(v2 - dv));
                        v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                        v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)dd, (double)u, (double)v2);
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.DOWN)) {
                        v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                        v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                        v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd - dl), (double)(1.0f - dd), (double)u2, (double)(v + dv));
                        v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd - dl), (double)dd, (double)u, (double)(v + dv));
                    }
                    v5.func_78374_a((double)(1.0f - dd), (double)ly, (double)mx, (double)gu2, (double)gv);
                    v5.func_78374_a((double)(1.0f - dd), (double)ly, (double)lx, (double)gu, (double)gv);
                    v5.func_78374_a((double)(1.0f - dd), (double)my, (double)lx, (double)gu, (double)gv2);
                    v5.func_78374_a((double)(1.0f - dd), (double)my, (double)mx, (double)gu2, (double)gv2);
                    if (tile.isConnectionValidForSide(ForgeDirection.NORTH)) {
                        v5.func_78374_a((double)(1.0f - dd), (double)ly, (double)mx + 0.5, (double)gu2, (double)gv);
                        v5.func_78374_a((double)(1.0f - dd), (double)ly, (double)lx + 0.5, (double)gu, (double)gv);
                        v5.func_78374_a((double)(1.0f - dd), (double)my, (double)lx + 0.5, (double)gu, (double)gv2);
                        v5.func_78374_a((double)(1.0f - dd), (double)my, (double)mx + 0.5, (double)gu2, (double)gv2);
                    }
                    if (tile.isConnectionValidForSide(ForgeDirection.SOUTH)) {
                        v5.func_78374_a((double)(1.0f - dd), (double)ly, (double)mx - 0.5, (double)gu2, (double)gv);
                        v5.func_78374_a((double)(1.0f - dd), (double)ly, (double)lx - 0.5, (double)gu, (double)gv);
                        v5.func_78374_a((double)(1.0f - dd), (double)my, (double)lx - 0.5, (double)gu, (double)gv2);
                        v5.func_78374_a((double)(1.0f - dd), (double)my, (double)mx - 0.5, (double)gu2, (double)gv2);
                    }
                    if (tile.isConnectionValidForSide(ForgeDirection.UP)) {
                        v5.func_78374_a((double)(1.0f - dd), (double)ly - 0.5, (double)mx, (double)gu2, (double)gv);
                        v5.func_78374_a((double)(1.0f - dd), (double)ly - 0.5, (double)lx, (double)gu, (double)gv);
                        v5.func_78374_a((double)(1.0f - dd), (double)my - 0.5, (double)lx, (double)gu, (double)gv2);
                        v5.func_78374_a((double)(1.0f - dd), (double)my - 0.5, (double)mx, (double)gu2, (double)gv2);
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.DOWN)) break;
                    v5.func_78374_a((double)(1.0f - dd), (double)ly + 0.5, (double)mx, (double)gu2, (double)gv);
                    v5.func_78374_a((double)(1.0f - dd), (double)ly + 0.5, (double)lx, (double)gu, (double)gv);
                    v5.func_78374_a((double)(1.0f - dd), (double)my + 0.5, (double)lx, (double)gu, (double)gv2);
                    v5.func_78374_a((double)(1.0f - dd), (double)my + 0.5, (double)mx, (double)gu2, (double)gv2);
                    break;
                }
                case WEST: {
                    if (!tile.isConnectionValidForSide(ForgeDirection.SOUTH)) {
                        v5.func_78374_a((double)dd, (double)dd, (double)dd, (double)u, (double)v2);
                        v5.func_78374_a((double)dd, (double)dd, (double)(dd + dl), (double)(u + du), (double)v2);
                        v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(dd + dl), (double)(u + du), (double)v);
                        v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.NORTH)) {
                        v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd - dl), (double)(u2 - du), (double)v2);
                        v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                        v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                        v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd - dl), (double)(u2 - du), (double)v);
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.UP)) {
                        v5.func_78374_a((double)dd, (double)dd, (double)dd, (double)u, (double)v2);
                        v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                        v5.func_78374_a((double)dd, (double)(dd + dl), (double)(1.0f - dd), (double)u2, (double)(v2 - dv));
                        v5.func_78374_a((double)dd, (double)(dd + dl), (double)dd, (double)u, (double)(v2 - dv));
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.DOWN)) {
                        v5.func_78374_a((double)dd, (double)(1.0f - dd - dl), (double)dd, (double)u, (double)(v + dv));
                        v5.func_78374_a((double)dd, (double)(1.0f - dd - dl), (double)(1.0f - dd), (double)u2, (double)(v + dv));
                        v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                        v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                    }
                    v5.func_78374_a((double)dd, (double)my, (double)mx, (double)gu2, (double)gv2);
                    v5.func_78374_a((double)dd, (double)my, (double)lx, (double)gu, (double)gv2);
                    v5.func_78374_a((double)dd, (double)ly, (double)lx, (double)gu, (double)gv);
                    v5.func_78374_a((double)dd, (double)ly, (double)mx, (double)gu2, (double)gv);
                    if (tile.isConnectionValidForSide(ForgeDirection.NORTH)) {
                        v5.func_78374_a((double)dd, (double)my, (double)mx + 0.5, (double)gu2, (double)gv2);
                        v5.func_78374_a((double)dd, (double)my, (double)lx + 0.5, (double)gu, (double)gv2);
                        v5.func_78374_a((double)dd, (double)ly, (double)lx + 0.5, (double)gu, (double)gv);
                        v5.func_78374_a((double)dd, (double)ly, (double)mx + 0.5, (double)gu2, (double)gv);
                    }
                    if (tile.isConnectionValidForSide(ForgeDirection.SOUTH)) {
                        v5.func_78374_a((double)dd, (double)my, (double)mx - 0.5, (double)gu2, (double)gv2);
                        v5.func_78374_a((double)dd, (double)my, (double)lx - 0.5, (double)gu, (double)gv2);
                        v5.func_78374_a((double)dd, (double)ly, (double)lx - 0.5, (double)gu, (double)gv);
                        v5.func_78374_a((double)dd, (double)ly, (double)mx - 0.5, (double)gu2, (double)gv);
                    }
                    if (tile.isConnectionValidForSide(ForgeDirection.UP)) {
                        v5.func_78374_a((double)dd, (double)my - 0.5, (double)mx, (double)gu2, (double)gv2);
                        v5.func_78374_a((double)dd, (double)my - 0.5, (double)lx, (double)gu, (double)gv2);
                        v5.func_78374_a((double)dd, (double)ly - 0.5, (double)lx, (double)gu, (double)gv);
                        v5.func_78374_a((double)dd, (double)ly - 0.5, (double)mx, (double)gu2, (double)gv);
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.DOWN)) break;
                    v5.func_78374_a((double)dd, (double)my + 0.5, (double)mx, (double)gu2, (double)gv2);
                    v5.func_78374_a((double)dd, (double)my + 0.5, (double)lx, (double)gu, (double)gv2);
                    v5.func_78374_a((double)dd, (double)ly + 0.5, (double)lx, (double)gu, (double)gv);
                    v5.func_78374_a((double)dd, (double)ly + 0.5, (double)mx, (double)gu2, (double)gv);
                    break;
                }
                case UP: {
                    if (!tile.isConnectionValidForSide(ForgeDirection.WEST)) {
                        v5.func_78374_a((double)dd, (double)dd, (double)dd, (double)u, (double)v2);
                        v5.func_78374_a((double)(dd + dl), (double)dd, (double)dd, (double)(u + du), (double)v2);
                        v5.func_78374_a((double)(dd + dl), (double)dd, (double)(1.0f - dd), (double)(u + du), (double)v);
                        v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd), (double)u, (double)v);
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.EAST)) {
                        v5.func_78374_a((double)(1.0f - dd - dl), (double)dd, (double)dd, (double)(u2 - du), (double)v2);
                        v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)dd, (double)u2, (double)v2);
                        v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd), (double)u2, (double)v);
                        v5.func_78374_a((double)(1.0f - dd - dl), (double)dd, (double)(1.0f - dd), (double)(u2 - du), (double)v);
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.SOUTH)) {
                        v5.func_78374_a((double)dd, (double)dd, (double)dd, (double)u, (double)v2);
                        v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)dd, (double)u2, (double)v2);
                        v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(dd + dl), (double)u2, (double)(v2 - dv));
                        v5.func_78374_a((double)dd, (double)dd, (double)(dd + dl), (double)u, (double)(v2 - dv));
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.NORTH)) {
                        v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd - dl), (double)u, (double)(v + dv));
                        v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd - dl), (double)u2, (double)(v + dv));
                        v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd), (double)u2, (double)v);
                        v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd), (double)u, (double)v);
                    }
                    v5.func_78374_a((double)mx, (double)dd, (double)my, (double)gu2, (double)gv2);
                    v5.func_78374_a((double)lx, (double)dd, (double)my, (double)gu, (double)gv2);
                    v5.func_78374_a((double)lx, (double)dd, (double)ly, (double)gu, (double)gv);
                    v5.func_78374_a((double)mx, (double)dd, (double)ly, (double)gu2, (double)gv);
                    if (tile.isConnectionValidForSide(ForgeDirection.EAST)) {
                        v5.func_78374_a((double)mx + 0.5, (double)dd, (double)my, (double)gu2, (double)gv2);
                        v5.func_78374_a((double)lx + 0.5, (double)dd, (double)my, (double)gu, (double)gv2);
                        v5.func_78374_a((double)lx + 0.5, (double)dd, (double)ly, (double)gu, (double)gv);
                        v5.func_78374_a((double)mx + 0.5, (double)dd, (double)ly, (double)gu2, (double)gv);
                    }
                    if (tile.isConnectionValidForSide(ForgeDirection.WEST)) {
                        v5.func_78374_a((double)mx - 0.5, (double)dd, (double)my, (double)gu2, (double)gv2);
                        v5.func_78374_a((double)lx - 0.5, (double)dd, (double)my, (double)gu, (double)gv2);
                        v5.func_78374_a((double)lx - 0.5, (double)dd, (double)ly, (double)gu, (double)gv);
                        v5.func_78374_a((double)mx - 0.5, (double)dd, (double)ly, (double)gu2, (double)gv);
                    }
                    if (tile.isConnectionValidForSide(ForgeDirection.NORTH)) {
                        v5.func_78374_a((double)mx, (double)dd, (double)my + 0.5, (double)gu2, (double)gv2);
                        v5.func_78374_a((double)lx, (double)dd, (double)my + 0.5, (double)gu, (double)gv2);
                        v5.func_78374_a((double)lx, (double)dd, (double)ly + 0.5, (double)gu, (double)gv);
                        v5.func_78374_a((double)mx, (double)dd, (double)ly + 0.5, (double)gu2, (double)gv);
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.SOUTH)) break;
                    v5.func_78374_a((double)mx, (double)dd, (double)my - 0.5, (double)gu2, (double)gv2);
                    v5.func_78374_a((double)lx, (double)dd, (double)my - 0.5, (double)gu, (double)gv2);
                    v5.func_78374_a((double)lx, (double)dd, (double)ly - 0.5, (double)gu, (double)gv);
                    v5.func_78374_a((double)mx, (double)dd, (double)ly - 0.5, (double)gu2, (double)gv);
                    break;
                }
                case SOUTH: {
                    if (!tile.isConnectionValidForSide(ForgeDirection.WEST)) {
                        v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                        v5.func_78374_a((double)(dd + dl), (double)(1.0f - dd), (double)dd, (double)(u + du), (double)v);
                        v5.func_78374_a((double)(dd + dl), (double)dd, (double)dd, (double)(u + du), (double)v2);
                        v5.func_78374_a((double)dd, (double)dd, (double)dd, (double)u, (double)v2);
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.EAST)) {
                        v5.func_78374_a((double)(1.0f - dd - dl), (double)(1.0f - dd), (double)dd, (double)(u2 - du), (double)v);
                        v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)dd, (double)u2, (double)v);
                        v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)dd, (double)u2, (double)v2);
                        v5.func_78374_a((double)(1.0f - dd - dl), (double)dd, (double)dd, (double)(u2 - du), (double)v2);
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.UP)) {
                        v5.func_78374_a((double)dd, (double)(dd + dl), (double)dd, (double)u, (double)(v2 - dv));
                        v5.func_78374_a((double)(1.0f - dd), (double)(dd + dl), (double)dd, (double)u2, (double)(v2 - dv));
                        v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)dd, (double)u2, (double)v2);
                        v5.func_78374_a((double)dd, (double)dd, (double)dd, (double)u, (double)v2);
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.DOWN)) {
                        v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                        v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)dd, (double)u2, (double)v);
                        v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd - dl), (double)dd, (double)u2, (double)(v + dv));
                        v5.func_78374_a((double)dd, (double)(1.0f - dd - dl), (double)dd, (double)u, (double)(v + dv));
                    }
                    v5.func_78374_a((double)mx, (double)ly, (double)dd, (double)gu2, (double)gv);
                    v5.func_78374_a((double)lx, (double)ly, (double)dd, (double)gu, (double)gv);
                    v5.func_78374_a((double)lx, (double)my, (double)dd, (double)gu, (double)gv2);
                    v5.func_78374_a((double)mx, (double)my, (double)dd, (double)gu2, (double)gv2);
                    if (tile.isConnectionValidForSide(ForgeDirection.EAST)) {
                        v5.func_78374_a((double)mx + 0.5, (double)ly, (double)dd, (double)gu2, (double)gv);
                        v5.func_78374_a((double)lx + 0.5, (double)ly, (double)dd, (double)gu, (double)gv);
                        v5.func_78374_a((double)lx + 0.5, (double)my, (double)dd, (double)gu, (double)gv2);
                        v5.func_78374_a((double)mx + 0.5, (double)my, (double)dd, (double)gu2, (double)gv2);
                    }
                    if (tile.isConnectionValidForSide(ForgeDirection.WEST)) {
                        v5.func_78374_a((double)mx - 0.5, (double)ly, (double)dd, (double)gu2, (double)gv);
                        v5.func_78374_a((double)lx - 0.5, (double)ly, (double)dd, (double)gu, (double)gv);
                        v5.func_78374_a((double)lx - 0.5, (double)my, (double)dd, (double)gu, (double)gv2);
                        v5.func_78374_a((double)mx - 0.5, (double)my, (double)dd, (double)gu2, (double)gv2);
                    }
                    if (tile.isConnectionValidForSide(ForgeDirection.DOWN)) {
                        v5.func_78374_a((double)mx, (double)ly + 0.5, (double)dd, (double)gu2, (double)gv);
                        v5.func_78374_a((double)lx, (double)ly + 0.5, (double)dd, (double)gu, (double)gv);
                        v5.func_78374_a((double)lx, (double)my + 0.5, (double)dd, (double)gu, (double)gv2);
                        v5.func_78374_a((double)mx, (double)my + 0.5, (double)dd, (double)gu2, (double)gv2);
                    }
                    if (!tile.isConnectionValidForSide(ForgeDirection.UP)) break;
                    v5.func_78374_a((double)mx, (double)ly - 0.5, (double)dd, (double)gu2, (double)gv);
                    v5.func_78374_a((double)lx, (double)ly - 0.5, (double)dd, (double)gu, (double)gv);
                    v5.func_78374_a((double)lx, (double)my - 0.5, (double)dd, (double)gu, (double)gv2);
                    v5.func_78374_a((double)mx, (double)my - 0.5, (double)dd, (double)gu2, (double)gv2);
                    break;
                }
            }
        }
        if (tile.isConnectedToNonSelf(dir)) {
            switch (dir) {
                case DOWN: {
                    v5.func_78374_a((double)dd, 1.0, (double)(1.0f - dd), (double)u, (double)v);
                    v5.func_78374_a((double)(dd + dl), 1.0, (double)(1.0f - dd), (double)(u + du), (double)v);
                    v5.func_78374_a((double)(dd + dl), 1.0, (double)dd, (double)(u + du), (double)v2);
                    v5.func_78374_a((double)dd, 1.0, (double)dd, (double)u, (double)v2);
                    v5.func_78374_a((double)(1.0f - dd - dl), 1.0, (double)(1.0f - dd), (double)(u2 - du), (double)v);
                    v5.func_78374_a((double)(1.0f - dd), 1.0, (double)(1.0f - dd), (double)u2, (double)v);
                    v5.func_78374_a((double)(1.0f - dd), 1.0, (double)dd, (double)u2, (double)v2);
                    v5.func_78374_a((double)(1.0f - dd - dl), 1.0, (double)dd, (double)(u2 - du), (double)v2);
                    v5.func_78374_a((double)dd, 1.0, (double)(dd + dl), (double)u, (double)(v2 - dv));
                    v5.func_78374_a((double)(1.0f - dd), 1.0, (double)(dd + dl), (double)u2, (double)(v2 - dv));
                    v5.func_78374_a((double)(1.0f - dd), 1.0, (double)dd, (double)u2, (double)v2);
                    v5.func_78374_a((double)dd, 1.0, (double)dd, (double)u, (double)v2);
                    v5.func_78374_a((double)dd, 1.0, (double)(1.0f - dd), (double)u, (double)v);
                    v5.func_78374_a((double)(1.0f - dd), 1.0, (double)(1.0f - dd), (double)u2, (double)v);
                    v5.func_78374_a((double)(1.0f - dd), 1.0, (double)(1.0f - dd - dl), (double)u2, (double)(v + dv));
                    v5.func_78374_a((double)dd, 1.0, (double)(1.0f - dd - dl), (double)u, (double)(v + dv));
                    break;
                }
                case UP: {
                    v5.func_78374_a((double)dd, 0.0, (double)dd, (double)u, (double)v2);
                    v5.func_78374_a((double)(dd + dl), 0.0, (double)dd, (double)(u + du), (double)v2);
                    v5.func_78374_a((double)(dd + dl), 0.0, (double)(1.0f - dd), (double)(u + du), (double)v);
                    v5.func_78374_a((double)dd, 0.0, (double)(1.0f - dd), (double)u, (double)v);
                    v5.func_78374_a((double)(1.0f - dd - dl), 0.0, (double)dd, (double)(u2 - du), (double)v2);
                    v5.func_78374_a((double)(1.0f - dd), 0.0, (double)dd, (double)u2, (double)v2);
                    v5.func_78374_a((double)(1.0f - dd), 0.0, (double)(1.0f - dd), (double)u2, (double)v);
                    v5.func_78374_a((double)(1.0f - dd - dl), 0.0, (double)(1.0f - dd), (double)(u2 - du), (double)v);
                    v5.func_78374_a((double)dd, 0.0, (double)dd, (double)u, (double)v2);
                    v5.func_78374_a((double)(1.0f - dd), 0.0, (double)dd, (double)u2, (double)v2);
                    v5.func_78374_a((double)(1.0f - dd), 0.0, (double)(dd + dl), (double)u2, (double)(v2 - dv));
                    v5.func_78374_a((double)dd, 0.0, (double)(dd + dl), (double)u, (double)(v2 - dv));
                    v5.func_78374_a((double)dd, 0.0, (double)(1.0f - dd - dl), (double)u, (double)(v + dv));
                    v5.func_78374_a((double)(1.0f - dd), 0.0, (double)(1.0f - dd - dl), (double)u2, (double)(v + dv));
                    v5.func_78374_a((double)(1.0f - dd), 0.0, (double)(1.0f - dd), (double)u2, (double)v);
                    v5.func_78374_a((double)dd, 0.0, (double)(1.0f - dd), (double)u, (double)v);
                    break;
                }
                case SOUTH: {
                    v5.func_78374_a((double)dd, (double)(1.0f - dd), 0.0, (double)u, (double)v);
                    v5.func_78374_a((double)(dd + dl), (double)(1.0f - dd), 0.0, (double)(u + du), (double)v);
                    v5.func_78374_a((double)(dd + dl), (double)dd, 0.0, (double)(u + du), (double)v2);
                    v5.func_78374_a((double)dd, (double)dd, 0.0, (double)u, (double)v2);
                    v5.func_78374_a((double)(1.0f - dd - dl), (double)(1.0f - dd), 0.0, (double)(u2 - du), (double)v);
                    v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), 0.0, (double)u2, (double)v);
                    v5.func_78374_a((double)(1.0f - dd), (double)dd, 0.0, (double)u2, (double)v2);
                    v5.func_78374_a((double)(1.0f - dd - dl), (double)dd, 0.0, (double)(u2 - du), (double)v2);
                    v5.func_78374_a((double)dd, (double)(dd + dl), 0.0, (double)u, (double)(v2 - dv));
                    v5.func_78374_a((double)(1.0f - dd), (double)(dd + dl), 0.0, (double)u2, (double)(v2 - dv));
                    v5.func_78374_a((double)(1.0f - dd), (double)dd, 0.0, (double)u2, (double)v2);
                    v5.func_78374_a((double)dd, (double)dd, 0.0, (double)u, (double)v2);
                    v5.func_78374_a((double)dd, (double)(1.0f - dd), 0.0, (double)u, (double)v);
                    v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), 0.0, (double)u2, (double)v);
                    v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd - dl), 0.0, (double)u2, (double)(v + dv));
                    v5.func_78374_a((double)dd, (double)(1.0f - dd - dl), 0.0, (double)u, (double)(v + dv));
                    break;
                }
                case NORTH: {
                    v5.func_78374_a((double)dd, (double)dd, 1.0, (double)u, (double)v2);
                    v5.func_78374_a((double)(dd + dl), (double)dd, 1.0, (double)(u + du), (double)v2);
                    v5.func_78374_a((double)(dd + dl), (double)(1.0f - dd), 1.0, (double)(u + du), (double)v);
                    v5.func_78374_a((double)dd, (double)(1.0f - dd), 1.0, (double)u, (double)v);
                    v5.func_78374_a((double)(1.0f - dd - dl), (double)dd, 1.0, (double)(u2 - du), (double)v2);
                    v5.func_78374_a((double)(1.0f - dd), (double)dd, 1.0, (double)u2, (double)v2);
                    v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), 1.0, (double)u2, (double)v);
                    v5.func_78374_a((double)(1.0f - dd - dl), (double)(1.0f - dd), 1.0, (double)(u2 - du), (double)v);
                    v5.func_78374_a((double)dd, (double)dd, 1.0, (double)u, (double)v2);
                    v5.func_78374_a((double)(1.0f - dd), (double)dd, 1.0, (double)u2, (double)v2);
                    v5.func_78374_a((double)(1.0f - dd), (double)(dd + dl), 1.0, (double)u2, (double)(v2 - dv));
                    v5.func_78374_a((double)dd, (double)(dd + dl), 1.0, (double)u, (double)(v2 - dv));
                    v5.func_78374_a((double)dd, (double)(1.0f - dd - dl), 1.0, (double)u, (double)(v + dv));
                    v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd - dl), 1.0, (double)u2, (double)(v + dv));
                    v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), 1.0, (double)u2, (double)v);
                    v5.func_78374_a((double)dd, (double)(1.0f - dd), 1.0, (double)u, (double)v);
                    break;
                }
                case EAST: {
                    v5.func_78374_a(1.0, (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                    v5.func_78374_a(1.0, (double)(1.0f - dd), (double)(dd + dl), (double)(u + du), (double)v);
                    v5.func_78374_a(1.0, (double)dd, (double)(dd + dl), (double)(u + du), (double)v2);
                    v5.func_78374_a(1.0, (double)dd, (double)dd, (double)u, (double)v2);
                    v5.func_78374_a(1.0, (double)(1.0f - dd), (double)(1.0f - dd - dl), (double)(u2 - du), (double)v);
                    v5.func_78374_a(1.0, (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                    v5.func_78374_a(1.0, (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                    v5.func_78374_a(1.0, (double)dd, (double)(1.0f - dd - dl), (double)(u2 - du), (double)v2);
                    v5.func_78374_a(1.0, (double)(dd + dl), (double)dd, (double)u, (double)(v2 - dv));
                    v5.func_78374_a(1.0, (double)(dd + dl), (double)(1.0f - dd), (double)u2, (double)(v2 - dv));
                    v5.func_78374_a(1.0, (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                    v5.func_78374_a(1.0, (double)dd, (double)dd, (double)u, (double)v2);
                    v5.func_78374_a(1.0, (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                    v5.func_78374_a(1.0, (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                    v5.func_78374_a(1.0, (double)(1.0f - dd - dl), (double)(1.0f - dd), (double)u2, (double)(v + dv));
                    v5.func_78374_a(1.0, (double)(1.0f - dd - dl), (double)dd, (double)u, (double)(v + dv));
                    break;
                }
                case WEST: {
                    v5.func_78374_a(0.0, (double)dd, (double)dd, (double)u, (double)v2);
                    v5.func_78374_a(0.0, (double)dd, (double)(dd + dl), (double)(u + du), (double)v2);
                    v5.func_78374_a(0.0, (double)(1.0f - dd), (double)(dd + dl), (double)(u + du), (double)v);
                    v5.func_78374_a(0.0, (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                    v5.func_78374_a(0.0, (double)dd, (double)(1.0f - dd - dl), (double)(u2 - du), (double)v2);
                    v5.func_78374_a(0.0, (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                    v5.func_78374_a(0.0, (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                    v5.func_78374_a(0.0, (double)(1.0f - dd), (double)(1.0f - dd - dl), (double)(u2 - du), (double)v);
                    v5.func_78374_a(0.0, (double)dd, (double)dd, (double)u, (double)v2);
                    v5.func_78374_a(0.0, (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                    v5.func_78374_a(0.0, (double)(dd + dl), (double)(1.0f - dd), (double)u2, (double)(v2 - dv));
                    v5.func_78374_a(0.0, (double)(dd + dl), (double)dd, (double)u, (double)(v2 - dv));
                    v5.func_78374_a(0.0, (double)(1.0f - dd - dl), (double)dd, (double)u, (double)(v + dv));
                    v5.func_78374_a(0.0, (double)(1.0f - dd - dl), (double)(1.0f - dd), (double)u2, (double)(v + dv));
                    v5.func_78374_a(0.0, (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                    v5.func_78374_a(0.0, (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                    break;
                }
            }
        }
    }

    private void faceBrightness(ForgeDirection dir, Tessellator v5) {
        float f = 1.0f;
        switch (dir.getOpposite()) {
            case DOWN: {
                f = 0.4f;
                break;
            }
            case EAST: {
                f = 0.5f;
                break;
            }
            case NORTH: {
                f = 0.65f;
                break;
            }
            case SOUTH: {
                f = 0.65f;
                break;
            }
            case UP: {
                f = 1.0f;
                break;
            }
            case WEST: {
                f = 0.5f;
                break;
            }
        }
        v5.func_78386_a(f, f, f);
    }

    private void renderInventoryFace(IIcon ico, IIcon gico, ForgeDirection dir) {
        Tessellator v5 = Tessellator.field_78398_a;
        float size = 0.375f;
        float window = 0.25f;
        float dl = size - window;
        float dd = 0.5f - size;
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float u2 = ico.func_94212_f();
        float v2 = ico.func_94210_h();
        float ddu = u2 - u;
        float ddv = v2 - v;
        float uo = u;
        float vo = v;
        float u2o = u2;
        float v2o = v2;
        u += ddu * (1.0f - size) / 5.0f;
        v += ddv * (1.0f - size) / 5.0f;
        u2 -= ddu * (1.0f - size) / 5.0f;
        v2 -= ddv * (1.0f - size) / 5.0f;
        float du = ddu * dd;
        float dv = ddv * dd;
        float lx = dd + dl;
        float ly = dd + dl;
        float mx = 1.0f - dd - dl;
        float my = 1.0f - dd - dl;
        float gu = gico.func_94209_e();
        float gv = gico.func_94206_g();
        float gu2 = gico.func_94212_f();
        float gv2 = gico.func_94210_h();
        float dgu = gu2 - gu;
        float dgv = gv2 - gv;
        float guu = gu + dgu * dl;
        float gvv = gv + dgv * dl;
        gu += dgu / 8.0f;
        gv += dgv / 8.0f;
        gu2 -= dgu / 8.0f;
        gv2 -= dgv / 8.0f;
        this.faceBrightness(dir, v5);
        switch (dir) {
            case DOWN: {
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd), (double)u, (double)v);
                v5.func_78374_a((double)(dd + dl), (double)(1.0f - dd), (double)(1.0f - dd), (double)(u + du), (double)v);
                v5.func_78374_a((double)(dd + dl), (double)(1.0f - dd), (double)dd, (double)(u + du), (double)v2);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)dd, (double)u, (double)v2);
                v5.func_78374_a((double)(1.0f - dd - dl), (double)(1.0f - dd), (double)(1.0f - dd), (double)(u2 - du), (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)dd, (double)u2, (double)v2);
                v5.func_78374_a((double)(1.0f - dd - dl), (double)(1.0f - dd), (double)dd, (double)(u2 - du), (double)v2);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(dd + dl), (double)u, (double)(v2 - dv));
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(dd + dl), (double)u2, (double)(v2 - dv));
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)dd, (double)u2, (double)v2);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)dd, (double)u, (double)v2);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd), (double)u, (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd - dl), (double)u2, (double)(v + dv));
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd - dl), (double)u, (double)(v + dv));
                v5.func_78374_a((double)mx, (double)(1.0f - dd), (double)ly, (double)gu2, (double)gv);
                v5.func_78374_a((double)lx, (double)(1.0f - dd), (double)ly, (double)gu, (double)gv);
                v5.func_78374_a((double)lx, (double)(1.0f - dd), (double)my, (double)gu, (double)gv2);
                v5.func_78374_a((double)mx, (double)(1.0f - dd), (double)my, (double)gu2, (double)gv2);
                break;
            }
            case NORTH: {
                v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd), (double)u, (double)v2);
                v5.func_78374_a((double)(dd + dl), (double)dd, (double)(1.0f - dd), (double)(u + du), (double)v2);
                v5.func_78374_a((double)(dd + dl), (double)(1.0f - dd), (double)(1.0f - dd), (double)(u + du), (double)v);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd), (double)u, (double)v);
                v5.func_78374_a((double)(1.0f - dd - dl), (double)dd, (double)(1.0f - dd), (double)(u2 - du), (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                v5.func_78374_a((double)(1.0f - dd - dl), (double)(1.0f - dd), (double)(1.0f - dd), (double)(u2 - du), (double)v);
                v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd), (double)u, (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)(dd + dl), (double)(1.0f - dd), (double)u2, (double)(v2 - dv));
                v5.func_78374_a((double)dd, (double)(dd + dl), (double)(1.0f - dd), (double)u, (double)(v2 - dv));
                v5.func_78374_a((double)dd, (double)(1.0f - dd - dl), (double)(1.0f - dd), (double)u, (double)(v + dv));
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd - dl), (double)(1.0f - dd), (double)u2, (double)(v + dv));
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd), (double)u, (double)v);
                v5.func_78374_a((double)mx, (double)my, (double)(1.0f - dd), (double)gu2, (double)gv2);
                v5.func_78374_a((double)lx, (double)my, (double)(1.0f - dd), (double)gu, (double)gv2);
                v5.func_78374_a((double)lx, (double)ly, (double)(1.0f - dd), (double)gu, (double)gv);
                v5.func_78374_a((double)mx, (double)ly, (double)(1.0f - dd), (double)gu2, (double)gv);
                break;
            }
            case EAST: {
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(dd + dl), (double)(u + du), (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(dd + dl), (double)(u + du), (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)dd, (double)u, (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd - dl), (double)(u2 - du), (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd - dl), (double)(u2 - du), (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)(dd + dl), (double)dd, (double)u, (double)(v2 - dv));
                v5.func_78374_a((double)(1.0f - dd), (double)(dd + dl), (double)(1.0f - dd), (double)u2, (double)(v2 - dv));
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)dd, (double)u, (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd - dl), (double)(1.0f - dd), (double)u2, (double)(v + dv));
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd - dl), (double)dd, (double)u, (double)(v + dv));
                v5.func_78374_a((double)(1.0f - dd), (double)ly, (double)mx, (double)gu2, (double)gv);
                v5.func_78374_a((double)(1.0f - dd), (double)ly, (double)lx, (double)gu, (double)gv);
                v5.func_78374_a((double)(1.0f - dd), (double)my, (double)lx, (double)gu, (double)gv2);
                v5.func_78374_a((double)(1.0f - dd), (double)my, (double)mx, (double)gu2, (double)gv2);
                break;
            }
            case WEST: {
                v5.func_78374_a((double)dd, (double)dd, (double)dd, (double)u, (double)v2);
                v5.func_78374_a((double)dd, (double)dd, (double)(dd + dl), (double)(u + du), (double)v2);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(dd + dl), (double)(u + du), (double)v);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd - dl), (double)(u2 - du), (double)v2);
                v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd - dl), (double)(u2 - du), (double)v);
                v5.func_78374_a((double)dd, (double)dd, (double)dd, (double)u, (double)v2);
                v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                v5.func_78374_a((double)dd, (double)(dd + dl), (double)(1.0f - dd), (double)u2, (double)(v2 - dv));
                v5.func_78374_a((double)dd, (double)(dd + dl), (double)dd, (double)u, (double)(v2 - dv));
                v5.func_78374_a((double)dd, (double)(1.0f - dd - dl), (double)dd, (double)u, (double)(v + dv));
                v5.func_78374_a((double)dd, (double)(1.0f - dd - dl), (double)(1.0f - dd), (double)u2, (double)(v + dv));
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                v5.func_78374_a((double)dd, (double)my, (double)mx, (double)gu2, (double)gv2);
                v5.func_78374_a((double)dd, (double)my, (double)lx, (double)gu, (double)gv2);
                v5.func_78374_a((double)dd, (double)ly, (double)lx, (double)gu, (double)gv);
                v5.func_78374_a((double)dd, (double)ly, (double)mx, (double)gu2, (double)gv);
                break;
            }
            case UP: {
                v5.func_78374_a((double)dd, (double)dd, (double)dd, (double)u, (double)v2);
                v5.func_78374_a((double)(dd + dl), (double)dd, (double)dd, (double)(u + du), (double)v2);
                v5.func_78374_a((double)(dd + dl), (double)dd, (double)(1.0f - dd), (double)(u + du), (double)v);
                v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd), (double)u, (double)v);
                v5.func_78374_a((double)(1.0f - dd - dl), (double)dd, (double)dd, (double)(u2 - du), (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)dd, (double)u2, (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd), (double)u2, (double)v);
                v5.func_78374_a((double)(1.0f - dd - dl), (double)dd, (double)(1.0f - dd), (double)(u2 - du), (double)v);
                v5.func_78374_a((double)dd, (double)dd, (double)dd, (double)u, (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)dd, (double)u2, (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(dd + dl), (double)u2, (double)(v2 - dv));
                v5.func_78374_a((double)dd, (double)dd, (double)(dd + dl), (double)u, (double)(v2 - dv));
                v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd - dl), (double)u, (double)(v + dv));
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd - dl), (double)u2, (double)(v + dv));
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd), (double)u2, (double)v);
                v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd), (double)u, (double)v);
                v5.func_78374_a((double)mx, (double)dd, (double)my, (double)gu2, (double)gv2);
                v5.func_78374_a((double)lx, (double)dd, (double)my, (double)gu, (double)gv2);
                v5.func_78374_a((double)lx, (double)dd, (double)ly, (double)gu, (double)gv);
                v5.func_78374_a((double)mx, (double)dd, (double)ly, (double)gu2, (double)gv);
                break;
            }
            case SOUTH: {
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                v5.func_78374_a((double)(dd + dl), (double)(1.0f - dd), (double)dd, (double)(u + du), (double)v);
                v5.func_78374_a((double)(dd + dl), (double)dd, (double)dd, (double)(u + du), (double)v2);
                v5.func_78374_a((double)dd, (double)dd, (double)dd, (double)u, (double)v2);
                v5.func_78374_a((double)(1.0f - dd - dl), (double)(1.0f - dd), (double)dd, (double)(u2 - du), (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)dd, (double)u2, (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)dd, (double)u2, (double)v2);
                v5.func_78374_a((double)(1.0f - dd - dl), (double)dd, (double)dd, (double)(u2 - du), (double)v2);
                v5.func_78374_a((double)dd, (double)(dd + dl), (double)dd, (double)u, (double)(v2 - dv));
                v5.func_78374_a((double)(1.0f - dd), (double)(dd + dl), (double)dd, (double)u2, (double)(v2 - dv));
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)dd, (double)u2, (double)v2);
                v5.func_78374_a((double)dd, (double)dd, (double)dd, (double)u, (double)v2);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)dd, (double)u2, (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd - dl), (double)dd, (double)u2, (double)(v + dv));
                v5.func_78374_a((double)dd, (double)(1.0f - dd - dl), (double)dd, (double)u, (double)(v + dv));
                v5.func_78374_a((double)mx, (double)ly, (double)dd, (double)gu2, (double)gv);
                v5.func_78374_a((double)lx, (double)ly, (double)dd, (double)gu, (double)gv);
                v5.func_78374_a((double)lx, (double)my, (double)dd, (double)gu, (double)gv2);
                v5.func_78374_a((double)mx, (double)my, (double)dd, (double)gu2, (double)gv2);
                break;
            }
        }
    }
}

