/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface.NEI;

import Reika.DragonAPI.Libraries.IO.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.IO.ReikaLiquidRenderer;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesDryingBed;
import Reika.RotaryCraft.GUIs.Machine.Inventory.GuiDryer;
import Reika.RotaryCraft.RotaryCraft;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class DryingBedHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Drying Bed";
    }

    public String getGuiTexture() {
        return "/Reika/RotaryCraft/Textures/GUI/drygui.png";
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        GL11.glDisable((int)2929);
        ReikaGuiAPI.instance.drawTexturedModalRectWithDepth(0, 1, 5, 11, 166, 70, ReikaGuiAPI.NEI_DEPTH);
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        this.drawExtras(recipe);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(23, 15, 94, 22), "rcdrying", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId != null && outputId.equals("rcdrying")) {
            Collection<Fluid> li = RecipesDryingBed.getRecipes().getAllRecipes();
            for (Fluid f : li) {
                this.arecipes.add(new DryingBedRecipe(f));
            }
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId != null && inputId.equals("rcdrying")) {
            this.loadCraftingRecipes(inputId, ingredients);
        }
        super.loadUsageRecipes(inputId, ingredients);
    }

    public void loadCraftingRecipes(ItemStack result) {
        Fluid f = RecipesDryingBed.getRecipes().getRecipe(result);
        if (f != null) {
            this.arecipes.add(new DryingBedRecipe(f));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ItemStack is;
        FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)ingredient);
        if (fs != null && (is = RecipesDryingBed.getRecipes().getDryingResult(fs)) != null) {
            this.arecipes.add(new DryingBedRecipe(fs.getFluid()));
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiDryer.class;
    }

    public void drawExtras(int recipe) {
        this.drawFluids(recipe);
    }

    private void drawFluids(int recipe) {
        DryingBedRecipe r = (DryingBedRecipe)((Object)this.arecipes.get(recipe));
        FluidStack fs = r.getEntry();
        if (fs != null) {
            Fluid f = fs.getFluid();
            IIcon ico = ReikaLiquidRenderer.getFluidIconSafe((Fluid)f);
            float u = ico.func_94209_e();
            float v = ico.func_94206_g();
            float du = ico.func_94212_f();
            float dv = ico.func_94210_h();
            ReikaTextureHelper.bindTerrainTexture();
            Tessellator v5 = Tessellator.field_78398_a;
            v5.func_78382_b();
            for (int i = 0; i < 4; ++i) {
                int y = 2 + i * 16;
                v5.func_78374_a(3.0, (double)y, 0.0, (double)u, (double)v);
                v5.func_78374_a(3.0, (double)(y + 16), 0.0, (double)u, (double)dv);
                v5.func_78374_a(19.0, (double)(y + 16), 0.0, (double)du, (double)dv);
                v5.func_78374_a(19.0, (double)y, 0.0, (double)du, (double)v);
            }
            float v2 = v + (dv - v) * 5.0f / 16.0f;
            v5.func_78374_a(3.0, 64.0, 0.0, (double)u, (double)v2);
            v5.func_78374_a(3.0, 69.0, 0.0, (double)u, (double)v);
            v5.func_78374_a(19.0, 69.0, 0.0, (double)du, (double)v);
            v5.func_78374_a(19.0, 64.0, 0.0, (double)du, (double)v2);
            v5.func_78381_a();
            int x = 23;
            int y = 57;
            String s = String.format("%s: %d mB", fs.getLocalizedName(), fs.amount);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(s, x, y, 0);
        }
    }

    public class DryingBedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private Fluid input;

        private DryingBedRecipe(Fluid in) {
            super((TemplateRecipeHandler)DryingBedHandler.this);
            this.input = in;
        }

        public PositionedStack getResult() {
            if (this.input != null) {
                ItemStack is = this.getOutput();
                return new PositionedStack((Object)is, 120, 25);
            }
            return null;
        }

        private ItemStack getOutput() {
            return RecipesDryingBed.getRecipes().getDryingResult(new FluidStack(this.input, 16000));
        }

        public PositionedStack getIngredient() {
            return null;
        }

        public FluidStack getEntry() {
            return new FluidStack(this.input, RecipesDryingBed.getRecipes().getRecipeConsumption(this.getOutput()));
        }
    }
}

