/*
 * Decompiled with CFR 0.152.
 */
package murlen.util.fscript.introspection;

import java.lang.reflect.Method;
import murlen.util.fscript.introspection.IntrospectorBase;
import murlen.util.fscript.introspection.MethodMap;

public class Introspector
extends IntrospectorBase {
    public static final String CACHEDUMP_MSG = "Introspector : detected classloader change. Dumping cache.";

    @Override
    public Method getMethod(Class c, String name, Object[] params) throws Exception {
        try {
            return super.getMethod(c, name, params);
        }
        catch (MethodMap.AmbiguousException ae) {
            String msg = "Introspection Error : Ambiguous method invocation " + name + "( ";
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    msg = msg + ", ";
                }
                msg = msg + params[i].getClass().getName();
            }
            msg = msg + ") for class " + c;
            return null;
        }
    }

    @Override
    protected void clearCache() {
        super.clearCache();
    }
}

