/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.rfpowermeter.render;

import com.bymarcin.zettaindustries.mods.rfpowermeter.RFMeterTileEntity;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RFMeterRender
extends TileEntitySpecialRenderer
implements IItemRenderer {
    static ResourceLocation cTexture = new ResourceLocation("zettaindustries", "textures/blocks/counter.png");
    Tessellator tes = Tessellator.field_78398_a;
    double j = 0.0;

    public void drawDirection(Tessellator tes, float r, float g, float b, boolean isInverted) {
        GL11.glPushMatrix();
        int width = 6;
        int height = 7;
        int x = 56;
        int y = 40;
        tes.func_78373_b(0.45, -0.3333333432674408, 0.0);
        tes.func_78382_b();
        tes.func_78380_c(0xF000F0);
        tes.func_78369_a(r, g, b, 1.0f);
        tes.func_78375_b(0.0f, 0.0f, -1.0f);
        if (isInverted) {
            tes.func_78374_a(0.0, 0.0, 0.0, (double)(x + width) / 64.0, (double)(y + height) / 64.0);
            tes.func_78374_a(0.0, 0.23333333333333334, 0.0, (double)(x + width) / 64.0, (double)y / 64.0);
            tes.func_78374_a(0.2, 0.23333333333333334, 0.0, (double)x / 64.0, (double)y / 64.0);
            tes.func_78374_a(0.2, 0.0, 0.0, (double)x / 64.0, (double)(y + height) / 64.0);
        } else {
            tes.func_78374_a(0.0, 0.0, 0.0, (double)(x + width) / 64.0, (double)y / 64.0);
            tes.func_78374_a(0.0, 0.23333333333333334, 0.0, (double)(x + width) / 64.0, (double)(y + height) / 64.0);
            tes.func_78374_a(0.2, 0.23333333333333334, 0.0, (double)x / 64.0, (double)(y + height) / 64.0);
            tes.func_78374_a(0.2, 0.0, 0.0, (double)x / 64.0, (double)y / 64.0);
        }
        tes.func_78381_a();
        tes.func_78373_b(0.0, 0.0, 0.0);
        GL11.glPopMatrix();
    }

    public void render(double x, double y, double z, int metadata, int mixedBrightnessForBlock, long currentValue, int transfer, float r, float g, float b, boolean isInverted) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.tes.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
        switch (metadata) {
            case 0: {
                GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case 1: {
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                GL11.glRotated((double)270.0, (double)0.0, (double)1.0, (double)0.0);
            }
        }
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        this.func_147499_a(cTexture);
        float s = 0.25581396f;
        GL11.glPushMatrix();
        GL11.glScaled((double)0.5, (double)0.5, (double)1.0);
        GL11.glTranslated((double)0.5, (double)(1.75f - s), (double)0.1855f);
        this.drawNumber(transfer, r, g, b, false);
        GL11.glTranslated((double)0.0, (double)(-0.115625 - (double)s), (double)0.0);
        long total = currentValue;
        int unit = 0;
        total *= 10L;
        while (Math.ceil(Math.log10(total)) > 6.0) {
            ++unit;
            total /= 1000L;
        }
        this.drawNumber(total, r, g, b, true);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.296875, (double)0.375, (double)0.1865);
        GL11.glScaled((double)0.36363636363636365, (double)0.36363636363636365, (double)1.0);
        this.drawSI(SI.reverse[unit], r, g, b);
        this.drawDirection(this.tes, r, g, b, isInverted);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float delta) {
        if (!(te instanceof RFMeterTileEntity)) {
            return;
        }
        RFMeterTileEntity tile = (RFMeterTileEntity)te;
        this.render(x, y, z, tile.func_145832_p(), te.func_145831_w().func_147439_a(te.field_145851_c, te.field_145848_d, te.field_145849_e).func_149677_c((IBlockAccess)te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e), tile.getCurrentValue(), tile.getTransfer(), tile.r, tile.g, tile.b, tile.isInverted());
    }

    private void drawSI(SI value, float r, float g, float b) {
        GL11.glPushMatrix();
        for (SI si : SI.values()) {
            if (si == SI.none) continue;
            if (si == value) {
                si.drawActive(this.tes, r, g, b);
            } else {
                si.drawInActive(this.tes, r, g, b);
            }
            this.tes.func_78372_c(0.23333333f, 0.0f, 0.0f);
        }
        this.tes.func_78373_b(0.0, 0.0, 0.0);
        GL11.glPopMatrix();
    }

    private void drawNumber(long number, float r, float g, float b, boolean dot) {
        GL11.glPushMatrix();
        this.tes.func_78382_b();
        this.tes.func_78375_b(0.0f, 0.0f, -1.0f);
        this.tes.func_78369_a(r * 0.5f, g * 0.5f, b * 0.5f, 1.0f);
        double s = 0.2558139534883721;
        this.tes.func_78374_a(0.0, 0.0, 0.001, 0.671875, 0.34375);
        this.tes.func_78374_a(0.0, s, 0.001, 0.671875, 0.171875);
        this.tes.func_78374_a(1.0, s, 0.001, 0.0, 0.171875);
        this.tes.func_78374_a(1.0, 0.0, 0.001, 0.0, 0.34375);
        this.tes.func_78381_a();
        this.tes.func_78382_b();
        this.tes.func_78369_a(r, g, b, 1.0f);
        this.tes.func_78372_c(-0.023255814f, 0.0f, -0.001f);
        this.tes.func_78380_c(0xF000F0);
        for (int i = 0; number != 0L || i < (dot ? 2 : 1); number /= 10L, ++i) {
            long dig = number % 10L;
            long x = dig * 6L;
            this.tes.func_78375_b(0.0f, 0.0f, -1.0f);
            this.tes.func_78374_a(0.0, 0.0, 0.0, (double)(x + 6L) / 64.0, 0.171875);
            this.tes.func_78374_a(0.0, s, 0.0, (double)(x + 6L) / 64.0, 0.0);
            this.tes.func_78374_a(0.13953488372093023, s, 0.0, (double)x / 64.0, 0.0);
            this.tes.func_78374_a(0.13953488372093023, 0.0, 0.0, (double)x / 64.0, 0.171875);
            this.tes.func_78372_c(0.13953489f, 0.0f, 0.0f);
            if (i != 0) continue;
            if (dot) {
                this.tes.func_78375_b(0.0f, 0.0f, -1.0f);
                this.tes.func_78374_a(0.0, 0.0, 0.0, 0.96875, 0.171875);
                this.tes.func_78374_a(0.0, s, 0.0, 0.96875, 0.0);
                this.tes.func_78374_a(0.046511627906976744, s, 0.0, 0.9375, 0.0);
                this.tes.func_78374_a(0.046511627906976744, 0.0, 0.0, 0.9375, 0.171875);
            }
            this.tes.func_78372_c(0.046511628f, 0.0f, 0.0f);
        }
        this.tes.func_78381_a();
        this.tes.func_78373_b(0.0, 0.0, 0.0);
        GL11.glPopMatrix();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        RenderHelper.func_74519_b();
        if (IItemRenderer.ItemRenderType.ENTITY == type) {
            this.render(-0.5, -0.5, -0.5, 0, 0xF000F0, 0L, 0, 0.0f, 1.0f, 0.0f, false);
        } else {
            this.render(0.0, 0.0, 0.0, 0, 0xF000F0, 0L, 0, 0.0f, 1.0f, 0.0f, false);
        }
    }

    static enum SI {
        P(50, 40),
        T(44, 40),
        G(38, 40),
        M(32, 40),
        K(26, 40),
        none(0, 0);

        int x;
        int y;
        int width;
        int height;
        public static final SI[] reverse;

        private SI(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        private SI(int x, int y) {
            this(x, y, 5, 7);
        }

        private static SI[] valuesReverse() {
            int len = SI.values().length;
            SI[] arr = new SI[len];
            SI[] sIArray = SI.values();
            int n = sIArray.length;
            for (int i = 0; i < n; ++i) {
                SI si;
                arr[len - si.ordinal() - 1] = si = sIArray[i];
            }
            return arr;
        }

        public void drawActive(Tessellator tes, float r, float g, float b) {
            GL11.glPushMatrix();
            tes.func_78382_b();
            tes.func_78380_c(0xF000F0);
            tes.func_78369_a(r, g, b, 1.0f);
            tes.func_78375_b(0.0f, 0.0f, -1.0f);
            tes.func_78374_a(0.0, 0.0, 0.0, (double)(this.x + this.width) / 64.0, (double)(this.y + this.height) / 64.0);
            tes.func_78374_a(0.0, 0.23333333333333334, 0.0, (double)(this.x + this.width) / 64.0, (double)this.y / 64.0);
            tes.func_78374_a(0.16666666666666666, 0.23333333333333334, 0.0, (double)this.x / 64.0, (double)this.y / 64.0);
            tes.func_78374_a(0.16666666666666666, 0.0, 0.0, (double)this.x / 64.0, (double)(this.y + this.height) / 64.0);
            tes.func_78381_a();
            GL11.glPopMatrix();
        }

        public void drawInActive(Tessellator tes, float r, float g, float b) {
            GL11.glPushMatrix();
            tes.func_78382_b();
            tes.func_78369_a(r * 0.25f, g * 0.25f, b * 0.25f, 1.0f);
            tes.func_78375_b(0.0f, 0.0f, -1.0f);
            tes.func_78374_a(0.0, 0.0, 0.0, (double)(this.x + this.width) / 64.0, (double)(this.y + this.height) / 64.0);
            tes.func_78374_a(0.0, 0.23333333333333334, 0.0, (double)(this.x + this.width) / 64.0, (double)this.y / 64.0);
            tes.func_78374_a(0.16666666666666666, 0.23333333333333334, 0.0, (double)this.x / 64.0, (double)this.y / 64.0);
            tes.func_78374_a(0.16666666666666666, 0.0, 0.0, (double)this.x / 64.0, (double)(this.y + this.height) / 64.0);
            tes.func_78381_a();
            GL11.glPopMatrix();
        }

        static {
            reverse = SI.valuesReverse();
        }
    }
}

