/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.rfpowermeter;

import cofh.api.energy.IEnergyHandler;
import com.bymarcin.zettaindustries.mods.rfpowermeter.RFMeterUpdatePacket;
import com.bymarcin.zettaindustries.registry.ZIRegistry;
import com.bymarcin.zettaindustries.utils.Avg;
import com.bymarcin.zettaindustries.utils.MathUtils;
import com.bymarcin.zettaindustries.utils.WorldUtils;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class RFMeterTileEntity
extends TileEntity
implements IEnergyHandler {
    int transfer = 0;
    int transferLimit = -1;
    long value = 0L;
    long lastValue = 0L;
    Avg avg = new Avg();
    String name = "";
    String password = "";
    boolean inCounterMode = true;
    boolean isOn = true;
    boolean isProtected = false;
    boolean isInverted = false;
    int tick = 0;
    public float r;
    public float g = 1.0f;
    public float b;

    public Packet func_145844_m() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74776_a("r", this.r);
        data.func_74776_a("g", this.g);
        data.func_74776_a("b", this.b);
        data.func_74757_a("isInverted", this.isInverted);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, data);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.r = pkt.func_148857_g().func_74760_g("r");
        this.g = pkt.func_148857_g().func_74760_g("g");
        this.b = pkt.func_148857_g().func_74760_g("b");
        this.isInverted = pkt.func_148857_g().func_74767_n("isInverted");
    }

    public void invert() {
        this.isInverted = !this.isInverted;
    }

    public boolean isInverted() {
        return this.isInverted;
    }

    public int getTransfer() {
        return this.transfer;
    }

    public long getCurrentValue() {
        return this.value;
    }

    public void setPassword(String pass) {
        this.password = MathUtils.encryptPassword(pass);
        this.isProtected = true;
    }

    public void removePassword() {
        this.password = "";
        this.isProtected = false;
    }

    public boolean canEdit(String pass) {
        return !this.isProtected || this.isProtected && pass != null && MathUtils.encryptPassword(pass).equals(this.password);
    }

    public boolean canEnergyFlow() {
        return this.isOn && (this.inCounterMode || 0L < this.value);
    }

    public void onPacket(long value, int transfer, boolean inCounterMode) {
        if (WorldUtils.isServerWorld(this.field_145850_b)) {
            return;
        }
        this.value = value;
        this.transfer = transfer;
        this.inCounterMode = inCounterMode;
    }

    public void func_145845_h() {
        ++this.tick;
        if (WorldUtils.isServerWorld(this.field_145850_b)) {
            if (this.tick % 20 == 0) {
                ZIRegistry.packetHandler.sendToAllAround((IMessage)new RFMeterUpdatePacket(this, this.value, this.transfer, this.inCounterMode), new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.field_76574_g, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 32.0));
                this.tick = 0;
            }
            long lastRecive = Math.abs(this.value - this.lastValue);
            this.avg.putValue(lastRecive);
            this.transfer = (int)this.avg.getAvg();
            this.lastValue = this.value;
        } else {
            this.value = this.inCounterMode ? (this.value += (long)this.transfer) : (this.value -= (long)this.transfer);
        }
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return from == ForgeDirection.UP || from == ForgeDirection.DOWN;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!this.canEnergyFlow()) {
            return 0;
        }
        int temp = 0;
        if (from == (this.isInverted ? ForgeDirection.DOWN : ForgeDirection.UP) && WorldUtils.isEnergyHandlerFromSide(this, from)) {
            TileEntity tile = WorldUtils.getAdjacentTileEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.isInverted ? ForgeDirection.UP : ForgeDirection.DOWN);
            if (tile == null || !WorldUtils.isEnergyHandlerFromSide(tile, this.isInverted ? ForgeDirection.DOWN : ForgeDirection.UP)) {
                return 0;
            }
            IEnergyHandler a = (IEnergyHandler)tile;
            temp = a.receiveEnergy(from, this.transferLimit == -1 ? (this.inCounterMode ? maxReceive : Math.min((int)this.value, maxReceive)) : Math.min(this.transferLimit, this.inCounterMode ? maxReceive : Math.min((int)this.value, maxReceive)), simulate);
            if (!simulate) {
                this.value = this.inCounterMode ? (this.value += (long)temp) : (this.value -= (long)temp);
            }
            return temp;
        }
        return 0;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return 10000;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("transfer", this.transfer);
        nbt.func_74768_a("transferLimit", this.transferLimit);
        nbt.func_74772_a("value", this.value);
        nbt.func_74772_a("lastValue", this.lastValue);
        nbt.func_74778_a("name", this.name);
        nbt.func_74778_a("password", this.password);
        nbt.func_74757_a("inCounterMode", this.inCounterMode);
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74757_a("isProtected", this.isProtected);
        nbt.func_74768_a("tick", this.tick);
        nbt.func_74776_a("r", this.r);
        nbt.func_74776_a("g", this.g);
        nbt.func_74776_a("b", this.b);
        nbt.func_74757_a("isInverted", this.isInverted);
    }

    public void getTag(NBTTagCompound nbt) {
        nbt.func_74768_a("transferLimit", this.transferLimit);
        nbt.func_74772_a("value", this.value);
        nbt.func_74772_a("lastValue", this.lastValue);
        nbt.func_74778_a("name", this.name);
        nbt.func_74778_a("password", this.password);
        nbt.func_74757_a("inCounterMode", this.inCounterMode);
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74757_a("isProtected", this.isProtected);
        nbt.func_74776_a("r", this.r);
        nbt.func_74776_a("g", this.g);
        nbt.func_74776_a("b", this.b);
        nbt.func_74757_a("isInverted", this.isInverted);
    }

    public void setTag(NBTTagCompound nbt) {
        if (nbt.func_74764_b("transferLimit")) {
            this.transferLimit = nbt.func_74762_e("transferLimit");
        }
        if (nbt.func_74764_b("value")) {
            this.value = nbt.func_74763_f("value");
        }
        if (nbt.func_74764_b("lastValue")) {
            this.lastValue = nbt.func_74763_f("lastValue");
        }
        if (nbt.func_74764_b("name")) {
            this.name = nbt.func_74779_i("name");
        }
        if (nbt.func_74764_b("password")) {
            this.password = nbt.func_74779_i("password");
        }
        if (nbt.func_74764_b("inCounterMode")) {
            this.inCounterMode = nbt.func_74767_n("inCounterMode");
        }
        if (nbt.func_74764_b("isOn")) {
            this.isOn = nbt.func_74767_n("isOn");
        }
        if (nbt.func_74764_b("isProtected")) {
            this.isProtected = nbt.func_74767_n("isProtected");
        }
        if (nbt.func_74764_b("r")) {
            this.r = nbt.func_74760_g("r");
        }
        if (nbt.func_74764_b("g")) {
            this.g = nbt.func_74760_g("g");
        }
        if (nbt.func_74764_b("b")) {
            this.b = nbt.func_74760_g("b");
        }
        if (nbt.func_74764_b("isInverted")) {
            this.isInverted = nbt.func_74767_n("isInverted");
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("transfer")) {
            this.transfer = nbt.func_74762_e("transfer");
        }
        if (nbt.func_74764_b("transferLimit")) {
            this.transferLimit = nbt.func_74762_e("transferLimit");
        }
        if (nbt.func_74764_b("value")) {
            this.value = nbt.func_74763_f("value");
        }
        if (nbt.func_74764_b("lastValue")) {
            this.lastValue = nbt.func_74763_f("lastValue");
        }
        if (nbt.func_74764_b("name")) {
            this.name = nbt.func_74779_i("name");
        }
        if (nbt.func_74764_b("password")) {
            this.password = nbt.func_74779_i("password");
        }
        if (nbt.func_74764_b("inCounterMode")) {
            this.inCounterMode = nbt.func_74767_n("inCounterMode");
        }
        if (nbt.func_74764_b("isOn")) {
            this.isOn = nbt.func_74767_n("isOn");
        }
        if (nbt.func_74764_b("isProtected")) {
            this.isProtected = nbt.func_74767_n("isProtected");
        }
        if (nbt.func_74764_b("tick")) {
            this.tick = nbt.func_74762_e("tick");
        }
        if (nbt.func_74764_b("r")) {
            this.r = nbt.func_74760_g("r");
        }
        if (nbt.func_74764_b("g")) {
            this.g = nbt.func_74760_g("g");
        }
        if (nbt.func_74764_b("b")) {
            this.b = nbt.func_74760_g("b");
        }
        if (nbt.func_74764_b("isInverted")) {
            this.isInverted = nbt.func_74767_n("isInverted");
        }
    }
}

